/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.setups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.FontFamily;
import pios.emulator.printer.models.FontModel;
import pios.emulator.ui.GBC;

public final class SetupDefaultFontTab
extends JPanel
implements ListSelectionListener {
    private static final String TYPE = PrinterPerf.getResourceString("SetupDefaultFontTab_Type");
    private static final String STYLE = PrinterPerf.getResourceString("SetupDefaultFontTab_Style");
    private static final String SIZE = PrinterPerf.getResourceString("SetupDefaultFontTab_Size");
    private static final String DEFAULTFONT = PrinterPerf.getResourceString("SetupDefaultFontTab_DefaultFont");
    private static final char STYLE_MNEMONIC = PrinterPerf.getResourceString("SetupDefaultFontTab_Style.MNEMONIC").charAt(0);
    private static final char SIZE_MNEMONIC = PrinterPerf.getResourceString("SetupDefaultFontTab_Size.MNEMONIC").charAt(0);
    private JList choices;
    private JLabel fontType = new JLabel(" ");
    private JComboBox fontStyleChoices = new JComboBox();
    private JComboBox fontSizeChoices = new JComboBox();

    public SetupDefaultFontTab() {
        super(new GridLayout(1, 2));
        this.createSelectionList();
        this.createDetailPanel();
        this.valueChanged(null);
        this.choices.ensureIndexIsVisible(this.choices.getSelectedIndex());
    }

    private void createSelectionList() {
        this.choices = new JList(FontModel.getActiveFontFamilyList());
        JScrollPane jScrollPane = new JScrollPane(this.choices, 22, 30);
        this.add(jScrollPane);
        this.choices.addListSelectionListener(this);
        this.choices.setSelectedValue(FontModel.getDefaultFontFamilyName(), true);
        if (this.choices.isSelectionEmpty() && FontModel.getActiveFontFamilyList().size() > 0) {
            this.choices.setSelectedIndex(0);
        }
    }

    private void createDetailPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new EmptyBorder(0, 0, 35, 0));
        jPanel2.add((Component)new JLabel(TYPE), new GBC(0, 0, 1, 1, 0.0, 0.0, 17, 0, 10, 0, 0, 0));
        jPanel2.add((Component)this.fontType, new GBC(1, 0, 1, 1, 0.0, 0.0, 17, 0, 10, 5, 0, 10));
        JLabel jLabel = new JLabel(STYLE);
        jLabel.setDisplayedMnemonic(STYLE_MNEMONIC);
        jLabel.setLabelFor(this.fontStyleChoices);
        jPanel2.add((Component)jLabel, new GBC(0, 1, 1, 1, 0.0, 0.0, 13, 0, 10, 0, 0, 0));
        jPanel2.add((Component)this.fontStyleChoices, new GBC(1, 1, 1, 1, 0.0, 0.0, 17, 0, 10, 5, 0, 10));
        JLabel jLabel2 = new JLabel(SIZE);
        jLabel2.setDisplayedMnemonic(SIZE_MNEMONIC);
        jLabel2.setLabelFor(this.fontSizeChoices);
        jPanel2.add((Component)jLabel2, new GBC(0, 2, 1, 1, 0.0, 0.0, 13, 0, 10, 0, 0, 0));
        jPanel2.add((Component)this.fontSizeChoices, new GBC(1, 2, 1, 1, 0.0, 0.0, 17, 0, 10, 5, 0, 10));
        jPanel.add((Component)jPanel2, "North");
    }

    public String getTitle() {
        return DEFAULTFONT;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.choices.isSelectionEmpty()) {
            return;
        }
        String string = (String)this.choices.getSelectedValue();
        FontFamily fontFamily = FontModel.getFontFamily(string);
        this.fontType.setText(fontFamily.getTypeString());
        int n = 0;
        this.fontStyleChoices.removeAllItems();
        int[] nArray = fontFamily.getStyles();
        int n2 = 0;
        while (n2 < nArray.length) {
            this.fontStyleChoices.addItem(FontFamily.styleToString(nArray[n2]));
            if (null == listSelectionEvent && FontModel.getDefaultFontStyle() == nArray[n2]) {
                n = n2;
            }
            ++n2;
        }
        this.fontStyleChoices.setSelectedIndex(n);
        int n3 = 0;
        this.fontSizeChoices.removeAllItems();
        double[] dArray = fontFamily.getSizes();
        int n4 = 0;
        while (n4 < dArray.length) {
            this.fontSizeChoices.addItem(new Double(dArray[n4]));
            if (FontModel.getDefaultFontSize() >= dArray[n4]) {
                n3 = n4;
            }
            ++n4;
        }
        this.fontSizeChoices.setSelectedIndex(n3);
    }

    public void onOK() {
        if (this.choices.isSelectionEmpty()) {
            return;
        }
        String string = (String)this.choices.getSelectedValue();
        FontFamily fontFamily = FontModel.getFontFamily(string);
        int n = this.fontStyleChoices.getSelectedIndex();
        int n2 = fontFamily.getStyles()[n];
        int n3 = this.fontSizeChoices.getSelectedIndex();
        double d = fontFamily.getSizes()[n3];
        FontModel.setDefaultFont((String)this.choices.getSelectedValue(), n2, d);
        FontModel.store();
    }
}

