/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.setups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.MediaModel;

public final class MediaCapabilityTab
extends JPanel
implements ItemListener {
    private static final String TYPE = PrinterPerf.getResourceString("MediaCapabilityTab_Type");
    private static final String CONTINUOUS = PrinterPerf.getResourceString("MediaCapabilityTab_Continuous");
    private static final String NONCONTINUOUS = PrinterPerf.getResourceString("MediaCapabilityTab_NonContinuous");
    private static final String PRINT_HEAD_WIDTH = PrinterPerf.getResourceString("MediaCapabilityTab_PrintHeadWidth");
    private static final char TYPE_MNEMONIC = PrinterPerf.getResourceString("MediaCapabilityTab_Type.MNEMONIC").charAt(0);
    private static final char PRINT_HEAD_WIDTH_MNEMONIC = PrinterPerf.getResourceString("MediaCapabilityTab_PrintHeadWidth.MNEMONIC").charAt(0);
    private MediaModel tableModel = new MediaModel();
    private static final String[] supportedPrintHeadWidthList = MediaCapabilityTab.createDisplay(MediaModel.getSupportedPrintHeadWidth());
    private JComboBox printHeadWidthChoice = new JComboBox<String>(supportedPrintHeadWidthList);
    private JTable table;
    private static final String[] mediaTypeStrings = new String[]{CONTINUOUS, NONCONTINUOUS};
    private JComboBox typeChoice = new JComboBox<String>(mediaTypeStrings);
    boolean oldContinuous = MediaModel.getContinuousPrinting();
    int oldPrintHeadWidthIndex = MediaModel.getCurrentPrintHeadWidthIndex();

    public MediaCapabilityTab() {
        super(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        this.typeChoice.setSelectedIndex(MediaModel.getContinuousPrinting() ? 0 : 1);
        this.resetRangeComboBox();
        jPanel.add(this.createChoicePanel(TYPE, TYPE_MNEMONIC, this.typeChoice));
        jPanel.add(this.createChoicePanel(PRINT_HEAD_WIDTH, PRINT_HEAD_WIDTH_MNEMONIC, this.printHeadWidthChoice));
        this.typeChoice.addItemListener(this);
        this.printHeadWidthChoice.addItemListener(this);
        this.add((Component)jPanel, "North");
        this.table = new JTable(this.tableModel);
        int n = 0;
        while (n < this.tableModel.getColumnCount()) {
            this.table.getColumnModel().getColumn(n).setPreferredWidth(this.tableModel.getColumnWidths()[n]);
            ++n;
        }
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.add(jScrollPane);
    }

    private JPanel createChoicePanel(String string, char c, JComboBox jComboBox) {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        JLabel jLabel = new JLabel(string, 11);
        jLabel.setLabelFor(jComboBox);
        jLabel.setDisplayedMnemonic(c);
        jPanel.add(jLabel);
        jPanel.add(jComboBox);
        return jPanel;
    }

    public void OnCancel() {
        MediaModel.setContinuousPrinting(this.oldContinuous);
        MediaModel.setCurrentPrintHeadWidthByIndex(this.oldPrintHeadWidthIndex);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        if (this.commitChanges()) {
            this.tableModel.fireTableDataChanged();
        }
    }

    private boolean commitChanges() {
        MediaModel.setCurrentPrintHeadWidthByIndex(this.printHeadWidthChoice.getSelectedIndex());
        MediaModel.setContinuousPrinting(this.typeChoice.getSelectedIndex() == 0);
        return true;
    }

    private void resetRangeComboBox() {
        this.printHeadWidthChoice.setSelectedIndex(MediaModel.getCurrentPrintHeadWidthIndex());
    }

    private static String[] createDisplay(float[] fArray) {
        String[] stringArray = new String[fArray.length];
        int n = 0;
        while (n < fArray.length) {
            int n2 = (int)Math.round((double)fArray[n] * 2.54 * 10.0);
            stringArray[n] = n2 + " mm (" + fArray[n] + "\") " + MediaModel.getPaperAlias(fArray[n]);
            ++n;
        }
        return stringArray;
    }
}

