/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.setups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.FontModel;

public class FontCapabilityTab
extends JPanel
implements ItemListener {
    private static final char BITMAPPEDFONT_MNEMONIC = PrinterPerf.getResourceString("FontCapabilityTab_BitmappedFont.MNEMONIC").charAt(0);
    private static final char SCALABLEFONT_MNEMONIC = PrinterPerf.getResourceString("FontCapabilityTab_ScalableFont.MNEMONIC").charAt(0);
    private final FontModel fontModel = new FontModel();
    private JTable table;
    private JCheckBox bitmappedFont = new JCheckBox(FontModel.bitmappedFont.getDisplayName());
    private JCheckBox scalableFont = new JCheckBox(FontModel.scalableFont.getDisplayName());
    private boolean oldBitmapped = FontModel.bitmappedFont.getEnabled();
    private boolean oldScalable = FontModel.scalableFont.getEnabled();

    public FontCapabilityTab() {
        super(new BorderLayout());
        this.bitmappedFont.setMnemonic(BITMAPPEDFONT_MNEMONIC);
        this.scalableFont.setMnemonic(SCALABLEFONT_MNEMONIC);
        this.bitmappedFont.setSelected(FontModel.bitmappedFont.getEnabled());
        this.scalableFont.setSelected(FontModel.scalableFont.getEnabled());
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(this.bitmappedFont);
        jPanel.add(this.scalableFont);
        this.bitmappedFont.addItemListener(this);
        this.scalableFont.addItemListener(this);
        this.add((Component)jPanel, "North");
        this.table = new JTable(this.fontModel);
        int n = 0;
        while (n < this.fontModel.getColumnCount()) {
            this.table.getColumnModel().getColumn(n).setPreferredWidth(this.fontModel.getColumnWidths()[n]);
            ++n;
        }
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.add(jScrollPane);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        FontModel.bitmappedFont.setEnabled(this.bitmappedFont.isSelected());
        FontModel.scalableFont.setEnabled(this.scalableFont.isSelected());
        this.fontModel.fireTableDataChanged();
    }

    public void OnCancel() {
        FontModel.bitmappedFont.setEnabled(this.oldBitmapped);
        FontModel.scalableFont.setEnabled(this.oldScalable);
    }
}

