/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.setups;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JDialog;

public class EscapeDialog
extends JDialog
implements ContainerListener,
KeyListener {
    public EscapeDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.addKeyAndContainerListenerRecursively(this);
    }

    private void addKeyAndContainerListenerRecursively(Component component) {
        component.removeKeyListener(this);
        component.addKeyListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this);
            container.addContainerListener(this);
            Component[] componentArray = container.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.addKeyAndContainerListenerRecursively(componentArray[n]);
                ++n;
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component component) {
        component.removeKeyListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this);
            Component[] componentArray = container.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.removeKeyAndContainerListenerRecursively(componentArray[n]);
                ++n;
            }
        }
    }

    public void componentAdded(ContainerEvent containerEvent) {
        this.addKeyAndContainerListenerRecursively(containerEvent.getChild());
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        this.removeKeyAndContainerListenerRecursively(containerEvent.getChild());
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27 && this.isVisible()) {
            this.onEscape();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void onEscape() {
        this.setVisible(false);
    }
}

