/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.setups;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import pios.emulator.printer.models.DeviceCapability;

public class CheckboxTreeNode
extends DefaultMutableTreeNode {
    protected boolean isSelected;
    protected boolean isChecked;
    protected boolean isHalfChecked;

    public CheckboxTreeNode() {
        this(null);
    }

    public CheckboxTreeNode(Object object) {
        this(object, false);
    }

    public CheckboxTreeNode(Object object, boolean bl) {
        super(object, true);
        this.isChecked = bl;
        this.isSelected = false;
        this.isHalfChecked = false;
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
        if (this.children != null) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                CheckboxTreeNode checkboxTreeNode = (CheckboxTreeNode)enumeration.nextElement();
                checkboxTreeNode.setSelected(bl);
            }
        }
    }

    public void setHalfCheck(boolean bl) {
        this.isHalfChecked = bl;
    }

    public void setChecked(boolean bl) {
        this.setChecked(bl, true);
    }

    void setChecked(boolean bl, boolean bl2) {
        if (this.isChecked == bl) {
            return;
        }
        this.isChecked = bl;
        if (this.children != null && bl2) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                CheckboxTreeNode checkboxTreeNode = (CheckboxTreeNode)enumeration.nextElement();
                checkboxTreeNode.setChecked(bl);
            }
        }
        this.resetGroup();
        this.resetSiblings();
    }

    void resetGroup() {
        if (null != this.getParent()) {
            CheckboxTreeNode checkboxTreeNode = (CheckboxTreeNode)this.getParent();
            boolean bl = true;
            boolean bl2 = true;
            Enumeration enumeration = checkboxTreeNode.children.elements();
            while (enumeration.hasMoreElements()) {
                CheckboxTreeNode checkboxTreeNode2 = (CheckboxTreeNode)enumeration.nextElement();
                if (!checkboxTreeNode2.isChecked) {
                    bl = false;
                    continue;
                }
                bl2 = false;
            }
            if (!bl2 && !bl) {
                checkboxTreeNode.setHalfCheck(true);
                checkboxTreeNode.setChecked(true, false);
            } else {
                checkboxTreeNode.setHalfCheck(false);
                if (bl2) {
                    checkboxTreeNode.setChecked(false, false);
                }
                if (bl) {
                    checkboxTreeNode.setChecked(true, false);
                }
            }
        }
    }

    private void resetSiblings() {
        CheckboxTreeNode checkboxTreeNode;
        Enumeration<? extends TreeNode> enumeration;
        DeviceCapability deviceCapability = (DeviceCapability)this.getUserObject();
        if (null == deviceCapability) {
            return;
        }
        if (null != deviceCapability.getParent() && this.isChecked) {
            enumeration = this.getParent().children();
            while (enumeration.hasMoreElements()) {
                checkboxTreeNode = (CheckboxTreeNode)enumeration.nextElement();
                if (checkboxTreeNode.getUserObject() != deviceCapability.getParent()) continue;
                checkboxTreeNode.setChecked(this.isChecked);
            }
        }
        if (null == deviceCapability.getParent() && !this.isChecked) {
            enumeration = this.getParent().children();
            while (enumeration.hasMoreElements()) {
                checkboxTreeNode = (CheckboxTreeNode)enumeration.nextElement();
                DeviceCapability deviceCapability2 = (DeviceCapability)checkboxTreeNode.getUserObject();
                if (null == deviceCapability2 || null == deviceCapability2.getParent() || deviceCapability2.getParent() != deviceCapability) continue;
                checkboxTreeNode.setChecked(this.isChecked);
            }
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public boolean isHalfChecked() {
        return this.isHalfChecked;
    }
}

