/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.setups;

import java.awt.GridLayout;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.setups.CheckboxTreeNode;
import pios.emulator.printer.setups.CheckboxTreeNodeKeyListener;
import pios.emulator.printer.setups.CheckboxTreeNodeMouseListener;
import pios.emulator.printer.setups.CheckboxTreeRenderer;

public class CapabilityTreeTab
extends JPanel {
    private Hashtable topGroups = new Hashtable();
    private Vector deviceCapabilityList;
    private CheckboxTreeNode topNode;

    public CapabilityTreeTab(Vector vector) {
        super(new GridLayout(1, 1));
        this.deviceCapabilityList = vector;
        this.topNode = new CheckboxTreeNode();
        this.createTopGroupNodes(this.topNode);
        this.createNodes(this.topNode);
        JTree jTree = new JTree(this.topNode);
        jTree.setRootVisible(false);
        jTree.setCellRenderer(new CheckboxTreeRenderer());
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.putClientProperty("JTree.lineStyle", "Angled");
        this.expandNodes(jTree);
        jTree.addMouseListener(new CheckboxTreeNodeMouseListener(jTree));
        jTree.addKeyListener(new CheckboxTreeNodeKeyListener(jTree));
        JScrollPane jScrollPane = new JScrollPane(jTree);
        this.add(jScrollPane);
    }

    private void createTopGroupNodes(CheckboxTreeNode checkboxTreeNode) {
        CheckboxTreeNode checkboxTreeNode2 = null;
        Enumeration enumeration = this.deviceCapabilityList.elements();
        while (enumeration.hasMoreElements()) {
            DeviceCapability deviceCapability = (DeviceCapability)enumeration.nextElement();
            DeviceCapability deviceCapability2 = deviceCapability.getParent();
            if (null == deviceCapability2 || this.topGroups.containsKey(deviceCapability2)) continue;
            DeviceCapability deviceCapability3 = new DeviceCapability(deviceCapability2.getIdentification() + "Options", deviceCapability2.getDisplayName() + " Options");
            checkboxTreeNode2 = new CheckboxTreeNode(deviceCapability3, deviceCapability3.getEnabled());
            checkboxTreeNode.add(checkboxTreeNode2);
            this.topGroups.put(deviceCapability2, checkboxTreeNode2);
        }
    }

    private void createNodes(CheckboxTreeNode checkboxTreeNode) {
        CheckboxTreeNode checkboxTreeNode2 = null;
        Enumeration enumeration = this.deviceCapabilityList.elements();
        while (enumeration.hasMoreElements()) {
            CheckboxTreeNode checkboxTreeNode3;
            DeviceCapability deviceCapability = (DeviceCapability)enumeration.nextElement();
            checkboxTreeNode2 = new CheckboxTreeNode(deviceCapability, deviceCapability.getEnabled());
            if (this.topGroups.containsKey(deviceCapability)) {
                checkboxTreeNode3 = (CheckboxTreeNode)this.topGroups.get(deviceCapability);
                checkboxTreeNode3.add(checkboxTreeNode2);
                if (!deviceCapability.getEnabled()) {
                    checkboxTreeNode3.setChecked(deviceCapability.getEnabled(), false);
                }
            } else if (null != deviceCapability.getParent()) {
                checkboxTreeNode3 = (CheckboxTreeNode)this.topGroups.get(deviceCapability.getParent());
                checkboxTreeNode3.add(checkboxTreeNode2);
                if (!deviceCapability.getEnabled()) {
                    checkboxTreeNode3.setChecked(deviceCapability.getEnabled(), false);
                }
            } else {
                checkboxTreeNode.insert(checkboxTreeNode2, 0);
            }
            checkboxTreeNode2.resetGroup();
        }
    }

    private void expandNodes(JTree jTree) {
        int n = 0;
        while (n < jTree.getRowCount()) {
            jTree.expandRow(n);
            ++n;
        }
    }

    public void updateCapability() {
        Enumeration<TreeNode> enumeration = this.topNode.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            CheckboxTreeNode checkboxTreeNode = (CheckboxTreeNode)enumeration.nextElement();
            DeviceCapability deviceCapability = (DeviceCapability)checkboxTreeNode.getUserObject();
            if (null == deviceCapability) continue;
            deviceCapability.setEnabled(checkboxTreeNode.isChecked());
        }
    }

    public boolean isChecked(DeviceCapability deviceCapability) {
        Enumeration<TreeNode> enumeration = this.topNode.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            CheckboxTreeNode checkboxTreeNode = (CheckboxTreeNode)enumeration.nextElement();
            DeviceCapability deviceCapability2 = (DeviceCapability)checkboxTreeNode.getUserObject();
            if (null == deviceCapability2 || deviceCapability2 != deviceCapability) continue;
            return checkboxTreeNode.isChecked;
        }
        return false;
    }
}

