/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.setups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import pios.emulator.printer.PrinterEngine;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.BarcodeCapabilityModel;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.models.FontModel;
import pios.emulator.printer.models.GeneralCapabilityModel;
import pios.emulator.printer.models.MediaModel;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.models.ResolutionModel;
import pios.emulator.printer.setups.CapabilityTreeTab;
import pios.emulator.printer.setups.EscapeDialog;
import pios.emulator.printer.setups.FontCapabilityTab;
import pios.emulator.printer.setups.MediaCapabilityTab;
import pios.emulator.ui.Accessability;

public class CapabilityDialog
extends EscapeDialog
implements ActionListener {
    private static final String OK = PrinterPerf.getResourceString("CapabilityDialog_OK");
    private static final String CANCEL = PrinterPerf.getResourceString("CapabilityDialog_Cancel");
    private static final String TIP_GENERAL = PrinterPerf.getResourceString("CapabilityDialog_GeneralTip");
    private static final String TIP_BARCODE = PrinterPerf.getResourceString("CapabilityDialog_BarcodeTip");
    private static final String TIP_FONT = PrinterPerf.getResourceString("CapabilityDialog_FontTip");
    private static final String TIP_MEDIA = PrinterPerf.getResourceString("CapabilityDialog_MediaTip");
    private static final String PRINTERCAPABILITY = PrinterPerf.getResourceString("CapabilityDialog_PrinterCapability");
    private static final String MSG_INVALID_IMAGE_FORMAT = PrinterPerf.getResourceString("CapabilityDialog_MSG_InvalidImageFormat");
    private static final String MSG_INVALID_FONT_TYPE = PrinterPerf.getResourceString("CapabilityDialog_MSG_InvalidFontType");
    private static final String MSG_INVALID_FONT = PrinterPerf.getResourceString("CapabilityDialog_MSG_InvalidFont");
    private static final String MSG_INVALID_MEDIA = PrinterPerf.getResourceString("CapabilityDialog_MSG_InvalidMedia");
    private static final String MSG_PAGEMETRICS_CONTINUOUS = PrinterPerf.getResourceString("CapabilityDialog_MSG_InvalidPageMetrics");
    private JButton ok = new JButton(OK);
    private JButton cancel = new JButton(CANCEL);
    private CapabilityTreeTab generalTab;
    private CapabilityTreeTab barcodeTab;
    private FontCapabilityTab fontTab;
    private MediaCapabilityTab mediaTab;
    private JTabbedPane tabbedPane;

    public CapabilityDialog(JFrame jFrame) {
        super(jFrame, PRINTERCAPABILITY, true);
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.ok.addActionListener(this);
        this.ok.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.ok);
        this.cancel.addActionListener(this);
        jPanel.add(this.ok);
        jPanel.add(this.cancel);
        this.getContentPane().add((Component)jPanel, "South");
        this.tabbedPane = new JTabbedPane();
        this.generalTab = new CapabilityTreeTab(GeneralCapabilityModel.getInstance().getList());
        this.tabbedPane.addTab(GeneralCapabilityModel.getInstance().getTitle(), null, this.generalTab, TIP_GENERAL);
        this.barcodeTab = new CapabilityTreeTab(BarcodeCapabilityModel.getInstance().getList());
        this.tabbedPane.addTab(BarcodeCapabilityModel.getInstance().getTitle(), null, this.barcodeTab, TIP_BARCODE);
        this.fontTab = new FontCapabilityTab();
        this.tabbedPane.addTab(FontModel.getTitle(), null, this.fontTab, TIP_FONT);
        this.mediaTab = new MediaCapabilityTab();
        this.tabbedPane.addTab(MediaModel.getTitle(), null, this.mediaTab, TIP_MEDIA);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.unifyButtonSize();
        this.tabbedPane.setPreferredSize(new Dimension((int)this.tabbedPane.getPreferredSize().getWidth(), (int)this.tabbedPane.getPreferredSize().getWidth() / 2));
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    private void unifyButtonSize() {
        JButton[] jButtonArray = new JButton[]{this.ok, this.cancel};
        Accessability.setButtonsPreferredSize((JButton[])jButtonArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok)) {
            this.onOK();
        } else if (actionEvent.getSource().equals(this.cancel)) {
            this.onCancel();
        }
    }

    private boolean validateChecked() {
        if (this.generalTab.isChecked(DeviceCapability.image) && !this.generalTab.isChecked(DeviceCapability.formatBMP) && !this.generalTab.isChecked(DeviceCapability.formatPCX)) {
            this.onValidationError(MSG_INVALID_IMAGE_FORMAT);
            this.tabbedPane.setSelectedComponent(this.generalTab);
            return false;
        }
        if (this.generalTab.isChecked(DeviceCapability.pageMetrics) && MediaModel.getContinuousPrinting()) {
            this.onValidationError(MSG_PAGEMETRICS_CONTINUOUS);
            this.tabbedPane.setSelectedComponent(this.generalTab);
            return false;
        }
        if (!FontModel.bitmappedFont.getEnabled() && !FontModel.scalableFont.getEnabled()) {
            this.onValidationError(MSG_INVALID_FONT_TYPE);
            this.tabbedPane.setSelectedComponent(this.fontTab);
            return false;
        }
        if (0 == FontModel.getActiveFontFamilyList().size()) {
            this.onValidationError(MSG_INVALID_FONT);
            this.tabbedPane.setSelectedComponent(this.fontTab);
            return false;
        }
        if (0 == MediaModel.getActiveList().size()) {
            this.onValidationError(MSG_INVALID_MEDIA);
            this.tabbedPane.setSelectedComponent(this.mediaTab);
            return false;
        }
        return true;
    }

    private void onOK() {
        if (!this.validateChecked()) {
            return;
        }
        this.generalTab.updateCapability();
        this.barcodeTab.updateCapability();
        GeneralCapabilityModel.getInstance().store();
        ResolutionModel.store();
        BarcodeCapabilityModel.getInstance().store();
        FontModel.store();
        MediaModel.store();
        if (PreferenceModel.getInstance().getBooleanProperty("reset.on.capability.change")) {
            PrinterEngine.reset();
        }
        this.setVisible(false);
        this.dispose();
    }

    private void onCancel() {
        this.fontTab.OnCancel();
        this.mediaTab.OnCancel();
        this.setVisible(false);
        this.dispose();
    }

    protected void onEscape() {
        this.onCancel();
    }

    private void onValidationError(String string) {
        JOptionPane.showMessageDialog(this, string, PRINTERCAPABILITY, 0);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (201 == windowEvent.getID()) {
            this.onCancel();
        }
        super.processWindowEvent(windowEvent);
    }
}

