/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Properties;
import pios.emulator.printer.DimensionEx;
import pios.emulator.printer.PointEx;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.TwoD;
import pios.emulator.printer.Units;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.models.EmulatedImage;
import pios.emulator.printer.models.EmulatedMedia;
import pios.emulator.printer.models.FontModel;
import pios.emulator.printer.models.ImageBufferModel;
import pios.emulator.printer.models.MediaModel;
import pios.emulator.printer.models.PrinterBufferModel;
import pios.emulator.printer.models.PrinterModeModel;
import pios.emulator.printer.models.ResolutionModel;
import pios.emulator.printer.models.StatusModel;
import pios.emulator.printer.output.ImagePrintout;
import pios.emulator.printer.output.LinePrintout;
import pios.emulator.printer.output.PrintCanvas;
import pios.emulator.printer.output.Printout;
import pios.emulator.printer.output.RectPrintout;
import pios.emulator.printer.output.TextPrintout;
import pios.emulator.printer.output.barcodeprintout.BarcodePrintout;
import pios.emulator.printer.output.barcodeprintout.CodabarPrintout;
import pios.emulator.printer.output.barcodeprintout.Code128Printout;
import pios.emulator.printer.output.barcodeprintout.Code39Printout;
import pios.emulator.printer.output.barcodeprintout.Code93Printout;
import pios.emulator.printer.output.barcodeprintout.DataMatrixPrintout;
import pios.emulator.printer.output.barcodeprintout.EAN13Printout;
import pios.emulator.printer.output.barcodeprintout.EAN8Printout;
import pios.emulator.printer.output.barcodeprintout.Industrial2of5Printout;
import pios.emulator.printer.output.barcodeprintout.Interleaved2of5Printout;
import pios.emulator.printer.output.barcodeprintout.Matrix2of5Printout;
import pios.emulator.printer.output.barcodeprintout.MaxiCodePrintout;
import pios.emulator.printer.output.barcodeprintout.MicroPDF417Printout;
import pios.emulator.printer.output.barcodeprintout.PDF417Printout;
import pios.emulator.printer.output.barcodeprintout.Standard2of5Printout;
import pios.emulator.printer.output.barcodeprintout.UCCEAN128Printout;
import pios.emulator.printer.output.barcodeprintout.UPCAPrintout;
import pios.emulator.printer.output.barcodeprintout.UPCEPrintout;
import pios.emulator.printer.rmi.BarcodeParameters;
import pios.emulator.printer.rmi.BarcodeParametersRMI;
import pios.emulator.printer.rmi.DimensionRMI;
import pios.emulator.printer.rmi.FontParameters;
import pios.emulator.printer.rmi.LineAlignment;
import pios.emulator.printer.rmi.PrinterEm;
import pios.emulator.printer.rmi.PrinterRemoteException;

public class PrinterEmServer
extends UnicastRemoteObject
implements PrinterEm,
LineAlignment {
    private static final String PRINTERNOTONLINE = PrinterPerf.getResourceString("PrinterEmServer_PrinterNotOnline");
    private static final String PRINTERNOTREADY = PrinterPerf.getResourceString("PrinterEmServer_PrinterNotReady");
    private static final String PRINTERNOTOPEN = PrinterPerf.getResourceString("PrinterEmServer_PrinterNotOpen");
    private static final String UNEXPECTEDFONT = PrinterPerf.getResourceString("PrinterEmServer_UnexpectedFont");
    private static final String FAILEDTOCREATE = PrinterPerf.getResourceString("PrinterEmServer_FailedToCreate");
    private static final String UNRECOGNIZEDNAME = PrinterPerf.getResourceString("PrinterEmServer_UnrecognizedName");
    private static Hashtable barcodePrintoutClassList = new Hashtable();
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$pios$emulator$printer$output$barcodeprintout$Code39Printout;
    static /* synthetic */ Class class$pios$emulator$printer$output$barcodeprintout$Code93Printout;
    static /* synthetic */ Class class$pios$emulator$printer$output$barcodeprintout$CodabarPrintout;
    static /* synthetic */ Class class$pios$emulator$printer$output$barcodeprintout$Interleaved2of5Printout;
    static /* synthetic */ Class class$pios$emulator$printer$output$barcodeprintout$Industrial2of5Printout;
    static /* synthetic */ Class class$pios$emulator$printer$output$barcodeprintout$Standard2of5Printout;
    static /* synthetic */ Class class$pios$emulator$printer$output$barcodeprintout$Matrix2of5Printout;
    static /* synthetic */ Class class$pios$emulator$printer$output$barcodeprintout$EAN13Printout;
    static /* synthetic */ Class class$pios$emulator$printer$output$barcodeprintout$EAN8Printout;
    static /* synthetic */ Class class$pios$emulator$printer$output$barcodeprintout$UPCAPrintout;
    static /* synthetic */ Class class$pios$emulator$printer$output$barcodeprintout$UPCEPrintout;
    static /* synthetic */ Class class$pios$emulator$printer$output$barcodeprintout$Code128Printout;
    static /* synthetic */ Class class$pios$emulator$printer$output$barcodeprintout$UCCEAN128Printout;
    static /* synthetic */ Class class$pios$emulator$printer$output$barcodeprintout$MaxiCodePrintout;
    static /* synthetic */ Class class$pios$emulator$printer$output$barcodeprintout$MicroPDF417Printout;
    static /* synthetic */ Class class$pios$emulator$printer$output$barcodeprintout$PDF417Printout;
    static /* synthetic */ Class class$pios$emulator$printer$output$barcodeprintout$DataMatrixPrintout;

    private void PrinterRemoteExceptionOnly(Exception exception) throws PrinterRemoteException {
        if (!(class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = PrinterEmServer.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException).isInstance(exception)) {
            throw new PrinterRemoteException(0, exception.getMessage());
        }
        throw (PrinterRemoteException)((Object)exception);
    }

    public void openLinePrinter() throws PrinterRemoteException {
        try {
            DeviceCapability.lineMode.verifyCapability();
            this.checkOnOpen();
            PrinterModeModel.setLineMode();
            StatusModel.open();
            PrintCanvas.getInstance().setLineSpace(0.0);
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public void openGraphicPrinter() throws PrinterRemoteException {
        try {
            DeviceCapability.xyMode.verifyCapability();
            this.checkOnOpen();
            PrinterModeModel.setXYMode();
            StatusModel.open();
            PrintCanvas.getInstance().setLineSpace(0.0);
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public void doPrint(int n) throws PrinterRemoteException {
        try {
            this.checkOnRemoteCall();
            PrinterBufferModel.getInstance().doPrint(n);
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public void close() throws PrinterRemoteException {
        try {
            if (StatusModel.isConnectionClosed()) {
                return;
            }
            this.checkOpened();
            this.doDispose();
            StatusModel.close();
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public Properties getAttributes() {
        return PrinterPerf.getAttributesDefinition();
    }

    public void clearError() throws RemoteException {
        try {
            this.checkOpened();
            DeviceCapability.clearError.verifyCapability();
            StatusModel.clearError();
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public void sendRawBytes(byte[] byArray) throws RemoteException {
        try {
            this.checkOnRemoteCall();
            DeviceCapability.sendRawBytes.verifyCapability();
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public void advance(float f) throws RemoteException {
        try {
            if (f > 0.0f) {
                DeviceCapability.forward.verifyCapability();
            } else if (f < 0.0f) {
                DeviceCapability.backward.verifyCapability();
            } else {
                return;
            }
            this.checkOnRemoteCall();
            PrintCanvas.getInstance().advance(f);
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    private void doDispose() {
        PrinterBufferModel.getInstance().clearActiveBuffer();
    }

    public void dispose() throws RemoteException {
        try {
            this.checkOnRemoteCall();
            this.doDispose();
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public void deleteImage(String string) throws RemoteException {
        try {
            DeviceCapability.deleteImage.verifyCapability();
            this.checkOnRemoteCall();
            ImageBufferModel.getInstance().deleteImage(string);
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public int getStatus() throws RemoteException {
        try {
            this.checkOpened();
            return StatusModel.getStatus();
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
            return -1;
        }
    }

    public void uploadImage(String string, double d, double d2) throws RemoteException {
        try {
            DeviceCapability.preloadImage.verifyCapability();
            this.checkOnRemoteCall();
            EmulatedImage emulatedImage = new EmulatedImage(string, d, d2);
            ImageBufferModel.getInstance().addImage(string, emulatedImage);
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public void setLineSpacing(float f) throws RemoteException {
        try {
            DeviceCapability.lineSpacing.verifyCapability();
            this.checkOnRemoteCall();
            PrintCanvas.getInstance().setLineSpace(f);
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public void printText(int n, FontParameters fontParameters, String string) throws RemoteException {
        try {
            this.checkLineAlignment(n);
            this.checkOnRemoteCall();
            TextPrintout textPrintout = this.createTextprintout(fontParameters, string);
            PrinterBufferModel.getInstance().addPrintout((Printout)textPrintout, n);
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public void printImage(int n, String string) throws RemoteException {
        try {
            DeviceCapability.image.verifyCapability();
            this.checkLineAlignment(n);
            this.checkOnRemoteCall();
            ImagePrintout imagePrintout = new ImagePrintout(ImageBufferModel.getInstance().getImage(string));
            PrinterBufferModel.getInstance().addPrintout((Printout)imagePrintout, n);
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public void printBarcode(int n, BarcodeParametersRMI barcodeParametersRMI) throws RemoteException {
        try {
            this.checkLineAlignment(n);
            this.checkOnRemoteCall();
            BarcodePrintout barcodePrintout = this.createBarcodePrintout(barcodeParametersRMI);
            barcodePrintout.setLineAlignment(n);
            PrinterBufferModel.getInstance().addPrintout(barcodePrintout);
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public void drawText(double d, double d2, int n, FontParameters fontParameters, String string) throws RemoteException {
        try {
            this.checkRotation(n, DeviceCapability.textRotation);
            this.checkOnRemoteCall();
            TextPrintout textPrintout = this.createTextprintout(fontParameters, string);
            this.addPrintout(textPrintout, d, d2, n);
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public void drawImage(double d, double d2, int n, String string) throws RemoteException {
        try {
            DeviceCapability.image.verifyCapability();
            this.checkRotation(n, DeviceCapability.imageRotation);
            this.checkOnRemoteCall();
            ImagePrintout imagePrintout = new ImagePrintout(ImageBufferModel.getInstance().getImage(string));
            this.addPrintout(imagePrintout, d, d2, n);
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public void drawBarcode(double d, double d2, int n, BarcodeParametersRMI barcodeParametersRMI) throws RemoteException {
        try {
            this.checkRotation(n, DeviceCapability.barcodeRotation);
            this.checkOnRemoteCall();
            BarcodePrintout barcodePrintout = this.createBarcodePrintout(barcodeParametersRMI);
            this.addPrintout(barcodePrintout, d, d2, n);
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public void drawLine(double d, double d2, double d3, double d4, double d5) throws RemoteException {
        try {
            DeviceCapability.graphics.verifyCapability();
            d5 = this.checkThickness(d5);
            this.checkOnRemoteCall();
            PointEx pointEx = new PointEx(d, d2);
            PointEx pointEx2 = new PointEx(d3, d4);
            LinePrintout linePrintout = new LinePrintout(pointEx, pointEx2);
            linePrintout.setLineWidth(d5);
            PrinterBufferModel.getInstance().addPrintout(linePrintout);
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public void drawRectangle(double d, double d2, double d3, double d4, double d5) throws RemoteException {
        try {
            DeviceCapability.graphics.verifyCapability();
            d5 = this.checkThickness(d5);
            this.checkOnRemoteCall();
            PointEx pointEx = new PointEx(d, d2);
            DimensionEx dimensionEx = new DimensionEx(d3, d4);
            RectPrintout rectPrintout = new RectPrintout(pointEx, dimensionEx);
            rectPrintout.setLineWidth(d5);
            PrinterBufferModel.getInstance().addPrintout(rectPrintout);
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
        }
    }

    public DimensionRMI getTextImplDimension(FontParameters fontParameters, String string) throws RemoteException {
        try {
            this.checkOnRemoteCall();
            TextPrintout textPrintout = this.createTextprintout(fontParameters, string);
            return textPrintout.getSizePoint().getDimensionRMI();
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
            return null;
        }
    }

    public DimensionRMI getBarcodeImplDimension(BarcodeParametersRMI barcodeParametersRMI) throws RemoteException {
        try {
            this.checkOnRemoteCall();
            BarcodePrintout barcodePrintout = this.createBarcodePrintout(barcodeParametersRMI);
            barcodePrintout.createLayout();
            return barcodePrintout.getSizePoint().getDimensionRMI();
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
            return null;
        }
    }

    public int getCurrentResolution() throws RemoteException {
        this.checkOpened();
        try {
            return ResolutionModel.getCurrentResolutionValue();
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
            return 0;
        }
    }

    public DimensionRMI getCurrentMediaDimension() throws RemoteException {
        try {
            this.checkOpened();
            DeviceCapability.pageMetrics.verifyCapability();
            EmulatedMedia emulatedMedia = MediaModel.getCurrentMedia();
            if (emulatedMedia.isContinuous()) {
                throw new PrinterRemoteException(1, "Unsupported for Continuse Media");
            }
            double d = Units.inchToPoint(emulatedMedia.getWidth().get());
            double d2 = Units.inchToPoint(emulatedMedia.getHeight().get());
            TwoD twoD = new TwoD(d, d2);
            return twoD.getDimensionRMI();
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
            return null;
        }
    }

    public float getMaxPrintWidth() throws RemoteException {
        try {
            this.checkOpened();
            return (float)Units.inchToPoint(MediaModel.getCurrentPrintHeadWidth());
        }
        catch (Exception exception) {
            this.PrinterRemoteExceptionOnly(exception);
            return 0.0f;
        }
    }

    private void checkOnRemoteCall() throws PrinterRemoteException {
        this.checkOpened();
        this.checkOnline();
    }

    private void checkOnline() throws PrinterRemoteException {
        if (!StatusModel.isOnLine()) {
            throw new PrinterRemoteException(3, PRINTERNOTONLINE);
        }
    }

    private void checkOpened() throws PrinterRemoteException {
        if (!StatusModel.isConnectionOpened()) {
            throw new PrinterRemoteException(3, PRINTERNOTOPEN);
        }
    }

    private void checkOnOpen() throws PrinterRemoteException {
        if (!StatusModel.isConnectionClosed()) {
            throw new PrinterRemoteException(3, PRINTERNOTREADY);
        }
        this.checkOnline();
    }

    private void checkRotation(int n, DeviceCapability deviceCapability) throws PrinterRemoteException {
        if (0 != n) {
            deviceCapability.verifyCapability();
        }
    }

    private void checkLineAlignment(int n) throws PrinterRemoteException {
        if (0 != n) {
            DeviceCapability.lineAlignment.verifyCapability();
        }
    }

    private double checkThickness(double d) throws PrinterRemoteException {
        if (d > 0.0) {
            if (!DeviceCapability.lineThickness.getEnabled()) {
                d = 0.0;
            }
        } else if (0.0 != d) {
            throw new PrinterRemoteException(3, "Invalid line thickness:" + d);
        }
        return d;
    }

    private void addPrintout(Printout printout, double d, double d2, int n) {
        PointEx pointEx = new PointEx(d, d2);
        printout.setBasePoint(pointEx);
        printout.setRotation(n);
        PrinterBufferModel.getInstance().addPrintout(printout);
    }

    private TextPrintout createTextprintout(FontParameters fontParameters, String string) throws PrinterRemoteException {
        FontModel.implementFont(fontParameters);
        if (null == fontParameters.getFont()) {
            throw new PrinterRemoteException(3, UNEXPECTEDFONT + ":" + fontParameters.getFamilyName());
        }
        return new TextPrintout(string, fontParameters);
    }

    private BarcodePrintout createBarcodePrintout(BarcodeParametersRMI barcodeParametersRMI) throws PrinterRemoteException {
        BarcodeParameters barcodeParameters = new BarcodeParameters(barcodeParametersRMI);
        if (barcodePrintoutClassList.containsKey(barcodeParameters.getSymbologyName())) {
            BarcodePrintout barcodePrintout = null;
            Class clazz = (Class)barcodePrintoutClassList.get(barcodeParameters.getSymbologyName());
            try {
                if (!barcodeParameters.isDataValid()) {
                    throw new PrinterRemoteException(3, "Invalid barcode data:" + barcodeParameters.getSymbologyName());
                }
                barcodePrintout = (BarcodePrintout)clazz.newInstance();
                barcodeParameters.setScalable(barcodePrintout.isScalable());
                barcodePrintout.create(barcodeParameters);
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                throw new PrinterRemoteException(1, FAILEDTOCREATE + ":" + barcodeParameters.getSymbologyName() + "-" + UNRECOGNIZEDNAME);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                throw new PrinterRemoteException(1, FAILEDTOCREATE + ":" + barcodeParameters.getSymbologyName() + "-" + UNRECOGNIZEDNAME);
            }
            return barcodePrintout;
        }
        throw new PrinterRemoteException(3, FAILEDTOCREATE + ":" + barcodeParameters.getSymbologyName() + "-" + UNRECOGNIZEDNAME);
    }

    private static void registerAllBarcodePrintouts() {
        barcodePrintoutClassList.put(Code39Printout.getName(), class$pios$emulator$printer$output$barcodeprintout$Code39Printout == null ? (class$pios$emulator$printer$output$barcodeprintout$Code39Printout = PrinterEmServer.class$("pios.emulator.printer.output.barcodeprintout.Code39Printout")) : class$pios$emulator$printer$output$barcodeprintout$Code39Printout);
        barcodePrintoutClassList.put(Code93Printout.getName(), class$pios$emulator$printer$output$barcodeprintout$Code93Printout == null ? (class$pios$emulator$printer$output$barcodeprintout$Code93Printout = PrinterEmServer.class$("pios.emulator.printer.output.barcodeprintout.Code93Printout")) : class$pios$emulator$printer$output$barcodeprintout$Code93Printout);
        barcodePrintoutClassList.put(CodabarPrintout.getName(), class$pios$emulator$printer$output$barcodeprintout$CodabarPrintout == null ? (class$pios$emulator$printer$output$barcodeprintout$CodabarPrintout = PrinterEmServer.class$("pios.emulator.printer.output.barcodeprintout.CodabarPrintout")) : class$pios$emulator$printer$output$barcodeprintout$CodabarPrintout);
        barcodePrintoutClassList.put(Interleaved2of5Printout.getName(), class$pios$emulator$printer$output$barcodeprintout$Interleaved2of5Printout == null ? (class$pios$emulator$printer$output$barcodeprintout$Interleaved2of5Printout = PrinterEmServer.class$("pios.emulator.printer.output.barcodeprintout.Interleaved2of5Printout")) : class$pios$emulator$printer$output$barcodeprintout$Interleaved2of5Printout);
        barcodePrintoutClassList.put(Industrial2of5Printout.getName(), class$pios$emulator$printer$output$barcodeprintout$Industrial2of5Printout == null ? (class$pios$emulator$printer$output$barcodeprintout$Industrial2of5Printout = PrinterEmServer.class$("pios.emulator.printer.output.barcodeprintout.Industrial2of5Printout")) : class$pios$emulator$printer$output$barcodeprintout$Industrial2of5Printout);
        barcodePrintoutClassList.put(Standard2of5Printout.getName(), class$pios$emulator$printer$output$barcodeprintout$Standard2of5Printout == null ? (class$pios$emulator$printer$output$barcodeprintout$Standard2of5Printout = PrinterEmServer.class$("pios.emulator.printer.output.barcodeprintout.Standard2of5Printout")) : class$pios$emulator$printer$output$barcodeprintout$Standard2of5Printout);
        barcodePrintoutClassList.put(Matrix2of5Printout.getName(), class$pios$emulator$printer$output$barcodeprintout$Matrix2of5Printout == null ? (class$pios$emulator$printer$output$barcodeprintout$Matrix2of5Printout = PrinterEmServer.class$("pios.emulator.printer.output.barcodeprintout.Matrix2of5Printout")) : class$pios$emulator$printer$output$barcodeprintout$Matrix2of5Printout);
        barcodePrintoutClassList.put(EAN13Printout.getName(), class$pios$emulator$printer$output$barcodeprintout$EAN13Printout == null ? (class$pios$emulator$printer$output$barcodeprintout$EAN13Printout = PrinterEmServer.class$("pios.emulator.printer.output.barcodeprintout.EAN13Printout")) : class$pios$emulator$printer$output$barcodeprintout$EAN13Printout);
        barcodePrintoutClassList.put(EAN8Printout.getName(), class$pios$emulator$printer$output$barcodeprintout$EAN8Printout == null ? (class$pios$emulator$printer$output$barcodeprintout$EAN8Printout = PrinterEmServer.class$("pios.emulator.printer.output.barcodeprintout.EAN8Printout")) : class$pios$emulator$printer$output$barcodeprintout$EAN8Printout);
        barcodePrintoutClassList.put(UPCAPrintout.getName(), class$pios$emulator$printer$output$barcodeprintout$UPCAPrintout == null ? (class$pios$emulator$printer$output$barcodeprintout$UPCAPrintout = PrinterEmServer.class$("pios.emulator.printer.output.barcodeprintout.UPCAPrintout")) : class$pios$emulator$printer$output$barcodeprintout$UPCAPrintout);
        barcodePrintoutClassList.put(UPCEPrintout.getName(), class$pios$emulator$printer$output$barcodeprintout$UPCEPrintout == null ? (class$pios$emulator$printer$output$barcodeprintout$UPCEPrintout = PrinterEmServer.class$("pios.emulator.printer.output.barcodeprintout.UPCEPrintout")) : class$pios$emulator$printer$output$barcodeprintout$UPCEPrintout);
        barcodePrintoutClassList.put(Code128Printout.getName(), class$pios$emulator$printer$output$barcodeprintout$Code128Printout == null ? (class$pios$emulator$printer$output$barcodeprintout$Code128Printout = PrinterEmServer.class$("pios.emulator.printer.output.barcodeprintout.Code128Printout")) : class$pios$emulator$printer$output$barcodeprintout$Code128Printout);
        barcodePrintoutClassList.put(UCCEAN128Printout.getName(), class$pios$emulator$printer$output$barcodeprintout$UCCEAN128Printout == null ? (class$pios$emulator$printer$output$barcodeprintout$UCCEAN128Printout = PrinterEmServer.class$("pios.emulator.printer.output.barcodeprintout.UCCEAN128Printout")) : class$pios$emulator$printer$output$barcodeprintout$UCCEAN128Printout);
        barcodePrintoutClassList.put(MaxiCodePrintout.getName(), class$pios$emulator$printer$output$barcodeprintout$MaxiCodePrintout == null ? (class$pios$emulator$printer$output$barcodeprintout$MaxiCodePrintout = PrinterEmServer.class$("pios.emulator.printer.output.barcodeprintout.MaxiCodePrintout")) : class$pios$emulator$printer$output$barcodeprintout$MaxiCodePrintout);
        barcodePrintoutClassList.put(MicroPDF417Printout.getName(), class$pios$emulator$printer$output$barcodeprintout$MicroPDF417Printout == null ? (class$pios$emulator$printer$output$barcodeprintout$MicroPDF417Printout = PrinterEmServer.class$("pios.emulator.printer.output.barcodeprintout.MicroPDF417Printout")) : class$pios$emulator$printer$output$barcodeprintout$MicroPDF417Printout);
        barcodePrintoutClassList.put(PDF417Printout.getName(), class$pios$emulator$printer$output$barcodeprintout$PDF417Printout == null ? (class$pios$emulator$printer$output$barcodeprintout$PDF417Printout = PrinterEmServer.class$("pios.emulator.printer.output.barcodeprintout.PDF417Printout")) : class$pios$emulator$printer$output$barcodeprintout$PDF417Printout);
        barcodePrintoutClassList.put(DataMatrixPrintout.getName(), class$pios$emulator$printer$output$barcodeprintout$DataMatrixPrintout == null ? (class$pios$emulator$printer$output$barcodeprintout$DataMatrixPrintout = PrinterEmServer.class$("pios.emulator.printer.output.barcodeprintout.DataMatrixPrintout")) : class$pios$emulator$printer$output$barcodeprintout$DataMatrixPrintout);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        PrinterEmServer.registerAllBarcodePrintouts();
    }
}

