/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.rmi;

import java.util.Enumeration;
import java.util.Hashtable;
import pios.emulator.printer.DimensionEx;
import pios.emulator.printer.Units;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.output.barcodeprintout.BarParameters;
import pios.emulator.printer.output.barcodeprintout.Code128Printout;
import pios.emulator.printer.output.barcodeprintout.UCCEAN128Printout;
import pios.emulator.printer.rmi.BarcodeParametersRMI;
import pios.emulator.printer.rmi.PrinterRemoteException;
import pios.emulator.symbology.SymbologyHelper;

public final class BarcodeParameters {
    private final BarcodeParametersRMI parameters;
    private static final byte ESCAPE = 27;
    public static final Byte ESC_FUNC1 = new Byte(102);
    public static final Byte ESC_FUNC2 = new Byte(97);
    public static final Byte ESC_FUNC3 = new Byte(97);
    public static final Hashtable ESC_CHAR_MAP = new Hashtable();
    private boolean escape = false;
    private boolean scaled = true;

    BarcodeParameters(BarcodeParametersRMI barcodeParametersRMI) {
        this.parameters = barcodeParametersRMI;
        if (barcodeParametersRMI.symbologyName.equalsIgnoreCase(Code128Printout.getName())) {
            this.escape = true;
        }
    }

    public String getUserData() {
        return this.encodeUserData(this.parameters.userDataStream);
    }

    public boolean isDataValid() {
        if (-1 == this.parameters.symbologyTypeId || !PreferenceModel.getInstance().getBooleanProperty("validation.barcode.external")) {
            return true;
        }
        return SymbologyHelper.getInstance().isBarcodeDataValid(this.parameters.symbologyTypeId, this.parameters.userDataStream, this.parameters.symbologyOptions);
    }

    public BarParameters getDualwidthBarParameters() {
        return BarParameters.createDualwidth(this.parameters.getHeight(this.scaled), Units.dotToPoint(this.parameters.getNarrowElementWidth(this.scaled)), this.parameters.wideToNarrowRatio, Units.dotToPoint(this.parameters.getInterCharGap(this.scaled)));
    }

    public BarParameters getUniwidthBarParameters() {
        return BarParameters.createUniwidth(this.parameters.getHeight(this.scaled), Units.dotToPoint(this.parameters.getNarrowElementWidth(this.scaled)));
    }

    public BarParameters get2of5BarParameters() {
        return BarParameters.create2of5(this.parameters.getHeight(this.scaled), Units.dotToPoint(this.parameters.getNarrowElementWidth(this.scaled)), this.parameters.wideToNarrowRatio, Units.dotToPoint(this.parameters.getInterBarGap(this.scaled)));
    }

    public DimensionEx getModuleSize() {
        return new DimensionEx(Units.dotToPoint(this.parameters.getModuleX(this.scaled)), Units.dotToPoint(this.parameters.getRowHeight(this.scaled)));
    }

    public double getModuleXPoint() {
        return Units.dotToPoint(this.parameters.getModuleX(this.scaled));
    }

    public double getModuleYPoint() {
        return Units.dotToPoint(this.parameters.getRowHeight(this.scaled));
    }

    public int getRows() {
        return this.parameters.rows;
    }

    public int getColumns() {
        return this.parameters.columns;
    }

    public double getWidth() {
        return Units.mmToPoint(this.parameters.widthMM);
    }

    public double getHeight() {
        return Units.mmToPoint(this.parameters.heightMM);
    }

    public long getSymbologyOptions() {
        return this.parameters.symbologyOptions;
    }

    public long getBarcodeOptions() {
        return this.parameters.barcodeOptions;
    }

    public String getSymbologyName() {
        return this.parameters.symbologyName;
    }

    public void setScalable(boolean bl) throws PrinterRemoteException {
        if (!bl && this.parameters.scale != 1.0) {
            throw new PrinterRemoteException(2, "Scaling Factor:" + this.parameters.scale);
        }
        this.scaled = bl;
    }

    private String encodeUserData(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.parameters.symbologyName.equalsIgnoreCase(UCCEAN128Printout.getName())) {
            stringBuffer.append(Code128Printout.FNC1);
        }
        int n = 0;
        while (n < byArray.length) {
            Character c;
            if (this.escape && n + 1 < byArray.length && 27 == byArray[n] && null != (c = this.getEscapedChar(byArray[n + 1]))) {
                stringBuffer.append(c);
                ++n;
            } else {
                int n2 = byArray[n];
                if (n2 < 0) {
                    n2 += 256;
                }
                stringBuffer.append((char)n2);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private Character getEscapedChar(byte by) {
        Enumeration enumeration = ESC_CHAR_MAP.keys();
        while (enumeration.hasMoreElements()) {
            Byte by2 = (Byte)enumeration.nextElement();
            if (by2 != by) continue;
            return (Character)ESC_CHAR_MAP.get(by2);
        }
        return null;
    }

    static {
        ESC_CHAR_MAP.put(ESC_FUNC1, Code128Printout.FNC1);
        ESC_CHAR_MAP.put(ESC_FUNC2, Code128Printout.FNC2);
        ESC_CHAR_MAP.put(ESC_FUNC3, Code128Printout.FNC3);
    }
}

