/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import pios.emulator.printer.PointEx;
import pios.emulator.printer.Units;
import pios.emulator.printer.models.PreferenceModel;

final class myMouseMotionListener
extends MouseMotionAdapter {
    JPanel panel;
    Point anchor;
    Point motion;
    PointEx distance;

    myMouseMotionListener(JPanel jPanel, Point point, Point point2, PointEx pointEx) {
        this.panel = jPanel;
        this.anchor = point;
        this.motion = point2;
        this.distance = pointEx;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        if (mouseEvent.getModifiers() != 16) {
            return;
        }
        if (this.anchor.x > Integer.MIN_VALUE && this.anchor.y > Integer.MIN_VALUE) {
            Graphics graphics = this.panel.getGraphics();
            graphics.setXORMode(Color.white);
            if (this.motion.x > Integer.MIN_VALUE && this.motion.y > Integer.MIN_VALUE) {
                graphics.drawLine(this.anchor.x, this.anchor.y, this.motion.x, this.motion.y);
                graphics.drawString(this.distance.getDisplayString(), this.motion.x, this.motion.y);
            }
            double d = PreferenceModel.getInstance().getOutputZoom();
            this.distance.setLocation(Units.pixelToPoint(mouseEvent.getX() - this.anchor.x) / d, Units.pixelToPoint(mouseEvent.getY() - this.anchor.y) / d);
            this.motion.x = mouseEvent.getX();
            this.motion.y = mouseEvent.getY();
            graphics.drawLine(this.anchor.x, this.anchor.y, this.motion.x, this.motion.y);
            graphics.drawString(this.distance.getDisplayString(), this.motion.x, this.motion.y);
            graphics.dispose();
        }
    }
}

