/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Vector;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.TwoD;
import pios.emulator.printer.output.barcodeprintout.BarParameters;
import pios.emulator.printer.output.barcodeprintout.BarcodePrintout;
import pios.emulator.printer.output.barcodeprintout.HumanreadableOptions;
import pios.emulator.printer.output.barcodeprintout.Supplement2Printout;
import pios.emulator.printer.output.barcodeprintout.Supplement5Printout;
import pios.emulator.printer.output.barcodeprintout.SupplementPrintout;
import pios.emulator.printer.rmi.BarcodeParameters;
import pios.emulator.printer.rmi.PrinterRemoteException;

public abstract class UPCPrintout
extends BarcodePrintout {
    protected static final String STR_TWODIGITADDON = PrinterPerf.getResourceString("UPCPrintout_TwoDigitAddon");
    protected static final String STR_FIVEDIGITADDON = PrinterPerf.getResourceString("UPCPrintout_FiveDigitAddon");
    protected static final String STR_TEXTSHOW = PrinterPerf.getResourceString("UPCPrintout_ShowHumanreadable");
    protected static final long TWO_DIGIT_ADDON = 1L;
    protected static final long FIVE_DIGIT_ADDON = 2L;
    protected static final long CHECK_DIGIT_TRANSMIT = 4L;
    protected static final int ODD = 0;
    protected static final int EVEN = 1;
    protected static final int RIGHT = 2;
    protected static final String[][] charPattern = new String[][]{{"0001101", "0100111", "1110010"}, {"0011001", "0110011", "1100110"}, {"0010011", "0011011", "1101100"}, {"0111101", "0100001", "1000010"}, {"0100011", "0011101", "1011100"}, {"0110001", "0111001", "1001110"}, {"0101111", "0000101", "1010000"}, {"0111011", "0010001", "1000100"}, {"0110111", "0001001", "1001000"}, {"0001011", "0010111", "1110100"}};
    protected static final String LEFT_GUARD = "101";
    protected static final String CENTER_GUARD = "01010";
    protected static final String RIGHT_GUARD = "101";
    private SupplementPrintout supplementPrintout;
    private String supplementData;
    private double humanreadableHeight = 0.0;
    private BarParameters barParameters;

    public void create(BarcodeParameters barcodeParameters) throws PrinterRemoteException {
        if (2L == barcodeParameters.getBarcodeOptions()) {
            throw new PrinterRemoteException(3, "Unsupported Barcode Option:" + barcodeParameters.getBarcodeOptions());
        }
        HumanreadableOptions humanreadableOptions = new HumanreadableOptions(barcodeParameters.getBarcodeOptions());
        humanreadableOptions.setForUPC();
        this.create(barcodeParameters.getUserData(), humanreadableOptions, barcodeParameters.getSymbologyOptions());
        this.barParameters = barcodeParameters.getUniwidthBarParameters();
        this.setHeight(this.barParameters.getHeight());
        int n = this.getBaseLength();
        if (this.checkSymbologyOption(1L)) {
            this.setSupplementData(this.getUserData().substring(n, n + 2));
        } else if (this.checkSymbologyOption(2L)) {
            this.setSupplementData(this.getUserData().substring(n, n + 5));
        }
    }

    protected void setHumanreadableHeight(double d) {
        this.humanreadableHeight = d;
    }

    protected BarParameters getBarParameters() {
        return this.barParameters;
    }

    protected String getUserBaseData() {
        return super.getUserData().substring(0, this.getBaseLength());
    }

    public TwoD getSizePixel() {
        TwoD twoD = super.getSizePixel();
        if (null != this.supplementPrintout) {
            twoD.setSize(twoD.getWidth() + this.barParameters.getQuietZonePixel() + this.supplementPrintout.getSizePixel().getWidth(), twoD.getHeight());
        }
        int n = 0;
        if (this.getHumanreadableOptions().isShow()) {
            n = (int)Math.ceil(this.humanreadableHeight / 2.0);
        }
        twoD.setSize((int)Math.ceil(twoD.getWidth()), (int)Math.ceil(twoD.getHeight() + (double)n));
        return twoD;
    }

    public void render(Graphics2D graphics2D, AffineTransform affineTransform) {
        super.render(graphics2D, affineTransform);
        if (this.supplementPrintout != null) {
            AffineTransform affineTransform2 = graphics2D.getTransform();
            AffineTransform affineTransform3 = new AffineTransform(affineTransform);
            affineTransform3.concatenate(this.getTransform());
            graphics2D.transform(affineTransform3);
            this.supplementPrintout.render(graphics2D, new AffineTransform());
            graphics2D.setTransform(affineTransform2);
        }
    }

    protected double createBarSpace(Vector vector, String string, double d, BarParameters barParameters) {
        int n = 0;
        while (n < string.length()) {
            int n2 = string.charAt(n) - 48;
            Color color = n2 % 2 == 1 ? Color.black : Color.white;
            vector.addElement(new BarcodePrintout.LayoutShape(d, 0.0, barParameters.getBarWidthPixel(n2), barParameters.getHeightPixel(), color));
            d += barParameters.getBarWidthPixel(n2);
            ++n;
        }
        return d;
    }

    protected abstract int getBaseLength();

    protected void validateUserData(String string) throws PrinterRemoteException {
        int n = this.getBaseLength();
        int n2 = 0;
        n2 = this.checkSymbologyOption(1L) ? n + 2 : (this.checkSymbologyOption(2L) ? n + 5 : n);
        if (string.length() != n2) {
            throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":length-" + string.length());
        }
        int n3 = 0;
        while (n3 < string.length()) {
            if (!Character.isDigit(string.charAt(n3))) {
                throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":not digital char-" + string.charAt(n3));
            }
            ++n3;
        }
    }

    protected String addCheckDigit(String string) {
        int n = string.length();
        int[] nArray = new int[]{3, 1};
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += nArray[n3 % 2] * (string.charAt(n - n3 - 1) - 48);
            ++n3;
        }
        if (0 != (n2 %= 10)) {
            n2 = 10 - n2;
        }
        char c = '0';
        c = (char)(c + n2);
        return string + String.valueOf(c);
    }

    protected void setSupplementData(String string) {
        this.supplementData = string;
    }

    protected void createSupplement(double d, double d2) {
        if (null == this.supplementData) {
            return;
        }
        boolean bl = this.getHumanreadableOptions().isShow();
        if (2 == this.supplementData.length()) {
            this.supplementPrintout = new Supplement2Printout();
            this.supplementPrintout.create(this.supplementData, d, d2, bl);
        } else if (5 == this.supplementData.length()) {
            this.supplementPrintout = new Supplement5Printout();
            this.supplementPrintout.create(this.supplementData, d, d2, bl);
        } else {
            PrinterPerf.getLog().appendError("Invalid UPC Supplement:" + this.supplementData);
        }
        if (this.supplementPrintout != null) {
            double d3 = this.getWidthPixel() + this.barParameters.getQuietZonePixel();
            double d4 = 0.0;
            this.supplementPrintout.setBasePoint(d3, d4);
        }
    }
}

