/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.util.Vector;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.Units;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.output.Printout;
import pios.emulator.printer.output.barcodeprintout.BarParameters;
import pios.emulator.printer.output.barcodeprintout.BarcodePrintout;
import pios.emulator.printer.output.barcodeprintout.OptionCapability;
import pios.emulator.printer.output.barcodeprintout.UPCPrintout;

public final class UPCEPrintout
extends UPCPrintout {
    private static final String DISPLAY_NAME = PrinterPerf.getResourceString("UPCEPrintout_UPCE");
    private static final DeviceCapability capability = new DeviceCapability(UPCEPrintout.getName(), DISPLAY_NAME, "UPC_E", null);
    private static final DeviceCapability scalable = new DeviceCapability("Scalable", BarcodePrintout.SCALABLE, "Scalable", capability);
    private static final OptionCapability[] options = new OptionCapability[]{new OptionCapability(1L, "TwoDigitAddon", UPCPrintout.STR_TWODIGITADDON, capability, "UPC_E_TWO_DIGIT_ADDON"), new OptionCapability(2L, "FiveDigitAddon", UPCPrintout.STR_FIVEDIGITADDON, capability, "UPC_E_FIVE_DIGIT_ADDON")};
    private static final OptionCapability[] barcodeOptions = new OptionCapability[]{new OptionCapability(1L, "TextBelow", UPCPrintout.STR_TEXTSHOW, capability, "UPC_E_SHOW_HUMAN_READABLE")};
    private static final int[][] parityEncoding0 = new int[][]{{1, 1, 1, 0, 0, 0}, {1, 1, 0, 1, 0, 0}, {1, 1, 0, 0, 1, 0}, {1, 1, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 0}, {1, 0, 0, 1, 1, 0}, {1, 0, 0, 0, 1, 1}, {1, 0, 1, 0, 1, 0}, {1, 0, 1, 0, 0, 1}, {1, 0, 0, 1, 0, 1}};
    protected static final String RIGHT_GUARD = "1";
    private TextLayout frontDigit;
    private TextLayout middleDigits;
    private TextLayout backDigit;
    private Point middleTextBase = new Point();
    private static final int BASE_LEN = 7;

    protected boolean isEnabled() {
        return capability.getEnabled();
    }

    public boolean isScalable() {
        return scalable.getEnabled();
    }

    protected OptionCapability[] getOptionCapabilities() {
        return options;
    }

    protected OptionCapability[] getBarcodeOptionCapabilities() {
        return barcodeOptions;
    }

    public static void registerCapability(Vector vector) {
        vector.addElement(capability);
        vector.addElement(scalable);
        int n = 0;
        while (n < barcodeOptions.length) {
            vector.addElement(barcodeOptions[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < options.length) {
            vector.addElement(options[n2]);
            ++n2;
        }
    }

    public String getSymbology() {
        return UPCEPrintout.getName();
    }

    public static String getName() {
        return "UPC_E";
    }

    protected int getBaseLength() {
        return 7;
    }

    public void render(Graphics2D graphics2D, AffineTransform affineTransform) {
        super.render(graphics2D, affineTransform);
        AffineTransform affineTransform2 = graphics2D.getTransform();
        AffineTransform affineTransform3 = new AffineTransform(affineTransform);
        affineTransform3.concatenate(this.getTransform());
        graphics2D.transform(affineTransform3);
        if (this.getHumanreadableOptions().isShow()) {
            this.frontDigit.draw(graphics2D, 0.0f, (float)this.getHeightPixel());
            this.middleDigits.draw(graphics2D, (float)this.middleTextBase.getX(), (float)this.middleTextBase.getY());
            this.backDigit.draw(graphics2D, (float)this.getWidthPixel(), (float)this.getHeightPixel());
        }
        graphics2D.setTransform(affineTransform2);
    }

    public void createLayout() {
        super.createLayout();
        String string = this.getUserBaseData();
        string = this.addCheckDigit(string);
        this.frontDigit = new TextLayout(string.substring(0, 1), this.barcodeFont, new FontRenderContext(null, false, false));
        this.middleDigits = new TextLayout(string.substring(1, 7), this.barcodeFont, new FontRenderContext(null, false, false));
        this.backDigit = new TextLayout(string.substring(7, 8), this.barcodeFont, new FontRenderContext(null, false, false));
        double d = Printout.getTextLayoutHeight(this.middleDigits);
        BarParameters barParameters = this.getBarParameters();
        BarParameters barParameters2 = BarParameters.createUniwidth(barParameters.getHeight() - Units.pixelToPoint(d) / 2.0, barParameters.getNarrowElementWidth());
        double d2 = 0.0;
        double d3 = barParameters2.getHeightPixel() + d;
        this.setHumanreadableHeight(d);
        boolean bl = this.getHumanreadableOptions().isShow();
        double d4 = bl ? Printout.getTextLayoutWidth(this.frontDigit) : 0.0;
        d2 = d4 = this.createBarSpace(this.layoutShapes, "101", d4, barParameters);
        StringBuffer stringBuffer = new StringBuffer();
        UPCEPrintout.encode(string, stringBuffer);
        d4 = this.createBarSpace(this.layoutShapes, stringBuffer.toString(), d4, barParameters2);
        double d5 = d4 - d2;
        this.middleTextBase.setLocation(d2 + d5 / 2.0 - Printout.getTextLayoutWidth(this.middleDigits) / 2.0, d3);
        d4 = this.createBarSpace(this.layoutShapes, "01010", d4, barParameters);
        d4 = this.createBarSpace(this.layoutShapes, RIGHT_GUARD, d4, barParameters);
        this.setWidthPixel(d4 += bl ? Printout.getTextLayoutWidth(this.backDigit) : 0.0);
        this.createSupplement(this.getHeight(), barParameters.getNarrowElementWidth());
    }

    static void encode(String string, StringBuffer stringBuffer) {
        int n = string.charAt(0) - 48;
        int n2 = string.charAt(string.length() - 1) - 48;
        int[] nArray = parityEncoding0[n2];
        int n3 = 1;
        while (n3 < string.length() - 1) {
            int n4 = nArray[n3 - 1];
            if (0 != n) {
                n4 = (n4 + 1) % 2;
            }
            stringBuffer.append(UPCPrintout.charPattern[string.charAt(n3) - 48][n4]);
            ++n3;
        }
    }
}

