/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import java.util.Hashtable;
import java.util.Vector;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.output.barcodeprintout.AI23Validator;
import pios.emulator.printer.output.barcodeprintout.AI8003Validator;
import pios.emulator.printer.output.barcodeprintout.AlphanumericValidator;
import pios.emulator.printer.output.barcodeprintout.BarcodePrintout;
import pios.emulator.printer.output.barcodeprintout.Code128Printout;
import pios.emulator.printer.output.barcodeprintout.DateValidator;
import pios.emulator.printer.output.barcodeprintout.DecimalValidator;
import pios.emulator.printer.output.barcodeprintout.DigitalValidator;
import pios.emulator.printer.output.barcodeprintout.NoneValidator;
import pios.emulator.printer.output.barcodeprintout.OptionCapability;
import pios.emulator.printer.rmi.PrinterRemoteException;

public final class UCCEAN128Printout
extends Code128Printout {
    private static final String DISPLAY_NAME = PrinterPerf.getResourceString("UCCEAN128Printout_UCCEAN128");
    private static final DeviceCapability capability = new DeviceCapability(UCCEAN128Printout.getName(), DISPLAY_NAME, "UCCEAN128", null);
    private static final DeviceCapability scalable = new DeviceCapability("Scalable", BarcodePrintout.SCALABLE, "UCCEAN128_SCALABLE", capability);
    private static final boolean validateAI = false;
    private static final OptionCapability[] options = new OptionCapability[0];
    private static final OptionCapability[] barcodeOptions = new OptionCapability[]{new OptionCapability(1L, "TextBelow", BarcodePrintout.TEXTBELOW, capability, "UCCEAN128_HUMAN_READABLE_BELOW"), new OptionCapability(2L, "TextAbove", BarcodePrintout.TEXTABOVE, capability, "UCCEAN128_HUMAN_READABLE_ABOVE")};
    private static Hashtable validators = new Hashtable();

    protected boolean isEnabled() {
        return capability.getEnabled();
    }

    public boolean isScalable() {
        return scalable.getEnabled();
    }

    protected OptionCapability[] getOptionCapabilities() {
        return options;
    }

    protected OptionCapability[] getBarcodeOptionCapabilities() {
        return barcodeOptions;
    }

    public static void registerCapability(Vector vector) {
        vector.addElement(capability);
        vector.addElement(scalable);
        int n = 0;
        while (n < barcodeOptions.length) {
            vector.addElement(barcodeOptions[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < options.length) {
            vector.addElement(options[n2]);
            ++n2;
        }
    }

    protected void validateUserData(String string) throws PrinterRemoteException {
        super.validateUserData(string);
        if (Code128Printout.FNC1.charValue() != string.charAt(0)) {
            throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":Function1-" + string.charAt(0));
        }
        this.validateByAI(string.substring(1));
    }

    private void validateByAI(String string) throws PrinterRemoteException {
    }

    public String getSymbology() {
        return UCCEAN128Printout.getName();
    }

    public static String getName() {
        return "UCCEAN128";
    }

    static {
        DateValidator dateValidator = new DateValidator();
        DigitalValidator digitalValidator = new DigitalValidator(2);
        DigitalValidator digitalValidator2 = new DigitalValidator(6);
        DecimalValidator decimalValidator = new DecimalValidator(6);
        DigitalValidator digitalValidator3 = new DigitalValidator(13);
        DigitalValidator digitalValidator4 = new DigitalValidator(14);
        AlphanumericValidator alphanumericValidator = new AlphanumericValidator(1, 20);
        AlphanumericValidator alphanumericValidator2 = new AlphanumericValidator(1, 29);
        AlphanumericValidator alphanumericValidator3 = new AlphanumericValidator(1, 30);
        validators.put("00", new DigitalValidator(18));
        validators.put("01", digitalValidator4);
        validators.put("02", digitalValidator4);
        validators.put("10", alphanumericValidator);
        validators.put("11", dateValidator);
        validators.put("13", dateValidator);
        validators.put("15", dateValidator);
        validators.put("17", dateValidator);
        validators.put("20", digitalValidator);
        validators.put("21", alphanumericValidator);
        validators.put("22", alphanumericValidator2);
        validators.put("23", new AI23Validator());
        validators.put("240", alphanumericValidator3);
        validators.put("250", alphanumericValidator3);
        validators.put("30", new NoneValidator());
        validators.put("310", decimalValidator);
        validators.put("311", decimalValidator);
        validators.put("312", decimalValidator);
        validators.put("313", decimalValidator);
        validators.put("314", decimalValidator);
        validators.put("315", decimalValidator);
        validators.put("316", decimalValidator);
        validators.put("320", decimalValidator);
        validators.put("321", decimalValidator);
        validators.put("322", decimalValidator);
        validators.put("323", decimalValidator);
        validators.put("324", decimalValidator);
        validators.put("325", decimalValidator);
        validators.put("326", decimalValidator);
        validators.put("327", decimalValidator);
        validators.put("328", decimalValidator);
        validators.put("329", decimalValidator);
        validators.put("330", decimalValidator);
        validators.put("331", decimalValidator);
        validators.put("332", decimalValidator);
        validators.put("333", decimalValidator);
        validators.put("334", decimalValidator);
        validators.put("335", decimalValidator);
        validators.put("336", decimalValidator);
        validators.put("340", decimalValidator);
        validators.put("341", decimalValidator);
        validators.put("342", decimalValidator);
        validators.put("343", decimalValidator);
        validators.put("344", decimalValidator);
        validators.put("345", decimalValidator);
        validators.put("346", decimalValidator);
        validators.put("347", decimalValidator);
        validators.put("348", decimalValidator);
        validators.put("349", decimalValidator);
        validators.put("350", decimalValidator);
        validators.put("351", decimalValidator);
        validators.put("352", decimalValidator);
        validators.put("353", decimalValidator);
        validators.put("354", decimalValidator);
        validators.put("355", decimalValidator);
        validators.put("356", decimalValidator);
        validators.put("360", decimalValidator);
        validators.put("361", decimalValidator);
        validators.put("362", decimalValidator);
        validators.put("363", decimalValidator);
        validators.put("364", decimalValidator);
        validators.put("365", decimalValidator);
        validators.put("366", decimalValidator);
        validators.put("367", decimalValidator);
        validators.put("368", decimalValidator);
        validators.put("369", decimalValidator);
        validators.put("37", new DigitalValidator(1, 8));
        validators.put("400", alphanumericValidator2);
        validators.put("410", digitalValidator3);
        validators.put("411", digitalValidator3);
        validators.put("412", digitalValidator3);
        validators.put("420", new AlphanumericValidator(1, 9));
        validators.put("421", new AlphanumericValidator(4, 12));
        validators.put("8001", digitalValidator4);
        validators.put("8002", alphanumericValidator);
        validators.put("8003", new AI8003Validator());
        validators.put("8004", alphanumericValidator3);
        validators.put("8005", digitalValidator2);
        validators.put("8100", digitalValidator2);
        validators.put("8101", new DigitalValidator(10));
        validators.put("8102", digitalValidator);
        validators.put("90", alphanumericValidator3);
        validators.put("91", alphanumericValidator3);
        validators.put("92", alphanumericValidator3);
        validators.put("93", alphanumericValidator3);
        validators.put("94", alphanumericValidator3);
        validators.put("95", alphanumericValidator3);
        validators.put("96", alphanumericValidator3);
        validators.put("97", alphanumericValidator3);
        validators.put("98", alphanumericValidator3);
        validators.put("99", alphanumericValidator3);
    }
}

