/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import pios.emulator.printer.output.barcodeprintout.BarParameters;
import pios.emulator.printer.output.barcodeprintout.HumanreadableOptions;
import pios.emulator.printer.output.barcodeprintout.OptionCapability;
import pios.emulator.printer.output.barcodeprintout.UPCPrintout;
import pios.emulator.printer.rmi.PrinterRemoteException;

abstract class SupplementPrintout
extends UPCPrintout {
    private static final String LEFT_GUARD = "1011";
    private static final String CHAR_SEPERATOR = "01";
    private BarParameters barParameters;

    SupplementPrintout() {
    }

    protected boolean isEnabled() {
        return true;
    }

    public boolean isScalable() {
        return true;
    }

    protected OptionCapability[] getOptionCapabilities() {
        return null;
    }

    public void create(String string, double d, double d2, boolean bl) {
        long l = 0L;
        try {
            HumanreadableOptions humanreadableOptions = new HumanreadableOptions(bl ? 2L : 0L);
            super.create(string, humanreadableOptions, l);
        }
        catch (PrinterRemoteException printerRemoteException) {
            printerRemoteException.printStackTrace();
        }
        super.createLayout();
        this.setHeight(d -= this.getFixedHumanreadableDimension().getHeight());
        this.barParameters = BarParameters.createUniwidth(d, d2);
        this.createLayout();
    }

    public void createLayout() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LEFT_GUARD);
        this.encode(this.getUserData(), stringBuffer);
        double d = 0.0;
        d = this.createBarSpace(this.layoutShapes, stringBuffer.toString(), d, this.barParameters);
        this.setWidthPixel(d);
    }

    private void encode(String string, StringBuffer stringBuffer) {
        int[] nArray = this.getParity(string);
        int n = 0;
        while (n < string.length()) {
            int n2 = nArray[n];
            stringBuffer.append(UPCPrintout.charPattern[string.charAt(n) - 48][n2]);
            if (n < string.length() - 1) {
                stringBuffer.append(CHAR_SEPERATOR);
            }
            ++n;
        }
    }

    protected abstract int[] getParity(String var1);
}

