/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import java.util.Vector;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.output.barcodeprintout.AllBar2of5Printout;
import pios.emulator.printer.output.barcodeprintout.BarcodePrintout;
import pios.emulator.printer.output.barcodeprintout.Base2of5Printout;
import pios.emulator.printer.output.barcodeprintout.OptionCapability;

public final class Standard2of5Printout
extends AllBar2of5Printout {
    private static final String DISPLAY_NAME = PrinterPerf.getResourceString("Standard2of5Printout_Standard2of5");
    private static final DeviceCapability capability = new DeviceCapability(Standard2of5Printout.getName(), DISPLAY_NAME, "STANDARD2OF5", null);
    private static final DeviceCapability showCheckDigit = new DeviceCapability("ShowCheckDigit", BarcodePrintout.SHOWCHECKDIGIT, "STANDARD2OF5_HUMAN_READABLE_SHOW_CHECK_DIGIT", capability);
    private static final DeviceCapability scalable = new DeviceCapability("Scalable", BarcodePrintout.SCALABLE, "STANDARD2OF5_SCALABLE", capability);
    private static final OptionCapability[] options = new OptionCapability[]{new OptionCapability(1L, "MOD10", Base2of5Printout.STR_MOD10, capability, "STANDARD2OF5_CHECK_DIGIT_MOD10")};
    private static final OptionCapability[] barcodeOptions = new OptionCapability[]{new OptionCapability(1L, "TextBelow", BarcodePrintout.TEXTBELOW, capability, "STANDARD2OF5_HUMAN_READABLE_BELOW"), new OptionCapability(2L, "TextAbove", BarcodePrintout.TEXTABOVE, capability, "STANDARD2OF5_HUMAN_READABLE_ABOVE")};

    protected boolean isEnabled() {
        return capability.getEnabled();
    }

    public boolean isScalable() {
        return scalable.getEnabled();
    }

    protected OptionCapability[] getOptionCapabilities() {
        return options;
    }

    protected OptionCapability[] getBarcodeOptionCapabilities() {
        return barcodeOptions;
    }

    public static void registerCapability(Vector vector) {
        vector.addElement(capability);
        vector.addElement(showCheckDigit);
        vector.addElement(scalable);
        int n = 0;
        while (n < barcodeOptions.length) {
            vector.addElement(barcodeOptions[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < options.length) {
            vector.addElement(options[n2]);
            ++n2;
        }
    }

    protected String getStartPattern() {
        return "00";
    }

    protected String getStopPattern() {
        return "10";
    }

    protected boolean getShowCheckDigit() {
        return showCheckDigit.getEnabled();
    }

    public String getSymbology() {
        return Standard2of5Printout.getName();
    }

    public static String getName() {
        return "STANDARD2OF5";
    }
}

