/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import pios.emulator.printer.DimensionEx;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.Units;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.output.barcodeprintout.BarParameters;
import pios.emulator.printer.output.barcodeprintout.BarcodePrintout;
import pios.emulator.printer.output.barcodeprintout.HumanreadableOptions;
import pios.emulator.printer.output.barcodeprintout.OptionCapability;
import pios.emulator.printer.rmi.BarcodeParameters;
import pios.emulator.printer.rmi.PrinterRemoteException;

public final class PDF417Printout
extends BarcodePrintout {
    private static final String DISPLAY_NAME = PrinterPerf.getResourceString("PDF417Printout_PDF417");
    private static final String STR_OPTIMUM = PrinterPerf.getResourceString("PDF417Printout_Optimum");
    private static final String STR_TRUNCATE = PrinterPerf.getResourceString("PDF417Printout_Truncate");
    private static final String STR_AUTO = PrinterPerf.getResourceString("PDF417Printout_LevelAuto");
    private static final DeviceCapability capability = new DeviceCapability(PDF417Printout.getName(), DISPLAY_NAME, "PDF417", null);
    private static final DeviceCapability scalable = new DeviceCapability("Scalable", BarcodePrintout.SCALABLE, "PDF417_SCALABLE", capability);
    private static final DeviceCapability optimumSize = new DeviceCapability("autoEncode", STR_OPTIMUM, null, capability);
    public static final long SECURITY_LEVEL_1 = 1L;
    public static final long SECURITY_LEVEL_2 = 2L;
    public static final long SECURITY_LEVEL_3 = 4L;
    public static final long SECURITY_LEVEL_4 = 8L;
    public static final long SECURITY_LEVEL_5 = 16L;
    public static final long SECURITY_LEVEL_6 = 32L;
    public static final long SECURITY_LEVEL_7 = 64L;
    public static final long SECURITY_LEVEL_8 = 128L;
    public static final long SECURITY_LEVEL_AUTOMATIC = 256L;
    public static final long TRUNCATE = 512L;
    private static final OptionCapability[] options = new OptionCapability[]{new OptionCapability(512L, "Trncate", STR_TRUNCATE, capability, "PDF417_TRUNCATE"), new OptionCapability(256L, "LevelAuto", STR_AUTO, capability, "PDF417_SECURITY_LEVEL_AUTOMATIC")};
    private int countByte = 0;
    private int countAlpha = 0;
    private int countDigit = 0;
    private static final double RATE_BYTE = 1.2;
    private static final double RATE_ALPHA = 2.0;
    private static final double RATE_DIGIT = 2.93;
    private int numOfDataCodeword = 0;
    private static final int MAX_NUM_CODEWORD = 928;
    private static final int MIN_ROW = 3;
    private static final int MAX_ROW = 90;
    private static final int MIN_COL = 1;
    private static final int MAX_COL = 30;
    private static final Color ADR_BAR_COLOR = Color.gray;
    private static final Color ROW_COLOR = Color.gray;
    private double moduleSizeX;
    private double moduleSizeY;
    private int column;
    private int row;

    protected boolean isEnabled() {
        return capability.getEnabled();
    }

    public boolean isScalable() {
        return scalable.getEnabled();
    }

    protected OptionCapability[] getOptionCapabilities() {
        return options;
    }

    public static void registerCapability(Vector vector) {
        vector.addElement(capability);
        vector.addElement(scalable);
        int n = 0;
        while (n < options.length) {
            vector.addElement(options[n]);
            ++n;
        }
    }

    public void create(BarcodeParameters barcodeParameters) throws PrinterRemoteException {
        if (0L != barcodeParameters.getBarcodeOptions()) {
            throw new PrinterRemoteException(2, "Unsupported Barcode option:" + barcodeParameters.getBarcodeOptions());
        }
        HumanreadableOptions humanreadableOptions = new HumanreadableOptions(barcodeParameters.getBarcodeOptions());
        this.setCounts(barcodeParameters.getUserData());
        this.create(barcodeParameters.getUserData(), humanreadableOptions, barcodeParameters.getSymbologyOptions());
        this.moduleSizeX = barcodeParameters.getModuleXPoint();
        this.moduleSizeY = barcodeParameters.getModuleYPoint();
        this.setColumnRow(barcodeParameters.getColumns(), barcodeParameters.getRows());
        if (0 == this.row || 0 == this.column) {
            if (!optimumSize.getEnabled()) {
                throw new PrinterRemoteException(2, BarcodePrintout.NOTSUPPORTED + ":" + this.getSymbology() + "." + optimumSize.getDisplayName());
            }
            this.autoSelectColumnRow();
        }
        this.validateColumnRow();
    }

    protected void validateUserData(String string) throws PrinterRemoteException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < '\u0000' || c > '\u00ff') {
                throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":not extented ascii-" + c);
            }
            ++n2;
        }
        this.numOfDataCodeword = this.minimisedEncode();
        if (this.numOfDataCodeword + this.getNumOfECLCodeword() > 928) {
            throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":too much data");
        }
    }

    public String getSymbology() {
        return PDF417Printout.getName();
    }

    public static String getName() {
        return "PDF417";
    }

    private final void autoSelectColumnRow() throws PrinterRemoteException {
        int n = this.numOfDataCodeword;
        n += this.getNumOfECLCodeword();
        if (0 == this.column) {
            this.selectColumn(n);
        }
        if (0 == this.row) {
            this.row = (n - 1) / this.column + 1;
            if (this.row < 3) {
                this.row = 3;
            }
        }
        this.setColumnRow(this.column, this.row);
    }

    private void validateColumnRow() throws PrinterRemoteException {
        if (this.row < 3 || this.row > 90) {
            throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":row is out of range-" + this.row);
        }
        if (this.column < 1 || this.column > 30) {
            throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":column is out of range-" + this.column);
        }
    }

    private void selectColumn(int n) {
        if (0 != this.row) {
            this.column = (n - 1) / this.row + 1;
        } else {
            Vector<Point> vector = new Vector<Point>();
            int n2 = 0;
            while (0 == vector.size()) {
                int n3 = 3;
                while (n3 <= 90) {
                    int n4 = 1;
                    while (n4 <= n3) {
                        if (n3 * n4 == n) {
                            vector.addElement(new Point(n4, n3));
                        }
                        ++n4;
                    }
                    ++n3;
                }
                if (++n2 + n > 928) break;
            }
            double d = Double.MAX_VALUE;
            int n5 = 0;
            while (n5 < vector.size()) {
                Point point = (Point)vector.get(n5);
                double d2 = this.getPerimeter(point.x, point.y);
                if (d2 < d) {
                    d = d2;
                    this.column = point.x;
                    this.row = point.y;
                }
                ++n5;
            }
        }
    }

    private final double getPerimeter(int n, int n2) {
        double d = 0.0;
        double d2 = this.moduleSizeX;
        double d3 = this.moduleSizeY;
        double d4 = 2.0 * d2;
        double d5 = (double)(17 * n + 69) * d2 + 2.0 * d4;
        double d6 = (double)n2 * d3 + 2.0 * d4;
        d = (d5 + d6) * 2.0;
        return d;
    }

    private final int getNumOfECLCodeword() {
        int n = 0;
        if (this.checkSymbologyOption(1L)) {
            n = 1;
        }
        if (this.checkSymbologyOption(2L)) {
            n = 2;
        }
        if (this.checkSymbologyOption(4L)) {
            n = 3;
        }
        if (this.checkSymbologyOption(8L)) {
            n = 4;
        }
        if (this.checkSymbologyOption(16L)) {
            n = 5;
        }
        if (this.checkSymbologyOption(32L)) {
            n = 6;
        }
        if (this.checkSymbologyOption(64L)) {
            n = 7;
        }
        if (this.checkSymbologyOption(128L)) {
            n = 8;
        }
        if (this.checkSymbologyOption(256L)) {
            n = this.recommendedECL();
        }
        int n2 = 2;
        int n3 = 0;
        while (n3 < n) {
            n2 *= 2;
            ++n3;
        }
        return n2;
    }

    private final int recommendedECL() {
        int n = 2;
        if (this.numOfDataCodeword > 863) {
            n = 0;
        }
        if (this.numOfDataCodeword > 320) {
            n = 5;
        }
        if (this.numOfDataCodeword > 160) {
            n = 4;
        }
        if (this.numOfDataCodeword > 40) {
            n = 3;
        }
        return n;
    }

    private final int minimisedEncode() {
        return (int)((double)this.countByte / 1.2 + (double)this.countAlpha / 2.0 + (double)this.countDigit / 2.93);
    }

    private final void setColumnRow(int n, int n2) {
        this.column = n;
        this.row = n2;
        this.setProperty(BarcodePrintout.MODULEARRAY, new DimensionEx(n, n2));
    }

    private final void setCounts(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isDigit(c)) {
                ++this.countDigit;
            } else if (Character.isLetter(c)) {
                ++this.countAlpha;
            } else {
                ++this.countByte;
            }
            ++n;
        }
    }

    public void createLayout() {
        Object object;
        boolean bl = this.checkSymbologyOption(512L);
        double d = Units.pointToPixel(this.moduleSizeY);
        double d2 = Units.pointToPixel(this.moduleSizeX);
        double d3 = 2.0 * d2;
        if (!PreferenceModel.getInstance().getBooleanProperty("quiet.zone.visible")) {
            d3 = 0.0;
        }
        String string = bl ? "1" : "711311121";
        double d4 = 17.0 * d2;
        double d5 = 17.0 * d2;
        double d6 = (double)this.row * d;
        this.setWidthPixel(2.0 * d3 + d5 * (double)this.column + d4 * (double)(bl ? 1 : 2) + 17.0 * d2 + d2 * (double)(bl ? 1 : 18));
        this.setHeight(Units.pixelToPoint(2.0 * d3 + d6));
        int n = 0;
        while (n <= this.row) {
            object = new BarcodePrintout.LayoutShape(new Line2D.Double(0.0, (double)n * d, this.getWidthPixel(), (double)n * d), ROW_COLOR);
            this.layoutShapes.addElement(object);
            ++n;
        }
        object = BarParameters.createUniwidth(Units.pixelToPoint(d6 + 2.0 * d3), Units.pixelToPoint(d2));
        double d7 = d3;
        d7 = this.createBarSpace(this.layoutShapes, "81111113", d7, (BarParameters)object);
        double d8 = d3;
        BarcodePrintout.LayoutShape layoutShape = new BarcodePrintout.LayoutShape(new Rectangle2D.Double(d7, d8, d4, d6), ADR_BAR_COLOR);
        this.layoutShapes.addElement(layoutShape);
        d7 += d4;
        d7 += d5 * (double)this.column;
        d8 = d3;
        if (!bl) {
            BarcodePrintout.LayoutShape layoutShape2 = new BarcodePrintout.LayoutShape(new Rectangle2D.Double(d7, d8, d4, d6), ADR_BAR_COLOR);
            this.layoutShapes.addElement(layoutShape2);
            d7 += d4;
        }
        d7 = this.createBarSpace(this.layoutShapes, string, d7, (BarParameters)object);
        d7 = d3 + 17.0 * d2 + d4;
        int n2 = 1;
        while (n2 < this.column) {
            BarcodePrintout.LayoutShape layoutShape3 = new BarcodePrintout.LayoutShape(new Line2D.Double(d7 += d5, 0.0, d7, this.getHeightPixel()), ROW_COLOR);
            this.layoutShapes.addElement(layoutShape3);
            ++n2;
        }
        this.createQuietZone(0.0, 0.0, this.getWidthPixel(), d3);
        this.createQuietZone(0.0, this.getHeightPixel() - d3, this.getWidthPixel(), d3);
        this.createQuietZone(0.0, 0.0, d3, this.getHeightPixel());
        this.createQuietZone(this.getWidthPixel() - d3, 0.0, d3, this.getHeightPixel());
        super.createLayout();
    }
}

