/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import pios.emulator.printer.DimensionEx;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.Units;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.output.barcodeprintout.BarcodePrintout;
import pios.emulator.printer.output.barcodeprintout.HumanreadableOptions;
import pios.emulator.printer.output.barcodeprintout.OptionCapability;
import pios.emulator.printer.rmi.BarcodeParameters;
import pios.emulator.printer.rmi.PrinterRemoteException;

public final class MicroPDF417Printout
extends BarcodePrintout {
    private static final String DISPLAY_NAME = PrinterPerf.getResourceString("MicroPDF417Printout_MicroPDF417");
    private static final String STR_OPTIMUM = PrinterPerf.getResourceString("MicroPDF417Printout_Optimum");
    private static final DeviceCapability capability = new DeviceCapability(MicroPDF417Printout.getName(), DISPLAY_NAME, "MICROPDF417", null);
    private static final DeviceCapability scalable = new DeviceCapability("Scalable", BarcodePrintout.SCALABLE, "MICROPDF417_SCALABLE", capability);
    private static final long COLUMN_ROW_SIZE_1X11 = 1L;
    private static final long COLUMN_ROW_SIZE_1X14 = 2L;
    private static final long COLUMN_ROW_SIZE_1X17 = 4L;
    private static final long COLUMN_ROW_SIZE_1X20 = 8L;
    private static final long COLUMN_ROW_SIZE_1X24 = 16L;
    private static final long COLUMN_ROW_SIZE_1X28 = 32L;
    private static final long COLUMN_ROW_SIZE_2X8 = 64L;
    private static final long COLUMN_ROW_SIZE_2X11 = 128L;
    private static final long COLUMN_ROW_SIZE_2X14 = 256L;
    private static final long COLUMN_ROW_SIZE_2X17 = 512L;
    private static final long COLUMN_ROW_SIZE_2X20 = 1024L;
    private static final long COLUMN_ROW_SIZE_2X23 = 2048L;
    private static final long COLUMN_ROW_SIZE_2X26 = 4096L;
    private static final long COLUMN_ROW_SIZE_3X6 = 8192L;
    private static final long COLUMN_ROW_SIZE_3X8 = 16384L;
    private static final long COLUMN_ROW_SIZE_3X10 = 32768L;
    private static final long COLUMN_ROW_SIZE_3X12 = 65536L;
    private static final long COLUMN_ROW_SIZE_3X15 = 131072L;
    private static final long COLUMN_ROW_SIZE_3X20 = 262144L;
    private static final long COLUMN_ROW_SIZE_3X26 = 524288L;
    private static final long COLUMN_ROW_SIZE_3X32 = 0x100000L;
    private static final long COLUMN_ROW_SIZE_3X38 = 0x200000L;
    private static final long COLUMN_ROW_SIZE_3X44 = 0x400000L;
    private static final long COLUMN_ROW_SIZE_4X4 = 0x800000L;
    private static final long COLUMN_ROW_SIZE_4X6 = 0x1000000L;
    private static final long COLUMN_ROW_SIZE_4X8 = 0x2000000L;
    private static final long COLUMN_ROW_SIZE_4X10 = 0x4000000L;
    private static final long COLUMN_ROW_SIZE_4X12 = 0x8000000L;
    private static final long COLUMN_ROW_SIZE_4X15 = 0x10000000L;
    private static final long COLUMN_ROW_SIZE_4X20 = 0x20000000L;
    private static final long COLUMN_ROW_SIZE_4X26 = 0x40000000L;
    private static final long COLUMN_ROW_SIZE_4X32 = 0x80000000L;
    private static final long COLUMN_ROW_SIZE_4X38 = 0x100000000L;
    private static final long COLUMN_ROW_SIZE_4X44 = 0x200000000L;
    private static final long OPTIMUM_SIZE = 0L;
    private static final OptionCapability[] options = new OptionCapability[]{new OptionCapability(0L, "Optimum", STR_OPTIMUM, capability, null)};
    private int countByte = 0;
    private int countAlpha = 0;
    private int countDigit = 0;
    private static final double RATE_BYTE = 1.2;
    private static final double RATE_ALPHA = 2.0;
    private static final double RATE_DIGIT = 2.93;
    private static final int COL = 0;
    private static final int ROW = 1;
    private static final int CW = 2;
    private static final int[][] maxDataTable = new int[][]{{1, 11, 3, 3, 6}, {1, 14, 6, 7, 12}, {1, 17, 9, 10, 18}, {1, 20, 11, 13, 22}, {1, 24, 15, 18, 30}, {1, 28, 19, 22, 38}, {2, 8, 7, 16, 14}, {2, 11, 12, 14, 24}, {2, 14, 18, 22, 36}, {2, 17, 23, 27, 46}, {2, 20, 28, 33, 56}, {2, 23, 32, 38, 64}, {2, 26, 36, 43, 72}, {3, 6, 5, 6, 10}, {3, 8, 9, 10, 18}, {3, 10, 13, 15, 26}, {3, 12, 17, 20, 34}, {3, 15, 23, 27, 46}, {3, 20, 33, 39, 66}, {3, 26, 45, 54, 90}, {3, 32, 57, 68, 114}, {3, 38, 69, 82, 138}, {3, 44, 81, 97, 162}, {4, 4, 7, 8, 14}, {4, 6, 11, 13, 22}, {4, 8, 17, 20, 34}, {4, 10, 23, 27, 46}, {4, 12, 29, 34, 58}, {4, 15, 38, 45, 76}, {4, 20, 53, 63, 106}, {4, 26, 71, 85, 142}, {4, 32, 89, 106, 178}, {4, 38, 107, 128, 214}, {4, 44, 125, 150, 250}};
    private static final int MAX_SET = maxDataTable.length;
    private static final Color ADR_BAR_COLOR = Color.gray;
    private static final Color STOP_BAR_COLOR = Color.darkGray;
    private static final Color ROW_COLOR = Color.gray;
    private DimensionEx moduleSize;
    private int column;
    private int row;

    protected boolean isEnabled() {
        return capability.getEnabled();
    }

    public boolean isScalable() {
        return scalable.getEnabled();
    }

    protected OptionCapability[] getOptionCapabilities() {
        return options;
    }

    public static void registerCapability(Vector vector) {
        vector.addElement(capability);
        vector.addElement(scalable);
        int n = 0;
        while (n < options.length) {
            vector.addElement(options[n]);
            ++n;
        }
    }

    private final void setColumnRow(int n, int n2) {
        this.column = n;
        this.row = n2;
        this.setProperty(BarcodePrintout.MODULEARRAY, new DimensionEx(n, n2));
    }

    private final void deriveColumnRow() throws PrinterRemoteException {
        this.setColumnRow(0, 0);
        if (this.checkSymbologyOption(1L)) {
            this.setColumnRow(1, 11);
        }
        if (this.checkSymbologyOption(2L)) {
            this.setColumnRow(1, 14);
        }
        if (this.checkSymbologyOption(4L)) {
            this.setColumnRow(1, 17);
        }
        if (this.checkSymbologyOption(8L)) {
            this.setColumnRow(1, 20);
        }
        if (this.checkSymbologyOption(16L)) {
            this.setColumnRow(1, 24);
        }
        if (this.checkSymbologyOption(32L)) {
            this.setColumnRow(1, 28);
        }
        if (this.checkSymbologyOption(64L)) {
            this.setColumnRow(2, 8);
        }
        if (this.checkSymbologyOption(128L)) {
            this.setColumnRow(2, 11);
        }
        if (this.checkSymbologyOption(256L)) {
            this.setColumnRow(2, 14);
        }
        if (this.checkSymbologyOption(512L)) {
            this.setColumnRow(2, 17);
        }
        if (this.checkSymbologyOption(1024L)) {
            this.setColumnRow(2, 20);
        }
        if (this.checkSymbologyOption(2048L)) {
            this.setColumnRow(2, 23);
        }
        if (this.checkSymbologyOption(4096L)) {
            this.setColumnRow(2, 26);
        }
        if (this.checkSymbologyOption(8192L)) {
            this.setColumnRow(3, 6);
        }
        if (this.checkSymbologyOption(16384L)) {
            this.setColumnRow(3, 8);
        }
        if (this.checkSymbologyOption(32768L)) {
            this.setColumnRow(3, 10);
        }
        if (this.checkSymbologyOption(65536L)) {
            this.setColumnRow(3, 12);
        }
        if (this.checkSymbologyOption(131072L)) {
            this.setColumnRow(3, 15);
        }
        if (this.checkSymbologyOption(262144L)) {
            this.setColumnRow(3, 20);
        }
        if (this.checkSymbologyOption(524288L)) {
            this.setColumnRow(3, 26);
        }
        if (this.checkSymbologyOption(0x100000L)) {
            this.setColumnRow(3, 32);
        }
        if (this.checkSymbologyOption(0x200000L)) {
            this.setColumnRow(3, 38);
        }
        if (this.checkSymbologyOption(0x400000L)) {
            this.setColumnRow(3, 44);
        }
        if (this.checkSymbologyOption(0x800000L)) {
            this.setColumnRow(4, 4);
        }
        if (this.checkSymbologyOption(0x1000000L)) {
            this.setColumnRow(4, 6);
        }
        if (this.checkSymbologyOption(0x2000000L)) {
            this.setColumnRow(4, 8);
        }
        if (this.checkSymbologyOption(0x4000000L)) {
            this.setColumnRow(4, 10);
        }
        if (this.checkSymbologyOption(0x8000000L)) {
            this.setColumnRow(4, 12);
        }
        if (this.checkSymbologyOption(0x10000000L)) {
            this.setColumnRow(4, 15);
        }
        if (this.checkSymbologyOption(0x20000000L)) {
            this.setColumnRow(4, 20);
        }
        if (this.checkSymbologyOption(0x40000000L)) {
            this.setColumnRow(4, 26);
        }
        if (this.checkSymbologyOption(0x80000000L)) {
            this.setColumnRow(4, 32);
        }
        if (this.checkSymbologyOption(0x100000000L)) {
            this.setColumnRow(4, 38);
        }
        if (this.checkSymbologyOption(0x200000000L)) {
            this.setColumnRow(4, 44);
        }
        if (0 == this.row || 0 == this.column) {
            this.autoSelectColumnRow();
        }
    }

    private final void autoSelectColumnRow() throws PrinterRemoteException {
        int n = this.getMinimumCodeword();
        int n2 = 0;
        while (n2 < MAX_SET) {
            if (maxDataTable[n2][2] > n) {
                this.setColumnRow(maxDataTable[n2][0], maxDataTable[n2][1]);
                break;
            }
            ++n2;
        }
        if (0 == this.row || 0 == this.column) {
            throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":failed to select dimension");
        }
    }

    private final int getMinimumCodeword() {
        return this.minimisedEncode();
    }

    private final int minimisedEncode() {
        return (int)((double)this.countByte / 1.2 + (double)this.countAlpha / 2.0 + (double)this.countDigit / 2.93);
    }

    private final void setCounts(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isDigit(c)) {
                ++this.countDigit;
            } else if (Character.isLetter(c)) {
                ++this.countAlpha;
            } else {
                ++this.countByte;
            }
            ++n;
        }
    }

    private final int getMaxCW() {
        int n = maxDataTable[MAX_SET - 1][2];
        if (0 != this.column && 0 != this.row) {
            int n2 = 0;
            while (n2 < MAX_SET) {
                if (maxDataTable[n2][0] == this.column && maxDataTable[n2][1] == this.row) {
                    n = maxDataTable[n2][2];
                }
                ++n2;
            }
        }
        return n;
    }

    public void create(BarcodeParameters barcodeParameters) throws PrinterRemoteException {
        if (0L != barcodeParameters.getBarcodeOptions()) {
            throw new PrinterRemoteException(2, "Unsupported Barcode option:" + barcodeParameters.getBarcodeOptions());
        }
        HumanreadableOptions humanreadableOptions = new HumanreadableOptions(barcodeParameters.getBarcodeOptions());
        this.setCounts(barcodeParameters.getUserData());
        this.create(barcodeParameters.getUserData(), humanreadableOptions, barcodeParameters.getSymbologyOptions());
        this.moduleSize = barcodeParameters.getModuleSize();
        this.setProperty(BarcodePrintout.MODULESIZE, this.moduleSize);
    }

    protected void validateUserData(String string) throws PrinterRemoteException {
        int n;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            n = string.charAt(n3);
            if (n < 0 || n > 255) {
                throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":not extented ascii" + string.charAt(n3));
            }
            ++n3;
        }
        this.deriveColumnRow();
        n = this.getMinimumCodeword();
        if (n > this.getMaxCW()) {
            throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":too much data");
        }
    }

    public String getSymbology() {
        return MicroPDF417Printout.getName();
    }

    public static String getName() {
        return "MICROPDF417";
    }

    public void createLayout() {
        BarcodePrintout.LayoutShape layoutShape;
        BarcodePrintout.LayoutShape layoutShape2;
        double d;
        double d2 = this.moduleSize.getPixelHeight();
        double d3 = d = this.moduleSize.getPixelWidth();
        if (!PreferenceModel.getInstance().getBooleanProperty("quiet.zone.visible")) {
            d3 = 0.0;
        }
        double d4 = d;
        double d5 = 10.0 * d;
        double d6 = 17.0 * d;
        double d7 = (double)this.row * d2;
        int n = (this.column - 1) / 2 + 2;
        this.setWidthPixel(2.0 * d3 + d6 * (double)this.column + d5 * (double)n + d4);
        this.setHeight(Units.pixelToPoint(2.0 * d3 + d7));
        int n2 = 0;
        while (n2 <= this.row) {
            BarcodePrintout.LayoutShape layoutShape3 = new BarcodePrintout.LayoutShape(new Line2D.Double(0.0, (double)n2 * d2, this.getWidthPixel(), (double)n2 * d2), ROW_COLOR);
            this.layoutShapes.addElement(layoutShape3);
            ++n2;
        }
        if (this.column > 1) {
            double d8 = this.getWidthPixel() - d3 - d4 - d5 - d6;
            layoutShape2 = new BarcodePrintout.LayoutShape(new Line2D.Double(d8, 0.0, d8, this.getHeightPixel()), ROW_COLOR);
            this.layoutShapes.addElement(layoutShape2);
        }
        if (this.column > 3) {
            double d9 = d3 + d5 + d6;
            layoutShape2 = new BarcodePrintout.LayoutShape(new Line2D.Double(d9, 0.0, d9, this.getHeightPixel()), ROW_COLOR);
            this.layoutShapes.addElement(layoutShape2);
        }
        double d10 = d3;
        double d11 = d3;
        layoutShape2 = new BarcodePrintout.LayoutShape(new Rectangle2D.Double(d10, d11, d5, d7), ADR_BAR_COLOR);
        this.layoutShapes.addElement(layoutShape2);
        d10 = this.getWidthPixel() - d3 - d4 - d5;
        d11 = d3;
        BarcodePrintout.LayoutShape layoutShape4 = new BarcodePrintout.LayoutShape(new Rectangle2D.Double(d10, d11, d5, d7), ADR_BAR_COLOR);
        this.layoutShapes.addElement(layoutShape4);
        if (n > 2) {
            d10 = d3 + d5 + d6 * (double)(this.column - 2);
            d11 = d3;
            layoutShape = new BarcodePrintout.LayoutShape(new Rectangle2D.Double(d10, d11, d5, d7), ADR_BAR_COLOR);
            this.layoutShapes.addElement(layoutShape);
        }
        d10 = this.getWidthPixel() - d3 - d4;
        d11 = d3;
        layoutShape = new BarcodePrintout.LayoutShape(new Rectangle2D.Double(d10, d11, d4, d7), STOP_BAR_COLOR);
        this.layoutShapes.addElement(layoutShape);
        this.createQuietZone(0.0, 0.0, this.getWidthPixel(), d3);
        this.createQuietZone(0.0, this.getHeightPixel() - d3, this.getWidthPixel(), d3);
        this.createQuietZone(0.0, 0.0, d3, this.getHeightPixel());
        this.createQuietZone(this.getWidthPixel() - d3, 0.0, d3, this.getHeightPixel());
        super.createLayout();
    }
}

