/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.Units;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.output.barcodeprintout.BarcodePrintout;
import pios.emulator.printer.output.barcodeprintout.ByteChar;
import pios.emulator.printer.output.barcodeprintout.HumanreadableOptions;
import pios.emulator.printer.output.barcodeprintout.OptionCapability;
import pios.emulator.printer.rmi.BarcodeParameters;
import pios.emulator.printer.rmi.PrinterRemoteException;

public final class MaxiCodePrintout
extends BarcodePrintout {
    private static final String DISPLAY_NAME = PrinterPerf.getResourceString("MaxiCodePrintout_MaxiCode");
    private static final String STR_MODE2 = PrinterPerf.getResourceString("MaxiCodePrintout_Mode2");
    private static final String STR_MODE3 = PrinterPerf.getResourceString("MaxiCodePrintout_Mode3");
    private static final DeviceCapability capability = new DeviceCapability(MaxiCodePrintout.getName(), DISPLAY_NAME, "MAXICODE", null);
    public static final long MODE_2_NUMERIC_POSTAL_CODE = 1L;
    public static final long MODE_3_ALPHANUMERIC_POSTAL_CODE = 2L;
    public static final long MODE_4_STANDARD_SYMBOL = 4L;
    public static final long MODE_5_FULL_ERRORCORRECTION = 8L;
    public static final long MODE_6_READER_PROGRAMMMING = 16L;
    private static final OptionCapability[] options = new OptionCapability[]{new OptionCapability(1L, "Mode2", STR_MODE2, capability, null), new OptionCapability(2L, "Mode3", STR_MODE3, capability, null)};
    private static Ellipse2D[] finderPattern = new Ellipse2D[6];

    protected boolean isEnabled() {
        return capability.getEnabled();
    }

    public boolean isScalable() {
        return false;
    }

    protected OptionCapability[] getOptionCapabilities() {
        return options;
    }

    public static void registerCapability(Vector vector) {
        vector.addElement(capability);
        int n = 0;
        while (n < options.length) {
            vector.addElement(options[n]);
            ++n;
        }
    }

    private static void initializeEllipses(double d, double d2) {
        double d3 = Units.pointToPixel(d);
        double d4 = Units.pointToPixel(d2);
        double d5 = Units.mmToPixel(0.51);
        MaxiCodePrintout.finderPattern[0] = new Ellipse2D.Double(d3 / 2.0 - d5, d4 / 2.0 - d5, d5 * 2.0, d5 * 2.0);
        d5 = Units.mmToPixel(1.18);
        MaxiCodePrintout.finderPattern[1] = new Ellipse2D.Double(d3 / 2.0 - d5, d4 / 2.0 - d5, d5 * 2.0, d5 * 2.0);
        d5 = Units.mmToPixel(1.86);
        MaxiCodePrintout.finderPattern[2] = new Ellipse2D.Double(d3 / 2.0 - d5, d4 / 2.0 - d5, d5 * 2.0, d5 * 2.0);
        d5 = Units.mmToPixel(2.53);
        MaxiCodePrintout.finderPattern[3] = new Ellipse2D.Double(d3 / 2.0 - d5, d4 / 2.0 - d5, d5 * 2.0, d5 * 2.0);
        d5 = Units.mmToPixel(3.2);
        MaxiCodePrintout.finderPattern[4] = new Ellipse2D.Double(d3 / 2.0 - d5, d4 / 2.0 - d5, d5 * 2.0, d5 * 2.0);
        d5 = Units.mmToPixel(3.87);
        MaxiCodePrintout.finderPattern[5] = new Ellipse2D.Double(d3 / 2.0 - d5, d4 / 2.0 - d5, d5 * 2.0, d5 * 2.0);
    }

    public void create(BarcodeParameters barcodeParameters) throws PrinterRemoteException {
        if (0L != barcodeParameters.getBarcodeOptions()) {
            throw new PrinterRemoteException(2, "Unsupported Barcode option:" + barcodeParameters.getBarcodeOptions());
        }
        HumanreadableOptions humanreadableOptions = new HumanreadableOptions(barcodeParameters.getBarcodeOptions());
        MaxiCodePrintout.initializeEllipses(barcodeParameters.getWidth(), barcodeParameters.getHeight());
        this.create(barcodeParameters.getUserData(), humanreadableOptions, barcodeParameters.getSymbologyOptions());
        this.setHeight(barcodeParameters.getHeight());
        this.setWidth(barcodeParameters.getWidth());
    }

    protected void validateUserData(String string) throws PrinterRemoteException {
        boolean bl = true;
        boolean bl2 = true;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < '\u0000' || c > '\u00ff') {
                throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":not extented ascii-" + c);
            }
            if (!ByteChar.isDigital(c)) {
                bl2 = false;
            }
            if (!Character.isLetterOrDigit(c)) {
                bl = false;
            }
            ++n;
        }
        if (bl && string.length() > 93) {
            throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":too much alphanumeric data");
        }
        if (bl2 && string.length() > 138) {
            throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":too much numeric data");
        }
        if (this.checkSymbologyOption(1L) && !bl2) {
            throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":not numeric postal code");
        }
        if (this.checkSymbologyOption(2L) && !bl) {
            throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":not alphanumeric postal code");
        }
    }

    public String getSymbology() {
        return MaxiCodePrintout.getName();
    }

    public static String getName() {
        return "MAXICODE";
    }

    public void createLayout() {
        super.createLayout();
        BarcodePrintout.LayoutShape layoutShape = new BarcodePrintout.LayoutShape(new Rectangle2D.Double(0.0, 0.0, this.getWidthPixel(), this.getHeightPixel()), Color.black);
        layoutShape.setToFill(false);
        this.layoutShapes.addElement(layoutShape);
        int n = 5;
        while (n >= 0) {
            this.layoutShapes.addElement(new BarcodePrintout.LayoutShape(finderPattern[n], n % 2 == 0 ? Color.white : Color.black));
            --n;
        }
    }
}

