/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import java.util.Vector;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.output.barcodeprintout.BarParameters;
import pios.emulator.printer.output.barcodeprintout.BarcodePrintout;
import pios.emulator.printer.output.barcodeprintout.ByteChar;
import pios.emulator.printer.output.barcodeprintout.HumanreadableOptions;
import pios.emulator.printer.output.barcodeprintout.OptionCapability;
import pios.emulator.printer.rmi.BarcodeParameters;
import pios.emulator.printer.rmi.PrinterRemoteException;

public final class Interleaved2of5Printout
extends BarcodePrintout {
    private static final String DISPLAY_NAME = PrinterPerf.getResourceString("Interleaved2of5Printout_Interleave2of5");
    private static final String STR_MOD10_USS = PrinterPerf.getResourceString("Interleaved2of5Printout_Mod10USS");
    private static final String STR_MOD10_OPCC = PrinterPerf.getResourceString("Interleaved2of5Printout_Mod10OPCC");
    private static final DeviceCapability capability = new DeviceCapability(Interleaved2of5Printout.getName(), DISPLAY_NAME, "INTERLEAVED2OF5", null);
    private static final DeviceCapability showCheckDigit = new DeviceCapability("ShowCheckDigit", BarcodePrintout.SHOWCHECKDIGIT, "INTERLEAVED2OF5_HUMAN_READABLE_SHOW_CHECK_DIGIT", capability);
    private static final DeviceCapability scalable = new DeviceCapability("Scalable", BarcodePrintout.SCALABLE, "INTERLEAVED2OF5_SCALABLE", capability);
    private static final long CHECK_DIGIT_MOD10_USS = 1L;
    private static final long CHECK_DIGIT_MOD10_OPCC = 2L;
    private static final OptionCapability[] options = new OptionCapability[]{new OptionCapability(1L, "MOD10_USS", STR_MOD10_USS, capability, "INTERLEAVED2OF5_CHECK_DIGIT_MOD10_USS"), new OptionCapability(2L, "MOD10_OPCC", STR_MOD10_OPCC, capability, "INTERLEAVED2OF5_CHECK_DIGIT_MOD10_OPCC")};
    private static final OptionCapability[] barcodeOptions = new OptionCapability[]{new OptionCapability(1L, "TextBelow", BarcodePrintout.TEXTBELOW, capability, "INTERLEAVED2OF5_HUMAN_READABLE_BELOW"), new OptionCapability(2L, "TextAbove", BarcodePrintout.TEXTABOVE, capability, "INTERLEAVED2OF5_HUMAN_READABLE_ABOVE")};
    private static final String[] charEncodation = new String[]{"00110", "10001", "01001", "11000", "00101", "10100", "01100", "00011", "10010", "01010"};
    private static final String[] charPattern = new String[100];
    private static final String START = "0000";
    private static final String STOP = "100";
    private BarParameters barParameters;

    protected boolean isEnabled() {
        return capability.getEnabled();
    }

    public boolean isScalable() {
        return scalable.getEnabled();
    }

    protected OptionCapability[] getOptionCapabilities() {
        return options;
    }

    protected OptionCapability[] getBarcodeOptionCapabilities() {
        return barcodeOptions;
    }

    public static void registerCapability(Vector vector) {
        vector.addElement(capability);
        vector.addElement(showCheckDigit);
        vector.addElement(scalable);
        int n = 0;
        while (n < barcodeOptions.length) {
            vector.addElement(barcodeOptions[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < options.length) {
            vector.addElement(options[n2]);
            ++n2;
        }
    }

    public void create(BarcodeParameters barcodeParameters) throws PrinterRemoteException {
        HumanreadableOptions humanreadableOptions = new HumanreadableOptions(barcodeParameters.getBarcodeOptions());
        humanreadableOptions.setShowCheckDigit(showCheckDigit.getEnabled());
        this.create(barcodeParameters.getUserData(), humanreadableOptions, barcodeParameters.getSymbologyOptions());
        this.barParameters = barcodeParameters.get2of5BarParameters();
        this.setHeight(this.barParameters.getHeight());
    }

    public void validateUserData(String string) throws PrinterRemoteException {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!ByteChar.isDigital(c)) {
                throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":not digital char-" + c);
            }
            ++n;
        }
    }

    public String getSymbology() {
        return Interleaved2of5Printout.getName();
    }

    public static String getName() {
        return "INTERLEAVED2OF5";
    }

    public void createLayout() {
        double d = 0.0;
        d = this.createBarQuietZone(d, this.barParameters);
        d = this.createBarSpace(this.layoutShapes, START, d, this.barParameters);
        String string = new String(this.getUserData());
        if (this.checkSymbologyOption(1L) || this.checkSymbologyOption(2L)) {
            if (0 == string.length() % 2) {
                string = this.addLeadZero(string);
            }
            string = this.addCheckDigitMod10(string);
        } else if (1 == string.length() % 2) {
            string = this.addLeadZero(string);
        }
        int n = 0;
        while (n < string.length()) {
            String string2 = string.substring(n, n + 2);
            int n2 = Integer.parseInt(string2);
            d = this.createBarSpace(this.layoutShapes, charPattern[n2], d, this.barParameters);
            d += this.barParameters.getInterCharGapPixel();
            n += 2;
        }
        d = this.createBarSpace(this.layoutShapes, STOP, d, this.barParameters);
        d = this.createBarQuietZone(d, this.barParameters);
        this.setWidthPixel(d);
        if (PrinterPerf.isDebugMode()) {
            int n3 = string.length();
            double d2 = ((4.0 * this.barParameters.getWideToNarrowRatio() + 6.0) * (double)(n3 / 2) + this.barParameters.getWideToNarrowRatio() + 6.0) * this.barParameters.getBarWidthPixel(0) + 2.0 * this.barParameters.getQuietZonePixel();
            d2 += 0.0;
        }
        super.createLayout();
    }

    private String addCheckDigitMod10(String string) {
        int[] nArray = new int[]{3, 1};
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            n += nArray[n3 % 2] * (string.charAt(n2 - n3 - 1) - 48);
            ++n3;
        }
        if (0 != (n %= 10)) {
            n = 10 - n;
        }
        char c = '0';
        c = (char)(c + n);
        this.getHumanreadableOptions().setCheckDigits(String.valueOf(c));
        return string + String.valueOf(c);
    }

    private String addLeadZero(String string) {
        this.getHumanreadableOptions().setUserData("0" + this.getUserData());
        return "0" + string;
    }

    static {
        int n = 0;
        while (n < 10) {
            int n2 = 0;
            while (n2 < 10) {
                int n3 = n * 10 + n2;
                String string = charEncodation[n2];
                StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
                stringBuffer.append(charEncodation[n]);
                int n4 = 0;
                while (n4 < string.length()) {
                    stringBuffer.insert(2 * n4 + 1, string.charAt(n4));
                    ++n4;
                }
                Interleaved2of5Printout.charPattern[n3] = new String(stringBuffer.toString());
                ++n2;
            }
            ++n;
        }
    }
}

