/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import pios.emulator.printer.models.FontModel;
import pios.emulator.printer.rmi.PrinterRemoteException;

public class HumanreadableOptions {
    protected static final long NO_HUMAN_READABLE = 0L;
    private boolean showCheckDigit = false;
    private boolean showStartStop = false;
    private boolean forUPC = false;
    protected static final long HUMAN_READABLE_BELOW = 1L;
    protected static final long HUMAN_READABLE_ABOVE = 2L;
    private Font font = FontModel.getDefaultFont().getFont();
    private long choice = 0L;
    private String userData;
    private String start = "";
    private String stop = "";
    private String checkDigits = "";

    public HumanreadableOptions(long l) throws PrinterRemoteException {
        this.choice = l;
        if (l < 0L || l > 2L) {
            throw new PrinterRemoteException(3, "Invalid Barcode Option:" + l);
        }
    }

    public void setShowCheckDigit(boolean bl) {
        this.showCheckDigit = bl;
    }

    public void setShowCheckStartStop(boolean bl) {
        this.showStartStop = bl;
    }

    public void setForUPC() {
        this.forUPC = true;
    }

    public boolean getForUPC() {
        return this.forUPC;
    }

    public boolean isShow() {
        return 0L != this.choice;
    }

    public boolean isAbove() {
        return 2L == this.choice;
    }

    public boolean isBelow() {
        return 1L == this.choice;
    }

    public boolean checkOption(long l) {
        return this.choice == l;
    }

    public void setUserData(String string) {
        this.userData = string;
    }

    public void setCheckDigits(String string) {
        this.checkDigits = string;
    }

    public void setStartStop(String string, String string2) {
        this.start = string;
        this.stop = string2;
    }

    public TextLayout createLayout() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.showStartStop) {
            stringBuffer.append(this.start);
        }
        stringBuffer.append(this.userData);
        if (this.showCheckDigit) {
            stringBuffer.append(this.checkDigits);
        }
        if (this.showStartStop) {
            stringBuffer.append(this.stop);
        }
        return new TextLayout(stringBuffer.toString(), this.font, new FontRenderContext(null, false, false));
    }
}

