/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.util.Vector;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.Units;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.output.Printout;
import pios.emulator.printer.output.barcodeprintout.BarParameters;
import pios.emulator.printer.output.barcodeprintout.BarcodePrintout;
import pios.emulator.printer.output.barcodeprintout.EAN13Printout;
import pios.emulator.printer.output.barcodeprintout.OptionCapability;
import pios.emulator.printer.output.barcodeprintout.UPCPrintout;

public final class EAN8Printout
extends UPCPrintout {
    private static final String DISPLAY_NAME = PrinterPerf.getResourceString("EAN8Printout_EAN8");
    private static final DeviceCapability capability = new DeviceCapability(EAN8Printout.getName(), DISPLAY_NAME, "EAN8", null);
    private static final DeviceCapability scalable = new DeviceCapability("Scalable", BarcodePrintout.SCALABLE, "EAN8_SCALABLE", capability);
    private static final OptionCapability[] options = new OptionCapability[]{new OptionCapability(1L, "TwoDigitAddon", UPCPrintout.STR_TWODIGITADDON, capability, "EAN8_TWO_DIGIT_ADDON"), new OptionCapability(2L, "FiveDigitAddon", UPCPrintout.STR_FIVEDIGITADDON, capability, "EAN8_FIVE_DIGIT_ADDON")};
    private static final OptionCapability[] barcodeOptions = new OptionCapability[]{new OptionCapability(1L, "TextBelow", UPCPrintout.STR_TEXTSHOW, capability, "EAN8_SHOW_HUMAN_READABLE")};
    private static final int BASE_LEN = 7;
    private TextLayout leftDigits;
    private TextLayout rightDigits;
    private Point leftTextBase = new Point();
    private Point rightTextBase = new Point();

    protected boolean isEnabled() {
        return capability.getEnabled();
    }

    public boolean isScalable() {
        return scalable.getEnabled();
    }

    protected OptionCapability[] getOptionCapabilities() {
        return options;
    }

    protected OptionCapability[] getBarcodeOptionCapabilities() {
        return barcodeOptions;
    }

    public static void registerCapability(Vector vector) {
        vector.addElement(capability);
        vector.addElement(scalable);
        int n = 0;
        while (n < barcodeOptions.length) {
            vector.addElement(barcodeOptions[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < options.length) {
            vector.addElement(options[n2]);
            ++n2;
        }
    }

    protected int getBaseLength() {
        return 7;
    }

    public String getSymbology() {
        return EAN8Printout.getName();
    }

    public static String getName() {
        return "EAN8";
    }

    public void render(Graphics2D graphics2D, AffineTransform affineTransform) {
        super.render(graphics2D, affineTransform);
        AffineTransform affineTransform2 = graphics2D.getTransform();
        AffineTransform affineTransform3 = new AffineTransform(affineTransform);
        affineTransform3.concatenate(this.getTransform());
        graphics2D.transform(affineTransform3);
        if (this.getHumanreadableOptions().isShow()) {
            this.leftDigits.draw(graphics2D, (float)this.leftTextBase.getX(), (float)this.leftTextBase.getY());
            this.rightDigits.draw(graphics2D, (float)this.rightTextBase.getX(), (float)this.rightTextBase.getY());
        }
        graphics2D.setTransform(affineTransform2);
    }

    public void createLayout() {
        super.createLayout();
        String string = this.getUserBaseData();
        string = this.addCheckDigit(string);
        this.leftDigits = new TextLayout(string.substring(0, 4), this.barcodeFont, new FontRenderContext(null, false, false));
        this.rightDigits = new TextLayout(string.substring(4, 8), this.barcodeFont, new FontRenderContext(null, false, false));
        double d = Printout.getTextLayoutHeight(this.leftDigits);
        BarParameters barParameters = this.getBarParameters();
        BarParameters barParameters2 = BarParameters.createUniwidth(barParameters.getHeight() - Units.pixelToPoint(d) / 2.0, barParameters.getNarrowElementWidth());
        double d2 = 0.0;
        double d3 = barParameters2.getHeightPixel() + d;
        this.setHumanreadableHeight(d);
        double d4 = 0.0;
        d2 = d4 = this.createBarSpace(this.layoutShapes, "101", d4, barParameters);
        StringBuffer stringBuffer = new StringBuffer();
        EAN13Printout.encodeLeft(0, string.substring(0, 4), stringBuffer);
        d4 = this.createBarSpace(this.layoutShapes, stringBuffer.toString(), d4, barParameters2);
        double d5 = d4 - d2;
        this.leftTextBase.setLocation(d2 + d5 / 2.0 - Printout.getTextLayoutWidth(this.leftDigits) / 2.0, d3);
        d2 = d4 = this.createBarSpace(this.layoutShapes, "01010", d4, barParameters);
        StringBuffer stringBuffer2 = new StringBuffer();
        EAN13Printout.encodeRight(string.substring(4, 8), stringBuffer2);
        d4 = this.createBarSpace(this.layoutShapes, stringBuffer2.toString(), d4, barParameters2);
        double d6 = d4 - d2;
        this.rightTextBase.setLocation(d2 + d6 / 2.0 - this.rightDigits.getBounds().getWidth() / 2.0, d3);
        d4 = this.createBarSpace(this.layoutShapes, "101", d4, barParameters);
        this.setWidthPixel(d4);
        this.createSupplement(this.getHeight(), barParameters.getNarrowElementWidth());
    }
}

