/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.util.Vector;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.Units;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.output.Printout;
import pios.emulator.printer.output.barcodeprintout.BarParameters;
import pios.emulator.printer.output.barcodeprintout.BarcodePrintout;
import pios.emulator.printer.output.barcodeprintout.OptionCapability;
import pios.emulator.printer.output.barcodeprintout.UPCPrintout;

public final class EAN13Printout
extends UPCPrintout {
    private static final String DISPLAY_NAME = PrinterPerf.getResourceString("EAN13Printout_EAN13");
    private static final DeviceCapability capability = new DeviceCapability(EAN13Printout.getName(), DISPLAY_NAME, "EAN13", null);
    private static final DeviceCapability scalable = new DeviceCapability("Scalable", BarcodePrintout.SCALABLE, "EAN13_SCALABLE", capability);
    private static final OptionCapability[] options = new OptionCapability[]{new OptionCapability(1L, "TwoDigitAddon", UPCPrintout.STR_TWODIGITADDON, capability, "EAN13_TWO_DIGIT_ADDON"), new OptionCapability(2L, "FiveDigitAddon", UPCPrintout.STR_FIVEDIGITADDON, capability, "EAN13_FIVE_DIGIT_ADDON")};
    private static final OptionCapability[] barcodeOptions = new OptionCapability[]{new OptionCapability(1L, "TextBelow", UPCPrintout.STR_TEXTSHOW, capability, "EAN13_SHOW_HUMAN_READABLE")};
    private static final int[][] parityEncoding = new int[][]{{0, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 0, 1}, {0, 0, 1, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 0, 0, 1}, {0, 1, 1, 1, 0, 0}, {0, 1, 0, 1, 0, 1}, {0, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 0}};
    private static final int BASE_LEN = 12;
    private TextLayout frontDigit;
    private TextLayout leftDigits;
    private TextLayout rightDigits;
    private Point leftTextBase = new Point();
    private Point rightTextBase = new Point();

    protected boolean isEnabled() {
        return capability.getEnabled();
    }

    public boolean isScalable() {
        return scalable.getEnabled();
    }

    protected OptionCapability[] getOptionCapabilities() {
        return options;
    }

    protected OptionCapability[] getBarcodeOptionCapabilities() {
        return barcodeOptions;
    }

    public static void registerCapability(Vector vector) {
        vector.addElement(capability);
        vector.addElement(scalable);
        int n = 0;
        while (n < barcodeOptions.length) {
            vector.addElement(barcodeOptions[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < options.length) {
            vector.addElement(options[n2]);
            ++n2;
        }
    }

    protected int getBaseLength() {
        return 12;
    }

    public String getSymbology() {
        return EAN13Printout.getName();
    }

    public static String getName() {
        return "EAN13";
    }

    public void render(Graphics2D graphics2D, AffineTransform affineTransform) {
        super.render(graphics2D, affineTransform);
        AffineTransform affineTransform2 = graphics2D.getTransform();
        AffineTransform affineTransform3 = new AffineTransform(affineTransform);
        affineTransform3.concatenate(this.getTransform());
        graphics2D.transform(affineTransform3);
        if (this.getHumanreadableOptions().isShow()) {
            this.frontDigit.draw(graphics2D, 0.0f, (float)this.getHeightPixel());
            this.leftDigits.draw(graphics2D, (float)this.leftTextBase.getX(), (float)this.leftTextBase.getY());
            this.rightDigits.draw(graphics2D, (float)this.rightTextBase.getX(), (float)this.rightTextBase.getY());
        }
        graphics2D.setTransform(affineTransform2);
    }

    public void createLayout() {
        super.createLayout();
        String string = this.getUserBaseData();
        string = this.addCheckDigit(string);
        this.frontDigit = new TextLayout(string.substring(0, 1), this.barcodeFont, new FontRenderContext(null, false, false));
        this.leftDigits = new TextLayout(string.substring(1, 7), this.barcodeFont, new FontRenderContext(null, false, false));
        this.rightDigits = new TextLayout(string.substring(7, 13), this.barcodeFont, new FontRenderContext(null, false, false));
        double d = Printout.getTextLayoutHeight(this.leftDigits);
        BarParameters barParameters = this.getBarParameters();
        BarParameters barParameters2 = BarParameters.createUniwidth(barParameters.getHeight() - Units.pixelToPoint(d) / 2.0, barParameters.getNarrowElementWidth());
        double d2 = 0.0;
        double d3 = barParameters2.getHeightPixel() + d;
        this.setHumanreadableHeight(d);
        boolean bl = this.getHumanreadableOptions().isShow();
        double d4 = bl ? Printout.getTextLayoutWidth(this.frontDigit) : 0.0;
        d2 = d4 = this.createBarSpace(this.layoutShapes, "101", d4, barParameters);
        StringBuffer stringBuffer = new StringBuffer();
        EAN13Printout.encodeLeft(string.charAt(0) - 48, string.substring(1, 7), stringBuffer);
        d4 = this.createBarSpace(this.layoutShapes, stringBuffer.toString(), d4, barParameters2);
        double d5 = d4 - d2;
        this.leftTextBase.setLocation(d2 + d5 / 2.0 - Printout.getTextLayoutWidth(this.leftDigits) / 2.0, d3);
        d2 = d4 = this.createBarSpace(this.layoutShapes, "01010", d4, barParameters);
        StringBuffer stringBuffer2 = new StringBuffer();
        EAN13Printout.encodeRight(string.substring(7, 13), stringBuffer2);
        d4 = this.createBarSpace(this.layoutShapes, stringBuffer2.toString(), d4, barParameters2);
        double d6 = d4 - d2;
        this.rightTextBase.setLocation(d2 + d6 / 2.0 - Printout.getTextLayoutWidth(this.rightDigits) / 2.0, d3);
        d4 = this.createBarSpace(this.layoutShapes, "101", d4, barParameters);
        this.setWidthPixel(d4);
        this.createSupplement(this.getHeight(), barParameters.getNarrowElementWidth());
    }

    static void encodeLeft(int n, String string, StringBuffer stringBuffer) {
        int[] nArray = parityEncoding[n];
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = nArray[n2];
            stringBuffer.append(UPCPrintout.charPattern[string.charAt(n2) - 48][n3]);
            ++n2;
        }
    }

    static void encodeRight(String string, StringBuffer stringBuffer) {
        int n = 0;
        while (n < string.length()) {
            stringBuffer.append(UPCPrintout.charPattern[string.charAt(n) - 48][2]);
            ++n;
        }
    }
}

