/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import pios.emulator.printer.DimensionEx;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.Units;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.output.barcodeprintout.BarcodePrintout;
import pios.emulator.printer.output.barcodeprintout.DataMatrixEven;
import pios.emulator.printer.output.barcodeprintout.DataMatrixOdd;
import pios.emulator.printer.output.barcodeprintout.HumanreadableOptions;
import pios.emulator.printer.output.barcodeprintout.OptionCapability;
import pios.emulator.printer.rmi.BarcodeParameters;
import pios.emulator.printer.rmi.PrinterRemoteException;

public final class DataMatrixPrintout
extends BarcodePrintout {
    private static final String DISPLAY_NAME = PrinterPerf.getResourceString("DataMatrixPrintout_DataMatrix");
    private static final DeviceCapability capability = new DeviceCapability(DataMatrixPrintout.getName(), DISPLAY_NAME, "DATAMATRIX", null);
    private static final DeviceCapability scalable = new DeviceCapability("Scalable", BarcodePrintout.SCALABLE, "DATAMATRIX_SCALABLE", capability);
    public static final long ERROR_CORRECTION_LEVEL_00 = 1L;
    public static final long ERROR_CORRECTION_LEVEL_50 = 2L;
    public static final long ERROR_CORRECTION_LEVEL_80 = 4L;
    public static final long ERROR_CORRECTION_LEVEL_100 = 8L;
    public static final long ERROR_CORRECTION_LEVEL_140 = 16L;
    public static final long ERROR_CORRECTION_LEVEL_200 = 32L;
    private static final OptionCapability[] options = new OptionCapability[]{new OptionCapability(1L, "ECC000", "ECC 000", capability, null), new OptionCapability(2L, "ECC050", "ECC 050", capability, null), new OptionCapability(4L, "ECC080", "ECC 080", capability, null), new OptionCapability(8L, "ECC100", "ECC 100", capability, null), new OptionCapability(16L, "ECC140", "ECC 140", capability, null), new OptionCapability(32L, "ECC200", "ECC 200", capability, null)};
    protected DimensionEx moduleSize;
    private int oneDimension;

    protected boolean isEnabled() {
        return capability.getEnabled();
    }

    public boolean isScalable() {
        return scalable.getEnabled();
    }

    protected OptionCapability[] getOptionCapabilities() {
        return options;
    }

    public static void registerCapability(Vector vector) {
        vector.addElement(capability);
        vector.addElement(scalable);
        int n = 0;
        while (n < options.length) {
            vector.addElement(options[n]);
            ++n;
        }
    }

    public void create(BarcodeParameters barcodeParameters) throws PrinterRemoteException {
        if (0L != barcodeParameters.getBarcodeOptions()) {
            throw new PrinterRemoteException(2, "Unsupported Option:" + barcodeParameters.getBarcodeOptions());
        }
        HumanreadableOptions humanreadableOptions = new HumanreadableOptions(barcodeParameters.getBarcodeOptions());
        this.create(barcodeParameters.getUserData(), humanreadableOptions, barcodeParameters.getSymbologyOptions());
        this.moduleSize = barcodeParameters.getModuleSize();
        if (this.checkSymbologyOption(32L)) {
            this.oneDimension = DataMatrixEven.selectMatrix(this.getUserData());
        } else {
            long l = -1L;
            if (this.checkSymbologyOption(1L)) {
                l = 1L;
            }
            if (this.checkSymbologyOption(2L)) {
                l = 2L;
            }
            if (this.checkSymbologyOption(4L)) {
                l = 4L;
            }
            if (this.checkSymbologyOption(8L)) {
                l = 8L;
            }
            if (this.checkSymbologyOption(16L)) {
                l = 16L;
            }
            if (-1L == l) {
                l = 1L;
            }
            this.oneDimension = DataMatrixOdd.selectMatrix(this.getUserData(), l, 0);
        }
        this.setProperty(BarcodePrintout.MODULEARRAY, new DimensionEx(this.oneDimension, this.oneDimension));
        this.setProperty(BarcodePrintout.MODULESIZE, this.moduleSize);
    }

    protected void validateUserData(String string) throws PrinterRemoteException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < '\u0000' || c > '\u00ff') {
                throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":not extented ascii-" + c);
            }
            ++n2;
        }
    }

    public String getSymbology() {
        return DataMatrixPrintout.getName();
    }

    public static String getName() {
        return "DATAMATRIX";
    }

    public void createLayout() {
        double d = this.moduleSize.getPixelWidth();
        double d2 = this.moduleSize.getPixelHeight();
        double d3 = d;
        double d4 = d2;
        if (!PreferenceModel.getInstance().getBooleanProperty("quiet.zone.visible")) {
            d3 = 0.0;
            d4 = 0.0;
        }
        this.setHeight(Units.pixelToPoint(d2 * (double)(this.oneDimension + 2)));
        this.setWidthPixel(d * (double)(this.oneDimension + 2));
        double d5 = d3;
        double d6 = d4;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d6, d, d2 * (double)this.oneDimension);
        this.layoutShapes.addElement(new BarcodePrintout.LayoutShape(double_, Color.black));
        d5 = d3;
        d6 = d2 * (double)(this.oneDimension - 1) + d4;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d5, d6, d * (double)this.oneDimension, d2);
        this.layoutShapes.addElement(new BarcodePrintout.LayoutShape(double_2, Color.black));
        d5 = d3;
        d6 = d4;
        int n = 1;
        while (n < this.oneDimension) {
            Rectangle2D.Double double_3 = new Rectangle2D.Double(d5 += d, d6, d, d2);
            this.layoutShapes.addElement(new BarcodePrintout.LayoutShape(double_3, 1 == n % 2 ? Color.white : Color.black));
            ++n;
        }
        d5 = d * (double)(this.oneDimension - 1) + d3;
        d6 = d2 * (double)(this.oneDimension - 1) + d4;
        int n2 = 1;
        while (n2 < this.oneDimension) {
            Rectangle2D.Double double_4 = new Rectangle2D.Double(d5, d6 -= d, d, d2);
            this.layoutShapes.addElement(new BarcodePrintout.LayoutShape(double_4, 1 == n2 % 2 ? Color.white : Color.black));
            ++n2;
        }
        d5 = 0.0;
        d6 = 0.0;
        this.createQuietZone(d5, d6, d3, this.getHeightPixel());
        this.createQuietZone(d5, d6, this.getWidthPixel(), d4);
        d5 = 0.0;
        d6 = this.getHeightPixel() - d4;
        this.createQuietZone(d5, d6, this.getWidthPixel(), d4);
        d5 = this.getWidthPixel() - d3;
        d6 = 0.0;
        this.createQuietZone(d5, d6, d3, this.getHeightPixel());
        super.createLayout();
    }
}

