/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import pios.emulator.printer.output.barcodeprintout.ByteChar;
import pios.emulator.printer.output.barcodeprintout.DataMatrixPrintout;
import pios.emulator.printer.rmi.PrinterRemoteException;

public final class DataMatrixOdd {
    public static final int ENCODE_AUTO = 0;
    public static final int ENCODE_11 = 1;
    public static final int ENCODE_27 = 2;
    public static final int ENCODE_37 = 4;
    public static final int ENCODE_41 = 3;
    public static final int ENCODE_ASCII = 5;
    public static final int ENCODE_BYTE = 6;
    private static final int BITS_DATA_LENGTH = 9;
    private static final int BITS_CRC = 16;
    private static final int BITS_FORMAT_ID = 5;
    private static final int BITS_ECC_000 = 7;
    private static final int BITS_ECC_OTHERS = 19;
    private static final int MAX_ARRAY = 49;

    public static int selectMatrix(String string, long l, int n) throws PrinterRemoteException {
        int n2 = DataMatrixOdd.encodation(string, n);
        n2 += 9;
        n2 += 16;
        n2 += 5;
        n2 = 1L == l ? (n2 += 7) : (n2 += 19);
        int n3 = 7;
        while (n3 * n3 < n2) {
            n3 += 2;
        }
        if ((n3 += 2) > 49) {
            throw new PrinterRemoteException(3, DataMatrixPrintout.INVALIDDATA + ":too much data");
        }
        return n3;
    }

    private static int encodation(String string, int n) {
        double d = 0.0;
        if (0 == n) {
            n = DataMatrixOdd.selectFormatID(string);
        }
        switch (n) {
            case 1: {
                d = 3.5;
                break;
            }
            case 2: {
                d = 4.8;
                break;
            }
            case 4: {
                d = 5.25;
                break;
            }
            case 3: {
                d = 5.5;
                break;
            }
            case 5: {
                d = 7.0;
                break;
            }
            case 6: {
                d = 8.0;
            }
        }
        return (int)((double)string.length() * d + 0.5);
    }

    private static int selectFormatID(String string) {
        char c;
        boolean[] blArray = new boolean[]{false, true, true, true, true, true, true};
        int n = 0;
        while (n < string.length()) {
            c = string.charAt(n);
            if (!ByteChar.isSpace(c) && !ByteChar.isDigital(c)) {
                blArray[1] = false;
            }
            if (!ByteChar.isSpace(c) && !ByteChar.isUpperCase(c)) {
                blArray[2] = false;
            }
            if (!(ByteChar.isSpace(c) || ByteChar.isUpperCase(c) || ByteChar.isDigital(c))) {
                blArray[4] = false;
            }
            if (!(ByteChar.isSpace(c) || ByteChar.isUpperCase(c) || ByteChar.isDigital(c) || c >= ',' && c <= '/')) {
                blArray[3] = false;
            }
            if (!ByteChar.isAscii(c)) {
                blArray[5] = false;
            }
            ++n;
        }
        c = '\u0006';
        char c2 = '\u0000';
        while (c2 < blArray.length) {
            if (blArray[c2]) {
                c = c2;
                break;
            }
            ++c2;
        }
        return c;
    }
}

