/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import pios.emulator.printer.output.barcodeprintout.ByteChar;
import pios.emulator.printer.output.barcodeprintout.DataMatrixPrintout;
import pios.emulator.printer.rmi.PrinterRemoteException;

public final class DataMatrixEven {
    static final int MODE_ASCII = 0;
    static final int MODE_C40 = 1;
    static final int MODE_TEXT = 2;
    static final int MODE_X12 = 3;
    static final int MODE_EDIFACT = 4;
    static final int MODE_BASE256 = 5;
    static int currentMode = 0;
    static int codewordCount = 0;
    private static final int INDEX_NUMCODEWORDS = 0;
    private static final int INDEX_DIMENSION = 1;
    private static final int[][] SYMBOL_SQUARE = new int[][]{{3, 10}, {5, 12}, {8, 14}, {10, 16}, {18, 18}, {22, 20}, {30, 22}, {36, 24}, {44, 26}, {62, 32}, {86, 36}, {114, 40}, {144, 44}, {174, 48}, {204, 52}, {280, 64}, {368, 72}, {456, 80}, {576, 88}, {696, 96}, {816, 104}, {1050, 120}, {1304, 132}, {1558, 144}};

    public static int selectMatrix(String string) throws PrinterRemoteException {
        int n = DataMatrixEven.minimizedEncode(string);
        int n2 = 0;
        int n3 = 0;
        while (n3 < SYMBOL_SQUARE.length) {
            if (SYMBOL_SQUARE[n3][0] >= n) {
                n2 = SYMBOL_SQUARE[n3][1];
                break;
            }
            ++n3;
        }
        if (0 == n2) {
            throw new PrinterRemoteException(3, DataMatrixPrintout.INVALIDDATA + ":failed to select dimension, may be too much data.");
        }
        return n2;
    }

    private static int minimizedEncode(String string) {
        currentMode = 0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        block8: while (n < string.length()) {
            switch (currentMode) {
                case 0: {
                    if (DataMatrixEven.changeMode(string.substring(n))) break;
                    if (DataMatrixEven.twoDigits(string.substring(n))) {
                        ++codewordCount;
                        n += 2;
                        break;
                    }
                    if (string.charAt(n) > '\u007f') {
                        codewordCount += 2;
                        ++n;
                        break;
                    }
                    ++codewordCount;
                    ++n;
                    break;
                }
                case 1: {
                    char c;
                    if (0 == n2 && DataMatrixEven.changeMode(string.substring(n))) continue block8;
                    n2 = DataMatrixEven.isNativeC40(c = string.charAt(n++)) ? ++n2 : (n2 += 2);
                    if (n2 < 3) break;
                    n2 -= 3;
                    codewordCount += 2;
                    break;
                }
                case 2: {
                    char c;
                    if (0 == n3 && DataMatrixEven.changeMode(string.substring(n))) continue block8;
                    n3 = DataMatrixEven.isNativeText(c = string.charAt(n++)) ? ++n3 : (n3 += 2);
                    if (n3 < 3) break;
                    n3 -= 3;
                    codewordCount += 2;
                    break;
                }
                case 3: {
                    if (DataMatrixEven.changeMode(string.substring(n))) break;
                    n += 3;
                    codewordCount += 2;
                    break;
                }
                case 4: {
                    if (DataMatrixEven.changeMode(string.substring(n))) break;
                    n += 4;
                    codewordCount += 3;
                    break;
                }
                case 5: {
                    if (DataMatrixEven.changeMode(string.substring(n))) break;
                    ++n;
                    ++codewordCount;
                }
            }
        }
        return string.length();
    }

    private static boolean changeMode(String string) {
        int n = DataMatrixEven.lookAhead(string);
        if (n != currentMode) {
            ++codewordCount;
            currentMode = n;
            if (currentMode == 5) {
                ++codewordCount;
            }
            return true;
        }
        return false;
    }

    private static boolean twoDigits(String string) {
        return 2 <= DataMatrixEven.digitCounts(string);
    }

    private static int digitCounts(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (!ByteChar.isDigital(string.charAt(n2))) break;
            ++n;
            ++n2;
        }
        return n;
    }

    private static int lookAhead(String string) {
        char c;
        double[] dArray = new double[]{currentMode == 0 ? 0.0 : 1.0, currentMode == 0 ? 1.0 : 2.0, currentMode == 0 ? 1.0 : 2.0, currentMode == 0 ? 1.0 : 2.0, currentMode == 0 ? 1.0 : 2.0, currentMode == 0 ? 1.25 : 2.25};
        dArray[DataMatrixEven.currentMode] = 0.0;
        int n = 0;
        while (n < string.length()) {
            c = string.charAt(n);
            dArray[0] = DataMatrixEven.processAscii(c, dArray[0]);
            dArray[1] = DataMatrixEven.processC40(c, dArray[1]);
            dArray[2] = DataMatrixEven.processText(c, dArray[2]);
            dArray[3] = DataMatrixEven.processX12(c, dArray[3]);
            dArray[4] = DataMatrixEven.processEDF(c, dArray[4]);
            dArray[5] = DataMatrixEven.processBASE256(c, dArray[5]);
            if (n > 4) {
                dArray[0] = dArray[0] + 1.0;
                if (DataMatrixEven.lessThanAll(dArray, 0, true)) {
                    return 0;
                }
                dArray[0] = dArray[0] - 1.0;
                dArray[5] = dArray[5] + 1.0;
                if (dArray[5] <= dArray[0]) {
                    return 5;
                }
                double d = dArray[0];
                dArray[0] = dArray[5] + 1.0;
                if (DataMatrixEven.lessThanAll(dArray, 5, false)) {
                    return 5;
                }
                dArray[0] = d;
                dArray[5] = dArray[5] - 1.0;
                dArray[4] = dArray[4] + 1.0;
                if (DataMatrixEven.lessThanAll(dArray, 4, false)) {
                    return 4;
                }
                dArray[4] = dArray[4] - 1.0;
                dArray[2] = dArray[2] + 1.0;
                if (DataMatrixEven.lessThanAll(dArray, 2, false)) {
                    return 2;
                }
                dArray[2] = dArray[2] - 1.0;
                dArray[3] = dArray[3] + 1.0;
                if (DataMatrixEven.lessThanAll(dArray, 3, false)) {
                    return 3;
                }
                dArray[3] = dArray[3] - 1.0;
                if (dArray[1] + 1.0 < dArray[0] && dArray[1] + 1.0 < dArray[5] && dArray[1] + 1.0 < dArray[4] && dArray[1] + 1.0 < dArray[2]) {
                    if (dArray[1] < dArray[3]) {
                        return 1;
                    }
                    if (dArray[1] == dArray[3] && !DataMatrixEven.x12Ahead(string.substring(n))) {
                        return 1;
                    }
                }
            }
            ++n;
        }
        c = '\u0000';
        while (c < dArray.length) {
            dArray[c] = (int)(dArray[c] + 0.5);
            ++c;
        }
        if (DataMatrixEven.lessThanAll(dArray, 0, true)) {
            return 0;
        }
        if (DataMatrixEven.lessThanAll(dArray, 5, false)) {
            return 5;
        }
        if (DataMatrixEven.lessThanAll(dArray, 4, false)) {
            return 4;
        }
        if (DataMatrixEven.lessThanAll(dArray, 2, false)) {
            return 2;
        }
        if (DataMatrixEven.lessThanAll(dArray, 3, false)) {
            return 3;
        }
        return 1;
    }

    private static boolean lessThanAll(double[] dArray, int n, boolean bl) {
        double d = dArray[n];
        int n2 = 0;
        while (n2 < dArray.length) {
            if (n2 != n) {
                if (d > dArray[n]) {
                    return false;
                }
                if (!bl && d == dArray[n]) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private static double processAscii(char c, double d) {
        if (Character.isDigit(c)) {
            d += 0.5;
        } else if (c > '\u007f') {
            d = (int)(d + 0.5);
            d += 2.0;
        } else {
            d = (int)(d + 0.5);
            d += 1.0;
        }
        return d;
    }

    private static boolean isNativeC40(char c) {
        return ByteChar.isSpace(c) || ByteChar.isDigital(c) || ByteChar.isUpperCase(c);
    }

    private static double processC40(char c, double d) {
        d = DataMatrixEven.isNativeC40(c) ? (d += 0.0) : (c > '\u007f' ? (d += 2.0) : (d += 1.0));
        return d;
    }

    private static boolean isNativeText(char c) {
        return ByteChar.isSpace(c) || ByteChar.isDigital(c) || ByteChar.isLowerCase(c);
    }

    private static double processText(char c, double d) {
        d = DataMatrixEven.isNativeText(c) ? (d += 0.0) : (c > '\u007f' ? (d += 2.0) : (d += 1.0));
        return d;
    }

    private static boolean isNativeX12(char c) {
        return c == '\r' || c == '*' || c == '>' || ByteChar.isSpace(c) || ByteChar.isDigital(c) || ByteChar.isUpperCase(c);
    }

    private static double processX12(char c, double d) {
        d = DataMatrixEven.isNativeX12(c) ? (d += 0.0) : (c > '\u007f' ? (d += 4.0) : (d += 3.0));
        return d;
    }

    private static boolean isNativeEDF(char c) {
        return c >= ' ' && c <= '^';
    }

    private static double processEDF(char c, double d) {
        d = DataMatrixEven.isNativeEDF(c) ? (d += 0.0) : (c > '\u007f' ? (d += 4.0) : (d += 3.0));
        return d;
    }

    private static double processBASE256(char c, double d) {
        return d += 1.0;
    }

    private static boolean x12Ahead(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (DataMatrixEven.isNativeX12(c)) {
                if (c == '\r' || c == '*' || c == '>') {
                    return true;
                }
            } else {
                return false;
            }
            ++n;
        }
        return false;
    }
}

