/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import java.util.Vector;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.output.barcodeprintout.BarParameters;
import pios.emulator.printer.output.barcodeprintout.BarcodePrintout;
import pios.emulator.printer.output.barcodeprintout.ByteChar;
import pios.emulator.printer.output.barcodeprintout.HumanreadableOptions;
import pios.emulator.printer.output.barcodeprintout.OptionCapability;
import pios.emulator.printer.rmi.BarcodeParameters;
import pios.emulator.printer.rmi.PrinterRemoteException;

public final class Code93Printout
extends BarcodePrintout {
    private static final String DISPLAY_NAME = PrinterPerf.getResourceString("Code93Printout_Code93");
    private static final DeviceCapability capability = new DeviceCapability(Code93Printout.getName(), DISPLAY_NAME, "CODE93", null);
    private static final DeviceCapability showCheckDigit = new DeviceCapability("ShowCheckDigit", BarcodePrintout.SHOWCHECKDIGIT, "CODE93_HUMAN_READABLE_SHOW_CHECK_DIGIT", capability);
    private static final DeviceCapability showStartStop = new DeviceCapability("ShowStartStop", BarcodePrintout.SHOWSTARTSTOP, "CODE93_HUMAN_READABLE_SHOW_START_STOP", capability);
    private static final DeviceCapability scalable = new DeviceCapability("Scalable", BarcodePrintout.SCALABLE, "CODE93_SCALABLE", capability);
    public static final long CHECK_DIGIT_TRANSMIT = 1L;
    private static final OptionCapability[] barcodeOptions = new OptionCapability[]{new OptionCapability(1L, "TextBelow", BarcodePrintout.TEXTBELOW, capability, "CODE93_HUMAN_READABLE_BELOW"), new OptionCapability(2L, "TextAbove", BarcodePrintout.TEXTABOVE, capability, "CODE93_HUMAN_READABLE_ABOVE")};
    private static final char S1 = '\u0128';
    private static final char S2 = '\u0129';
    private static final char S3 = '\u0130';
    private static final char S4 = '\u0140';
    private static final char START = '\u0141';
    private static final char STOP = '\u0142';
    private static final char[] valueCharMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '-', '.', ' ', '$', '/', '+', '%', '\u0128', '\u0129', '\u0130', '\u0140', '\u0141', '\u0142'};
    private static final String[] charPattern = new String[]{"131112", "111213", "111312", "111411", "121113", "121212", "121311", "111114", "131211", "141111", "211113", "211212", "211311", "221112", "221211", "231111", "112113", "112212", "112311", "122112", "132111", "111123", "111222", "111321", "121122", "131121", "212112", "212211", "211122", "221221", "221121", "222111", "112122", "112221", "122121", "123111", "121131", "311112", "311211", "321111", "112131", "113121", "211131", "121221", "312111", "311121", "122211", "111141", "1111411"};
    private static String[] fullAsciiSet = new String[]{String.valueOf('\u0129') + "U", String.valueOf('\u0128') + "A", String.valueOf('\u0128') + "B", String.valueOf('\u0128') + "C", String.valueOf('\u0128') + "D", String.valueOf('\u0128') + "E", String.valueOf('\u0128') + "F", String.valueOf('\u0128') + "G", String.valueOf('\u0128') + "H", String.valueOf('\u0128') + "I", String.valueOf('\u0128') + "J", String.valueOf('\u0128') + "K", String.valueOf('\u0128') + "L", String.valueOf('\u0128') + "M", String.valueOf('\u0128') + "N", String.valueOf('\u0128') + "O", String.valueOf('\u0128') + "P", String.valueOf('\u0128') + "Q", String.valueOf('\u0128') + "R", String.valueOf('\u0128') + "S", String.valueOf('\u0128') + "T", String.valueOf('\u0128') + "U", String.valueOf('\u0128') + "V", String.valueOf('\u0128') + "W", String.valueOf('\u0128') + "X", String.valueOf('\u0128') + "Y", String.valueOf('\u0128') + "Z", String.valueOf('\u0129') + "A", String.valueOf('\u0129') + "B", String.valueOf('\u0129') + "C", String.valueOf('\u0129') + "D", String.valueOf('\u0129') + "E", " ", String.valueOf('\u0130') + "A", String.valueOf('\u0130') + "B", String.valueOf('\u0130') + "C", "$", "%", String.valueOf('\u0130') + "F", String.valueOf('\u0130') + "G", String.valueOf('\u0130') + "H", String.valueOf('\u0130') + "I", String.valueOf('\u0130') + "J", "+", String.valueOf('\u0130') + "L", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", String.valueOf('\u0130') + "Z", String.valueOf('\u0129') + "F", String.valueOf('\u0129') + "G", String.valueOf('\u0129') + "H", String.valueOf('\u0129') + "I", String.valueOf('\u0129') + "J", String.valueOf('\u0129') + "V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", String.valueOf('\u0129') + "K", String.valueOf('\u0129') + "L", String.valueOf('\u0129') + "M", String.valueOf('\u0129') + "N", String.valueOf('\u0129') + "O", String.valueOf('\u0129') + "W", String.valueOf('\u0140') + "A", String.valueOf('\u0140') + "B", String.valueOf('\u0140') + "C", String.valueOf('\u0140') + "D", String.valueOf('\u0140') + "E", String.valueOf('\u0140') + "F", String.valueOf('\u0140') + "G", String.valueOf('\u0140') + "H", String.valueOf('\u0140') + "I", String.valueOf('\u0140') + "J", String.valueOf('\u0140') + "K", String.valueOf('\u0140') + "L", String.valueOf('\u0140') + "M", String.valueOf('\u0140') + "N", String.valueOf('\u0140') + "O", String.valueOf('\u0140') + "P", String.valueOf('\u0140') + "Q", String.valueOf('\u0140') + "R", String.valueOf('\u0140') + "S", String.valueOf('\u0140') + "T", String.valueOf('\u0140') + "U", String.valueOf('\u0140') + "V", String.valueOf('\u0140') + "W", String.valueOf('\u0140') + "X", String.valueOf('\u0140') + "Y", String.valueOf('\u0140') + "Z", String.valueOf('\u0129') + "P", String.valueOf('\u0129') + "Q", String.valueOf('\u0129') + "R", String.valueOf('\u0129') + "S", String.valueOf('\u0129') + "T", String.valueOf('\u0129') + "X", String.valueOf('\u0129') + "Y", String.valueOf('\u0129') + "Z"};
    private BarParameters barParameters;

    protected boolean isEnabled() {
        return capability.getEnabled();
    }

    public boolean isScalable() {
        return scalable.getEnabled();
    }

    protected OptionCapability[] getOptionCapabilities() {
        return null;
    }

    protected OptionCapability[] getBarcodeOptionCapabilities() {
        return barcodeOptions;
    }

    public static void registerCapability(Vector vector) {
        vector.addElement(capability);
        vector.addElement(scalable);
        vector.addElement(showCheckDigit);
        vector.addElement(showStartStop);
        int n = 0;
        while (n < barcodeOptions.length) {
            vector.addElement(barcodeOptions[n]);
            ++n;
        }
    }

    public void create(BarcodeParameters barcodeParameters) throws PrinterRemoteException {
        HumanreadableOptions humanreadableOptions = new HumanreadableOptions(barcodeParameters.getBarcodeOptions());
        humanreadableOptions.setShowCheckDigit(showCheckDigit.getEnabled());
        humanreadableOptions.setShowCheckStartStop(showStartStop.getEnabled());
        char c = '\u25fb';
        humanreadableOptions.setStartStop(String.valueOf(c), String.valueOf(c));
        this.create(barcodeParameters.getUserData(), humanreadableOptions, barcodeParameters.getSymbologyOptions());
        this.barParameters = barcodeParameters.getUniwidthBarParameters();
        this.setHeight(this.barParameters.getHeight());
    }

    protected void verifyCapability() throws PrinterRemoteException {
        if (!capability.getEnabled()) {
            throw new PrinterRemoteException(2, BarcodePrintout.NOTSUPPORTED + ":" + Code93Printout.getName());
        }
    }

    protected void validateUserData(String string) throws PrinterRemoteException {
        int n = 0;
        while (n < string.length()) {
            if (!ByteChar.isAscii(string.charAt(n))) {
                throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":not Ascii" + string.charAt(n));
            }
            ++n;
        }
    }

    public String getSymbology() {
        return Code93Printout.getName();
    }

    public static String getName() {
        return "CODE93";
    }

    private int[] encodeFullAscii(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            stringBuffer.append(fullAsciiSet[c]);
            ++n;
        }
        int[] nArray = new int[stringBuffer.length()];
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            nArray[n2] = Code93Printout.charToValue(stringBuffer.charAt(n2));
            ++n2;
        }
        return nArray;
    }

    public void createLayout() {
        double d = 0.0;
        d = this.createBarQuietZone(d, this.barParameters);
        d = this.createBarSpace(this.layoutShapes, charPattern[Code93Printout.charToValue('\u0141')], d, this.barParameters);
        int[] nArray = this.encodeFullAscii(this.getUserData());
        int n = 0;
        while (n < nArray.length) {
            d = this.createBarSpace(this.layoutShapes, charPattern[nArray[n]], d, this.barParameters);
            ++n;
        }
        int n2 = this.calCheckValue(nArray, 0, 0);
        d = this.createBarSpace(this.layoutShapes, charPattern[n2], d, this.barParameters);
        int n3 = this.calCheckValue(nArray, n2, 1);
        d = this.createBarSpace(this.layoutShapes, charPattern[n3], d, this.barParameters);
        String string = String.valueOf(Code93Printout.valueToChar(n2)) + String.valueOf(Code93Printout.valueToChar(n3));
        this.getHumanreadableOptions().setCheckDigits(string);
        d = this.createBarSpace(this.layoutShapes, charPattern[Code93Printout.charToValue('\u0142')], d, this.barParameters);
        d = this.createBarQuietZone(d, this.barParameters);
        this.setWidthPixel(d);
        if (PrinterPerf.isDebugMode()) {
            double d2 = this.barParameters.getBarWidthPixel(0);
            double d3 = nArray.length;
            double d4 = (9.0 * (d3 + 4.0) + 1.0) * d2 + 10.0 * d2;
            double d5 = this.barParameters.getBarWidthPixel(0) * (double)(9 * (nArray.length + 4) + 1) + 20.0 * this.barParameters.getBarWidthPixel(0);
            d5 += 0.0;
            d4 += 0.0;
        }
        super.createLayout();
    }

    private static char valueToChar(int n) {
        return valueCharMap[n];
    }

    private static int charToValue(char c) {
        int n = 0;
        while (n < valueCharMap.length) {
            if (c == valueCharMap[n]) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    private int calCheckValue(int[] nArray, int n, int n2) {
        int n3 = n * n2;
        ++n2;
        int n4 = nArray.length - 1;
        while (n4 >= 0) {
            n3 += n2 * nArray[n4];
            if (++n2 > 20) {
                n2 = 1;
            }
            --n4;
        }
        return n3 %= 47;
    }
}

