/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import java.util.Hashtable;
import java.util.Vector;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.output.barcodeprintout.BarParameters;
import pios.emulator.printer.output.barcodeprintout.BarcodePrintout;
import pios.emulator.printer.output.barcodeprintout.ByteChar;
import pios.emulator.printer.output.barcodeprintout.HumanreadableOptions;
import pios.emulator.printer.output.barcodeprintout.OptionCapability;
import pios.emulator.printer.rmi.BarcodeParameters;
import pios.emulator.printer.rmi.PrinterRemoteException;

public final class Code39Printout
extends BarcodePrintout {
    private static final String DISPLAYNAME = PrinterPerf.getResourceString("Code39Printout_Code39");
    private static final String STR_STANDARD = PrinterPerf.getResourceString("Code39Printout_Standard");
    private static final String STR_FULLASCII = PrinterPerf.getResourceString("Code39Printout_FullAscii");
    private static final String STR_MOD43 = PrinterPerf.getResourceString("Code39Printout_MOD43");
    private static final String STR_FRENCHCIP = PrinterPerf.getResourceString("Code39Printout_FrenchCIP");
    private static final DeviceCapability capability = new DeviceCapability(Code39Printout.getName(), DISPLAYNAME, "CODE39", null);
    private static final DeviceCapability showCheckDigit = new DeviceCapability("ShowCheckDigit", BarcodePrintout.SHOWCHECKDIGIT, "CODE39_HUMAN_READABLE_SHOW_CHECK_DIGIT", capability);
    private static final DeviceCapability showStartStop = new DeviceCapability("ShowStartStop", BarcodePrintout.SHOWSTARTSTOP, "CODE39_HUMAN_READABLE_SHOW_START_STOP", capability);
    private static final DeviceCapability scalable = new DeviceCapability("Scalable", BarcodePrintout.SCALABLE, "CODE39_SCALABLE", capability);
    private static final long STANDARD = 1L;
    private static final long FULLASCII = 2L;
    private static final long CHECK_DIGIT_MOD43 = 4L;
    private static final long CHECK_DIGIT_FRENCH_CIP = 8L;
    private static final OptionCapability[] options = new OptionCapability[]{new OptionCapability(1L, "Standard", STR_STANDARD, capability, "CODE39_STANDARD"), new OptionCapability(2L, "FullASCII", STR_FULLASCII, capability, "CODE39_FULLASCII"), new OptionCapability(4L, "MOD43", STR_MOD43, capability, "CODE39_CHECK_DIGIT_MOD43"), new OptionCapability(8L, "FrenchCIP", STR_FRENCHCIP, capability, "CODE39_CHECK_DIGIT_FRENCH_CIP")};
    private static final OptionCapability[] barcodeOptions = new OptionCapability[]{new OptionCapability(1L, "TextBelow", BarcodePrintout.TEXTBELOW, capability, "CODE39_HUMAN_READABLE_BELOW"), new OptionCapability(2L, "TextAbove", BarcodePrintout.TEXTABOVE, capability, "CODE39_HUMAN_READABLE_ABOVE")};
    private static final Hashtable charPattern = new Hashtable();
    private static String[] fullAsciiSet;
    private static final String START = "*";
    private static final String STOP = "*";
    private BarParameters barParameters;

    protected boolean isEnabled() {
        return capability.getEnabled();
    }

    public boolean isScalable() {
        return scalable.getEnabled();
    }

    protected OptionCapability[] getOptionCapabilities() {
        return options;
    }

    protected OptionCapability[] getBarcodeOptionCapabilities() {
        return barcodeOptions;
    }

    public static void registerCapability(Vector vector) {
        vector.addElement(capability);
        vector.addElement(scalable);
        vector.addElement(showCheckDigit);
        vector.addElement(showStartStop);
        int n = 0;
        while (n < barcodeOptions.length) {
            vector.addElement(barcodeOptions[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < options.length) {
            vector.addElement(options[n2]);
            ++n2;
        }
    }

    public void create(BarcodeParameters barcodeParameters) throws PrinterRemoteException {
        HumanreadableOptions humanreadableOptions = new HumanreadableOptions(barcodeParameters.getBarcodeOptions());
        humanreadableOptions.setShowCheckDigit(showCheckDigit.getEnabled());
        humanreadableOptions.setShowCheckStartStop(showStartStop.getEnabled());
        humanreadableOptions.setStartStop("*", "*");
        this.create(barcodeParameters.getUserData(), humanreadableOptions, barcodeParameters.getSymbologyOptions());
        this.barParameters = barcodeParameters.getDualwidthBarParameters();
        this.setHeight(this.barParameters.getHeight());
    }

    protected void validateUserData(String string) throws PrinterRemoteException {
        int n = 0;
        while (n < this.getUserData().length()) {
            if (this.checkSymbologyOption(2L)) {
                if (!ByteChar.isAscii(string.charAt(n))) {
                    throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":not Ascii-" + string.charAt(n));
                }
            } else if (!charPattern.containsKey(string.substring(n, n + 1))) {
                throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":" + string.substring(n, n + 1));
            }
            ++n;
        }
    }

    public String getSymbology() {
        return Code39Printout.getName();
    }

    public static String getName() {
        return "CODE39";
    }

    private String encodeFullAscii(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            stringBuffer.append(fullAsciiSet[c]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private String addCheckDigitMod43(String string) {
        String string2 = "$";
        this.getHumanreadableOptions().setCheckDigits(string2);
        return string + string2;
    }

    private String addCheckDigitFrenchCIP(String string) {
        String string2 = "%";
        this.getHumanreadableOptions().setCheckDigits(string2);
        return string + string2;
    }

    public void createLayout() {
        String string;
        double d = 0.0;
        d = this.createBarQuietZone(d, this.barParameters);
        d = this.createBarSpace(this.layoutShapes, (String)charPattern.get("*"), d, this.barParameters);
        String string2 = string = this.checkSymbologyOption(2L) ? this.encodeFullAscii(this.getUserData()) : this.getUserData();
        if (this.checkSymbologyOption(4L)) {
            string = this.addCheckDigitMod43(string);
        } else if (this.checkSymbologyOption(8L)) {
            string = this.addCheckDigitFrenchCIP(string);
        }
        int n = 0;
        while (n < string.length()) {
            String string3 = string.substring(n, n + 1);
            d = this.createBarSpace(this.layoutShapes, (String)charPattern.get(string3), d, this.barParameters);
            d += this.barParameters.getInterCharGapPixel();
            ++n;
        }
        d = this.createBarSpace(this.layoutShapes, (String)charPattern.get("*"), d, this.barParameters);
        d = this.createBarQuietZone(d, this.barParameters);
        this.setWidthPixel(d);
        if (PrinterPerf.isDebugMode()) {
            int n2 = string.length();
            double d2 = (double)(n2 + 2) * (3.0 * this.barParameters.getWideToNarrowRatio() + 6.0) * this.barParameters.getBarWidthPixel(0) + (double)(n2 + 1) * this.barParameters.getInterCharGapPixel() + 20.0 * this.barParameters.getBarWidthPixel(0);
            d2 += 0.0;
        }
        super.createLayout();
    }

    static {
        charPattern.put("0", "000110100");
        charPattern.put("1", "100100001");
        charPattern.put("2", "001100001");
        charPattern.put("3", "101100000");
        charPattern.put("4", "000110001");
        charPattern.put("5", "100110000");
        charPattern.put("6", "001110000");
        charPattern.put("7", "000100101");
        charPattern.put("8", "100100100");
        charPattern.put("9", "001100100");
        charPattern.put("A", "100001001");
        charPattern.put("B", "001001001");
        charPattern.put("C", "101001000");
        charPattern.put("D", "000011001");
        charPattern.put("E", "100011000");
        charPattern.put("F", "001011000");
        charPattern.put("G", "000001101");
        charPattern.put("H", "100001100");
        charPattern.put("I", "001001100");
        charPattern.put("J", "000011100");
        charPattern.put("K", "100000011");
        charPattern.put("L", "001000011");
        charPattern.put("M", "101000010");
        charPattern.put("N", "000010011");
        charPattern.put("O", "100010010");
        charPattern.put("P", "001010010");
        charPattern.put("Q", "000000111");
        charPattern.put("R", "100000110");
        charPattern.put("S", "001000110");
        charPattern.put("T", "000010110");
        charPattern.put("U", "110000001");
        charPattern.put("V", "011000001");
        charPattern.put("W", "011000001");
        charPattern.put("X", "111000000");
        charPattern.put("Y", "110010000");
        charPattern.put("Z", "011010000");
        charPattern.put("-", "010000101");
        charPattern.put(".", "110000100");
        charPattern.put(" ", "011000100");
        charPattern.put("$", "010101000");
        charPattern.put("/", "010100010");
        charPattern.put("+", "010001010");
        charPattern.put("%", "000101010");
        charPattern.put("*", "010010100");
        fullAsciiSet = new String[]{"%U", "$A", "$B", "$C", "$D", "$E", "$F", "$G", "$H", "$I", "$J", "$K", "$L", "$M", "$N", "$O", "$P", "$Q", "$R", "$S", "$T", "$U", "$V", "$W", "$X", "$Y", "$Z", "%A", "%B", "%C", "%D", "%E", " ", "/A", "/B", "/C", "/D", "/E", "/F", "/G", "/H", "/I", "/J", "/K", "/L", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "/Z", "%F", "%G", "%H", "%I", "%J", "%V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "%K", "%L", "%M", "%N", "%O", "%W", "+A", "+B", "+C", "+D", "+E", "+F", "+G", "+H", "+I", "+J", "+K", "+L", "+M", "+N", "+O", "+P", "+Q", "+R", "+S", "+T", "+U", "+V", "+W", "+X", "+Y", "+Z", "%P", "%Q", "%R", "%S", "%T", "%X", "%Y", "%Z"};
    }
}

