/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.AliasCapability;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.output.barcodeprintout.BarParameters;
import pios.emulator.printer.output.barcodeprintout.BarcodePrintout;
import pios.emulator.printer.output.barcodeprintout.HumanreadableOptions;
import pios.emulator.printer.output.barcodeprintout.OptionCapability;
import pios.emulator.printer.rmi.BarcodeParameters;
import pios.emulator.printer.rmi.PrinterRemoteException;

public class Code128Printout
extends BarcodePrintout {
    protected static final String STR_CODE128;
    protected static final String STR_StartA;
    protected static final String STR_StartB;
    protected static final String STR_StartC;
    protected static final String STR_StartAUTO;
    protected static final String STR_StartMANUAL;
    private static final DeviceCapability capability;
    private static final DeviceCapability scalable;
    public static final long A = 1L;
    public static final long B = 2L;
    public static final long C = 4L;
    public static final long CHECK_DIGIT_TRANSMIT = 8L;
    public static final long AUTO = 16L;
    private static final OptionCapability[] options;
    private static final OptionCapability[] barcodeOptions;
    public static final Character FNC1;
    public static final Character FNC2;
    public static final Character FNC3;
    private static final Character FNC4;
    private static final Character SHIFT;
    private static final Character CODEA;
    private static final Character CODEB;
    private static final Character CODEC;
    private static final Hashtable specialA;
    private static final Hashtable specialB;
    private static final Hashtable specialC;
    private static final String[] charPattern;
    private static final String STOP = "2331112";
    private static final int STATE_A = 103;
    private static final int STATE_B = 104;
    private static final int STATE_C = 105;
    private int currentState;
    private Vector codewords = new Vector();
    private int startState;
    private BarParameters barParameters;

    protected boolean isEnabled() {
        return capability.getEnabled();
    }

    public boolean isScalable() {
        return scalable.getEnabled();
    }

    protected OptionCapability[] getOptionCapabilities() {
        return options;
    }

    protected OptionCapability[] getBarcodeOptionCapabilities() {
        return barcodeOptions;
    }

    public static void registerCapability(Vector vector) {
        vector.addElement(capability);
        vector.addElement(scalable);
        int n = 0;
        while (n < barcodeOptions.length) {
            vector.addElement(barcodeOptions[n]);
            ++n;
        }
        AliasCapability aliasCapability = new AliasCapability("GroupManual", STR_StartMANUAL, "CODE128_START_CODESET_MANUAL", capability);
        int n2 = 0;
        while (n2 < options.length) {
            if (n2 < 3) {
                aliasCapability.addAliased(options[n2]);
            } else {
                vector.addElement(options[n2]);
            }
            ++n2;
        }
        vector.addElement(aliasCapability);
    }

    public void create(BarcodeParameters barcodeParameters) throws PrinterRemoteException {
        HumanreadableOptions humanreadableOptions = new HumanreadableOptions(barcodeParameters.getBarcodeOptions());
        this.create(barcodeParameters.getUserData(), humanreadableOptions, barcodeParameters.getSymbologyOptions());
        this.barParameters = barcodeParameters.getUniwidthBarParameters();
        this.setHeight(this.barParameters.getHeight());
    }

    protected void validateUserData(String string) throws PrinterRemoteException {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if ((c < '\u0000' || c > '\u00ff') && FNC1.charValue() != c && FNC2.charValue() != c && FNC3.charValue() != c) {
                throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":unrecognized char-" + c);
            }
            ++n;
        }
    }

    public String getSymbology() {
        return Code128Printout.getName();
    }

    public static String getName() {
        return "CODE128";
    }

    public void createLayout() {
        int n;
        this.codewords.clear();
        String string = this.getUserData();
        string = this.encodeFNC4(string);
        this.startState = this.checkSymbologyOption(1L) ? 103 : (this.checkSymbologyOption(2L) ? 104 : (this.checkSymbologyOption(4L) ? 105 : (this.checkSymbologyOption(16L) ? this.determineStartChar(string) : 105)));
        this.encode128(string);
        double d = 0.0;
        d = this.createBarQuietZone(d, this.barParameters);
        d = this.createBarSpace(this.layoutShapes, charPattern[this.startState], d, this.barParameters);
        int n2 = this.startState;
        int n3 = 0;
        while (n3 < this.codewords.size()) {
            n = (Integer)this.codewords.get(n3);
            d = this.createBarSpace(this.layoutShapes, charPattern[n], d, this.barParameters);
            n2 += n * (n3 + 1);
            ++n3;
        }
        n = n2 % 103;
        d = this.createBarSpace(this.layoutShapes, charPattern[n], d, this.barParameters);
        d = this.createBarSpace(this.layoutShapes, STOP, d, this.barParameters);
        d = this.createBarQuietZone(d, this.barParameters);
        this.setWidthPixel(d);
        super.createLayout();
    }

    private boolean isLatin(char c) {
        return c > '\u007f' && c < '\u0100';
    }

    private boolean fourMoreLatin(String string) {
        if (string.length() < 3) {
            return false;
        }
        int n = 0;
        while (n < 3) {
            if (!this.isLatin(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        if (string.length() > 3) {
            return this.isLatin(string.charAt(3));
        }
        return true;
    }

    private boolean isLowerCase(char c) {
        return c >= '`' && c <= '\u007f';
    }

    private boolean isControlChar(char c) {
        return c >= '\u0000' && c <= '\u001f';
    }

    private String encodeFNC4(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        block0: while (n < string.length()) {
            char c;
            if (this.isLatin(c = string.charAt(n++))) {
                stringBuffer.append(FNC4.charValue());
                if (this.fourMoreLatin(string.substring(n))) {
                    stringBuffer.append(FNC4.charValue());
                    stringBuffer.append(c - 128);
                    while (n < string.length()) {
                        if (this.isLatin(c = string.charAt(n++))) {
                            stringBuffer.append(c - 128);
                            continue;
                        }
                        stringBuffer.append(c);
                        continue block0;
                    }
                    continue;
                }
                stringBuffer.append(c - 128);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private void encode128(String string) {
        int n = 0;
        this.currentState = this.startState;
        while (n < string.length()) {
            switch (this.currentState) {
                case 103: {
                    if (this.beginFourNumeric(string.substring(n))) {
                        if (!this.beginNumericEven(string.substring(n))) {
                            n += this.encodeAfter1stDigit(string.substring(n));
                        }
                        this.changeState(105);
                        break;
                    }
                    if (this.isLowerCase(string.charAt(n))) {
                        if (this.followByControlBeforeLowerCase(string.substring(n))) {
                            this.shift();
                            this.codewords.addElement(this.encodeB(string.charAt(n++)));
                            break;
                        }
                        this.changeState(104);
                        break;
                    }
                    this.codewords.addElement(this.encodeA(string.charAt(n++)));
                    break;
                }
                case 104: {
                    if (this.beginFourNumeric(string.substring(n))) {
                        if (!this.beginNumericEven(string.substring(n))) {
                            n += this.encodeAfter1stDigit(string.substring(n));
                        }
                        this.changeState(105);
                        break;
                    }
                    if (this.isControlChar(string.charAt(n))) {
                        if (this.followByLowerCase(string.substring(n))) {
                            this.shift();
                            this.codewords.addElement(this.encodeA(string.charAt(n++)));
                            break;
                        }
                        this.changeState(103);
                        break;
                    }
                    this.codewords.addElement(this.encodeB(string.charAt(n++)));
                    break;
                }
                case 105: {
                    if (this.beginTwoNumberic(string.substring(n))) {
                        n += this.encodeC(string.substring(n));
                        break;
                    }
                    if (this.controlBeforeLowerCase(string.substring(n))) {
                        this.changeState(103);
                        break;
                    }
                    this.changeState(104);
                    break;
                }
            }
        }
    }

    private void changeState(int n) {
        this.codewords.addElement(new Integer(n));
        this.currentState = n;
    }

    private void shift() {
        Integer n = (Integer)(103 == this.currentState ? specialA.get(SHIFT) : specialB.get(SHIFT));
        this.codewords.addElement(n);
    }

    private int determineStartChar(String string) {
        int n = 104;
        n = this.consistOfTwoNumeric(string) || this.beginFourNumeric(string) ? 105 : (this.controlBeforeLowerCase(string) ? 103 : 104);
        return n;
    }

    private boolean consistOfTwoNumeric(String string) {
        return string.length() == 2 && Character.isDigit(string.charAt(0)) && Character.isDigit(string.charAt(1));
    }

    private boolean beginTwoNumberic(String string) {
        int n = this.beginDigitCount(string);
        return n >= 2;
    }

    private boolean beginFourNumeric(String string) {
        int n = this.beginDigitCount(string);
        return n >= 4;
    }

    private boolean beginNumericEven(String string) {
        if (string.length() < 1) {
            return false;
        }
        int n = this.beginDigitCount(string);
        return 0 == n % 2;
    }

    private int beginDigitCount(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (FNC1.charValue() == c && 0 == n2 % 2) {
                n += 2;
            } else {
                if (!Character.isDigit(c)) break;
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private boolean controlBeforeLowerCase(String string) {
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < string.length()) {
            if (this.isLowerCase(string.charAt(n3))) {
                n2 = n3;
                break;
            }
            if (Character.isISOControl(string.charAt(n3))) {
                n = n3;
                break;
            }
            ++n3;
        }
        return n > n2;
    }

    private boolean followByControlBeforeLowerCase(String string) {
        if (string.length() < 2) {
            return false;
        }
        return this.controlBeforeLowerCase(string.substring(1));
    }

    private boolean followByLowerCase(String string) {
        if (string.length() < 2) {
            return false;
        }
        return this.isLowerCase(string.charAt(1));
    }

    private int encodeAfter1stDigit(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n++);
            Integer n2 = this.getCodewordAB(c);
            this.codewords.addElement(n2);
            if (Character.isDigit(c)) break;
        }
        return n;
    }

    private Integer getCodewordAB(char c) {
        return 103 == this.currentState ? this.encodeA(c) : this.encodeB(c);
    }

    private Integer encodeA(char c) {
        Enumeration enumeration = specialA.keys();
        while (enumeration.hasMoreElements()) {
            Character c2 = (Character)enumeration.nextElement();
            if (c2.charValue() != c) continue;
            return (Integer)specialA.get(c2);
        }
        int n = 0;
        n = Character.isISOControl(c) ? c + 64 : c - 32;
        return new Integer(n);
    }

    private Integer encodeB(char c) {
        Enumeration enumeration = specialB.keys();
        while (enumeration.hasMoreElements()) {
            Character c2 = (Character)enumeration.nextElement();
            if (c2.charValue() != c) continue;
            return (Integer)specialB.get(c2);
        }
        int n = c - 32;
        return new Integer(n);
    }

    private int encodeC(String string) {
        char c = string.charAt(0);
        if (FNC1.charValue() == c) {
            this.codewords.addElement(specialC.get(FNC1));
            return 1;
        }
        char c2 = string.charAt(1);
        int n = (c - 48) * 10 + (c2 - 48);
        this.codewords.addElement(new Integer(n));
        return 2;
    }

    static {
        char c;
        STR_CODE128 = PrinterPerf.getResourceString("Code128Printout_Code128");
        STR_StartA = PrinterPerf.getResourceString("Code128Printout_StartA");
        STR_StartB = PrinterPerf.getResourceString("Code128Printout_StartB");
        STR_StartC = PrinterPerf.getResourceString("Code128Printout_StartC");
        STR_StartAUTO = PrinterPerf.getResourceString("Code128Printout_StartAuto");
        STR_StartMANUAL = PrinterPerf.getResourceString("Code128Printout_StartManual");
        capability = new DeviceCapability(Code128Printout.getName(), STR_CODE128, "CODE128", null);
        scalable = new DeviceCapability("Scalable", BarcodePrintout.SCALABLE, "CODE128_SCALABLE", capability);
        options = new OptionCapability[]{new OptionCapability(1L, "StartA", STR_StartA, capability, "CODE128_START_CODESET_MANUAL"), new OptionCapability(2L, "StartB", STR_StartB, capability, "CODE128_START_CODESET_MANUAL"), new OptionCapability(4L, "StartC", STR_StartC, capability, "CODE128_START_CODESET_MANUAL"), new OptionCapability(16L, "Auto", STR_StartAUTO, capability, "CODE128_START_CODESET_AUTO")};
        barcodeOptions = new OptionCapability[]{new OptionCapability(1L, "TextBelow", BarcodePrintout.TEXTBELOW, capability, "CODE128_HUMAN_READABLE_BELOW"), new OptionCapability(2L, "TextAbove", BarcodePrintout.TEXTABOVE, capability, "CODE128_HUMAN_READABLE_ABOVE")};
        char c2 = c = '\u0100';
        c = (char)(c + 1);
        FNC1 = new Character(c2);
        char c3 = c;
        c = (char)(c + '\u0001');
        FNC2 = new Character(c3);
        char c4 = c;
        c = (char)(c + '\u0001');
        FNC3 = new Character(c4);
        char c5 = c;
        c = (char)(c + '\u0001');
        FNC4 = new Character(c5);
        char c6 = c;
        c = (char)(c + '\u0001');
        SHIFT = new Character(c6);
        char c7 = c;
        c = (char)(c + '\u0001');
        CODEA = new Character(c7);
        char c8 = c;
        c = (char)(c + '\u0001');
        CODEB = new Character(c8);
        char c9 = c;
        c = (char)(c + '\u0001');
        CODEC = new Character(c9);
        specialA = new Hashtable();
        specialA.put(FNC3, new Integer(96));
        specialA.put(FNC2, new Integer(97));
        specialA.put(SHIFT, new Integer(98));
        specialA.put(CODEC, new Integer(99));
        specialA.put(CODEB, new Integer(100));
        specialA.put(FNC4, new Integer(101));
        specialA.put(FNC1, new Integer(102));
        specialB = new Hashtable();
        specialB.put(FNC3, new Integer(96));
        specialB.put(FNC2, new Integer(97));
        specialB.put(SHIFT, new Integer(98));
        specialB.put(CODEC, new Integer(99));
        specialB.put(FNC4, new Integer(100));
        specialB.put(CODEA, new Integer(101));
        specialB.put(FNC1, new Integer(102));
        specialC = new Hashtable();
        specialC.put(CODEB, new Integer(100));
        specialC.put(CODEA, new Integer(101));
        specialC.put(FNC1, new Integer(102));
        charPattern = new String[]{"212222", "222122", "222221", "121223", "121322", "131222", "122312", "122312", "132212", "221213", "221312", "231212", "112232", "122132", "122231", "113222", "123122", "123221", "223211", "221132", "221231", "213212", "223112", "312131", "311222", "321122", "321221", "312212", "322112", "322211", "212123", "212321", "232121", "111323", "131123", "131321", "112313", "132113", "132311", "211313", "231113", "231311", "112133", "112331", "132131", "113123", "113321", "133121", "313121", "211331", "231131", "213113", "213311", "213131", "311123", "311321", "331121", "312123", "312311", "332111", "314111", "221411", "431111", "111224", "111422", "121124", "121421", "141122", "141221", "112214", "112412", "122114", "122411", "142112", "142211", "241211", "221114", "413111", "241112", "134111", "111242", "121142", "121241", "114212", "124211", "124211", "411212", "421112", "421211", "212141", "214121", "412121", "111143", "111341", "131141", "114113", "114311", "411113", "411311", "113141", "114131", "311141", "411131", "211412", "211214", "211232"};
    }
}

