/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import java.util.Hashtable;
import java.util.Vector;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.output.barcodeprintout.BarParameters;
import pios.emulator.printer.output.barcodeprintout.BarcodePrintout;
import pios.emulator.printer.output.barcodeprintout.HumanreadableOptions;
import pios.emulator.printer.output.barcodeprintout.OptionCapability;
import pios.emulator.printer.rmi.BarcodeParameters;
import pios.emulator.printer.rmi.PrinterRemoteException;

public final class CodabarPrintout
extends BarcodePrintout {
    private static final String STR_CODABAR = PrinterPerf.getResourceString("CodabarPrintoutt_Codabar");
    private static final String STR_MOD16 = PrinterPerf.getResourceString("CodabarPrintoutt_MOD16");
    private static final DeviceCapability capability = new DeviceCapability(CodabarPrintout.getName(), STR_CODABAR, "CODABAR", null);
    private static final DeviceCapability showCheckDigit = new DeviceCapability("ShowCheckDigit", BarcodePrintout.SHOWCHECKDIGIT, "CODABAR_HUMAN_READABLE_SHOW_CHECK_DIGIT", capability);
    private static final DeviceCapability showStartStop = new DeviceCapability("ShowStartStop", BarcodePrintout.SHOWSTARTSTOP, "CODABAR_HUMAN_READABLE_SHOW_START_STOP", capability);
    private static final DeviceCapability scalable = new DeviceCapability("Scalable", BarcodePrintout.SCALABLE, "CODABAR_SCALABLE", capability);
    public static final long CLSI = 1L;
    public static final long NOTIS = 2L;
    public static final long CHECK_DIGIT_MOD16 = 4L;
    public static final long CHECK_DIGIT_TRANSMIT = 8L;
    private static final OptionCapability[] options = new OptionCapability[]{new OptionCapability(4L, "MOD16", STR_MOD16, capability, "CODABAR_CHECK_DIGIT_MOD16")};
    private static final OptionCapability[] barcodeOptions = new OptionCapability[]{new OptionCapability(1L, "TextBelow", BarcodePrintout.TEXTBELOW, capability, "CODABAR_HUMAN_READABLE_BELOW"), new OptionCapability(2L, "TextAbove", BarcodePrintout.TEXTABOVE, capability, "CODABAR_HUMAN_READABLE_ABOVE")};
    private static final Hashtable charPattern = new Hashtable();
    private static final Hashtable traditionalStarts;
    private static final Hashtable traditionalStops;
    private static final char[] charValues;
    private BarParameters barParameters;

    protected boolean isEnabled() {
        return capability.getEnabled();
    }

    public boolean isScalable() {
        return scalable.getEnabled();
    }

    protected OptionCapability[] getOptionCapabilities() {
        return options;
    }

    protected OptionCapability[] getBarcodeOptionCapabilities() {
        return barcodeOptions;
    }

    public static void registerCapability(Vector vector) {
        vector.addElement(capability);
        vector.addElement(scalable);
        vector.addElement(showCheckDigit);
        vector.addElement(showStartStop);
        int n = 0;
        while (n < barcodeOptions.length) {
            vector.addElement(barcodeOptions[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < options.length) {
            vector.addElement(options[n2]);
            ++n2;
        }
    }

    public void create(BarcodeParameters barcodeParameters) throws PrinterRemoteException {
        HumanreadableOptions humanreadableOptions = new HumanreadableOptions(barcodeParameters.getBarcodeOptions());
        humanreadableOptions.setShowCheckDigit(showCheckDigit.getEnabled());
        humanreadableOptions.setShowCheckStartStop(showStartStop.getEnabled());
        this.create(barcodeParameters.getUserData(), humanreadableOptions, barcodeParameters.getSymbologyOptions());
        this.resetHumanreadable();
        this.barParameters = barcodeParameters.getDualwidthBarParameters();
        this.setHeight(this.barParameters.getHeight());
        this.barParameters.validate();
    }

    public void validateUserData(String string) throws PrinterRemoteException {
        if (string.length() < 2) {
            throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":no data");
        }
        String string2 = string.substring(0, 1);
        if (!traditionalStarts.containsKey(string2) && !traditionalStarts.containsValue(string2)) {
            throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":START:" + string2);
        }
        int n = string.length();
        String string3 = string.substring(n - 1, n);
        if (!traditionalStops.containsKey(string3) && !traditionalStops.containsValue(string3)) {
            throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":STOP:" + string3);
        }
        int n2 = 1;
        while (n2 < n - 1) {
            if (!charPattern.containsKey(string.substring(n2, n2 + 1))) {
                throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":" + string.substring(n2, n2 + 1));
            }
            ++n2;
        }
    }

    public String getSymbology() {
        return CodabarPrintout.getName();
    }

    public static String getName() {
        return "CODABAR";
    }

    public void createLayout() {
        double d = 0.0;
        d = this.createBarQuietZone(d, this.barParameters);
        String string = new String(this.getUserData());
        if (this.checkSymbologyOption(4L)) {
            string = this.addCheckDigitMod16(string);
        }
        int n = 0;
        while (n < string.length()) {
            String string2 = string.substring(n, n + 1);
            d = this.createBarSpace(this.layoutShapes, (String)charPattern.get(string2), d, this.barParameters);
            d += this.barParameters.getInterCharGapPixel();
            ++n;
        }
        d = this.createBarQuietZone(d, this.barParameters);
        this.setWidthPixel(d);
        if (PrinterPerf.isDebugMode()) {
            double d2 = this.barParameters.getBarWidthPixel(0);
            double d3 = this.barParameters.getWideToNarrowRatio();
            int n2 = string.length() - 2;
            int n3 = 0;
            double d4 = this.barParameters.getInterCharGapPixel();
            double d5 = ((2.0 * d3 + 5.0) * (double)(n2 + 2) + (d3 - 1.0) * (double)(n3 + 2)) * d2 + (double)(n2 + 1) * d4 + 20.0 * d2;
            d5 += 0.0;
        }
        super.createLayout();
    }

    private void resetHumanreadable() {
        int n = this.getUserData().length();
        this.getHumanreadableOptions().setUserData(this.getUserData().substring(1, n - 1));
        this.getHumanreadableOptions().setStartStop(this.getUserData().substring(0, 1), this.getUserData().substring(n - 1, n));
    }

    private String addCheckDigitMod16(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            n += this.charToValue(string.charAt(n2));
            ++n2;
        }
        if (0 != (n %= 16)) {
            n = 16 - n;
        }
        String string2 = String.valueOf(this.valueToChar(n));
        this.getHumanreadableOptions().setCheckDigits(string2);
        return string.substring(0, string.length() - 1) + string2 + string.substring(string.length() - 1);
    }

    private char valueToChar(int n) {
        return charValues[n];
    }

    private int charToValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        switch (c) {
            case '-': {
                return 10;
            }
            case '$': {
                return 11;
            }
            case ':': {
                return 12;
            }
            case '/': {
                return 13;
            }
            case '.': {
                return 14;
            }
            case '+': {
                return 15;
            }
            case 'A': 
            case 'a': 
            case 't': {
                return 16;
            }
            case 'B': 
            case 'b': 
            case 'n': {
                return 17;
            }
            case '*': 
            case 'C': 
            case 'c': {
                return 18;
            }
            case 'D': 
            case 'd': 
            case 'e': {
                return 19;
            }
        }
        return 0;
    }

    static {
        charPattern.put("0", "0000011");
        charPattern.put("1", "0000110");
        charPattern.put("2", "0001001");
        charPattern.put("3", "1100000");
        charPattern.put("4", "0010010");
        charPattern.put("5", "1000010");
        charPattern.put("6", "0100001");
        charPattern.put("7", "0100100");
        charPattern.put("8", "0110000");
        charPattern.put("9", "1001000");
        charPattern.put("-", "0001100");
        charPattern.put("$", "0011000");
        charPattern.put(":", "1000101");
        charPattern.put("/", "1010001");
        charPattern.put(".", "1010100");
        charPattern.put("+", "0010101");
        charPattern.put("A", "0011010");
        charPattern.put("B", "0101001");
        charPattern.put("C", "0001011");
        charPattern.put("D", "0001110");
        charPattern.put("a", "0011010");
        charPattern.put("b", "0101001");
        charPattern.put("c", "0001011");
        charPattern.put("d", "0001110");
        charPattern.put("t", "0011010");
        charPattern.put("n", "0101001");
        charPattern.put("*", "0001011");
        charPattern.put("e", "0001110");
        traditionalStarts = new Hashtable();
        traditionalStarts.put("a", "A");
        traditionalStarts.put("b", "B");
        traditionalStarts.put("c", "C");
        traditionalStarts.put("d", "D");
        traditionalStops = new Hashtable();
        traditionalStops.put("t", "A");
        traditionalStops.put("n", "B");
        traditionalStops.put("*", "C");
        traditionalStops.put("e", "D");
        charValues = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '$', ':', '/', '.', '+', 'A', 'B', 'C', 'D'};
    }
}

