/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.output.barcodeprintout.BarParameters;
import pios.emulator.printer.output.barcodeprintout.BarcodePrintout;
import pios.emulator.printer.output.barcodeprintout.ByteChar;
import pios.emulator.printer.output.barcodeprintout.HumanreadableOptions;
import pios.emulator.printer.rmi.BarcodeParameters;
import pios.emulator.printer.rmi.PrinterRemoteException;
import pios.emulator.ui.PResourceBundle;

public abstract class Base2of5Printout
extends BarcodePrintout {
    protected static final String STR_MOD10;
    protected static final long CHECK_DIGIT_MOD10 = 1L;
    protected static final long CHECK_DIGIT_TRANSMIT = 2L;
    private static final String[] charPattern;
    private BarParameters barParameters;

    protected abstract String getStartPattern();

    protected abstract String getStopPattern();

    protected abstract boolean getShowCheckDigit();

    public void create(BarcodeParameters barcodeParameters) throws PrinterRemoteException {
        HumanreadableOptions humanreadableOptions = new HumanreadableOptions(barcodeParameters.getBarcodeOptions());
        humanreadableOptions.setShowCheckDigit(this.getShowCheckDigit());
        this.create(barcodeParameters.getUserData(), humanreadableOptions, barcodeParameters.getSymbologyOptions());
        this.barParameters = barcodeParameters.get2of5BarParameters();
        this.setHeight(this.barParameters.getHeight());
    }

    public void validateUserData(String string) throws PrinterRemoteException {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!ByteChar.isDigital(c)) {
                throw new PrinterRemoteException(3, BarcodePrintout.INVALIDDATA + ":non digital-" + c);
            }
            ++n;
        }
    }

    public void createLayout() {
        String string = new String(this.getUserData());
        if (this.checkSymbologyOption(1L)) {
            string = this.addCheckDigitMod10(string);
        }
        double d = 0.0;
        d = this.createBarQuietZone(d, this.barParameters);
        d = this.createBarSpace(this.layoutShapes, this.getStartPattern(), d, this.barParameters);
        d = this.createGap(this.layoutShapes, d, this.barParameters);
        int n = 0;
        while (n < string.length()) {
            int n2 = Character.getNumericValue(string.charAt(n));
            d = this.createBarSpace(this.layoutShapes, charPattern[n2], d, this.barParameters);
            d = this.createGap(this.layoutShapes, d, this.barParameters);
            ++n;
        }
        d = this.createBarSpace(this.layoutShapes, this.getStopPattern(), d, this.barParameters);
        d = this.createGap(this.layoutShapes, d, this.barParameters);
        d = this.createBarQuietZone(d, this.barParameters);
        this.setWidthPixel(d);
        super.createLayout();
    }

    private String addCheckDigitMod10(String string) {
        int[] nArray = new int[]{3, 1};
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            n += nArray[n3 % 2] * (string.charAt(n2 - n3 - 1) - 48);
            ++n3;
        }
        if (0 != (n %= 10)) {
            n = 10 - n;
        }
        char c = '0';
        c = (char)(c + n);
        this.getHumanreadableOptions().setCheckDigits(String.valueOf(c));
        return string + String.valueOf(c);
    }

    static {
        PResourceBundle pResourceBundle = PrinterPerf.getResourceBundle();
        STR_MOD10 = pResourceBundle.getString("Base2of5Printout_MOD10");
        charPattern = new String[]{"00110", "10001", "01001", "11000", "00101", "10100", "01100", "00011", "10010", "01010"};
    }
}

