/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import pios.emulator.printer.PointEx;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.TwoD;
import pios.emulator.printer.Units;
import pios.emulator.printer.models.FontModel;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.models.PrinterAttribute;
import pios.emulator.printer.models.PrinterRequirement;
import pios.emulator.printer.output.Printout;
import pios.emulator.printer.output.barcodeprintout.BarParameters;
import pios.emulator.printer.output.barcodeprintout.HumanreadableOptions;
import pios.emulator.printer.output.barcodeprintout.OptionCapability;
import pios.emulator.printer.rmi.BarcodeParameters;
import pios.emulator.printer.rmi.PrinterRemoteException;

public abstract class BarcodePrintout
extends Printout {
    private static final String SYMBOLOGY = PrinterPerf.getResourceString("BarcodePrintout_Symbology");
    private static final String DATA = PrinterPerf.getResourceString("BarcodePrintout_Data");
    private static final String BARSIZE = PrinterPerf.getResourceString("BarcodePrintout_BarSize");
    private static final String BARCODE = PrinterPerf.getResourceString("BarcodePrintout_Barcode");
    protected static final String INVALIDDATA = PrinterPerf.getResourceString("BarcodePrintout_InvalidData");
    protected static final String MODULESIZE = PrinterPerf.getResourceString("BarcodePrintout_ModuleSize");
    protected static final String MODULEARRAY = PrinterPerf.getResourceString("BarcodePrintout_ModuleArray");
    protected static final String NOTSUPPORTED = PrinterPerf.getResourceString("BarcodePrintout_NotSupported");
    protected static final String TEXTABOVE = PrinterPerf.getResourceString("BarcodePrintout_TextAbove");
    protected static final String TEXTBELOW = PrinterPerf.getResourceString("BarcodePrintout_TextBelow");
    protected static final String SHOWCHECKDIGIT = PrinterPerf.getResourceString("BarcodePrintout_ShowCheckDigit");
    protected static final String SHOWSTARTSTOP = PrinterPerf.getResourceString("BarcodePrintout_ShowStartStop");
    protected static final String SCALABLE = PrinterPerf.getResourceString("BarcodePrintout_Scalable");
    protected Vector layoutShapes = new Vector();
    public static final Color QUIET_ZONE_COLOR = PreferenceModel.getInstance().getColorProperty("color.quietzone");
    protected Font barcodeFont = FontModel.getDefaultFont().getFont();
    private long symbologyOptions;
    private String userData;
    private double height;
    private double width;
    private HumanreadableOptions humanreadableOptions;
    private TextLayout fixedHumanreadable;

    public abstract void create(BarcodeParameters var1) throws PrinterRemoteException;

    protected abstract void validateUserData(String var1) throws PrinterRemoteException;

    protected abstract boolean isEnabled();

    public abstract boolean isScalable();

    protected abstract OptionCapability[] getOptionCapabilities();

    protected OptionCapability[] getBarcodeOptionCapabilities() {
        return null;
    }

    protected void create(String string, HumanreadableOptions humanreadableOptions, long l) throws PrinterRemoteException {
        this.userData = string;
        if (0 == string.length()) {
            throw new PrinterRemoteException(3, INVALIDDATA + ":zero length");
        }
        humanreadableOptions.setUserData(this.userData);
        this.humanreadableOptions = humanreadableOptions;
        this.symbologyOptions = l;
        this.setProperty(SYMBOLOGY, this.getSymbology());
        this.setProperty(DATA, string);
        this.verifyCapability();
        this.validateUserData(string);
    }

    protected String getUserData() {
        return this.userData;
    }

    public String getPrintoutTypeName() {
        return BARCODE;
    }

    private void verifyCapability() throws PrinterRemoteException {
        OptionCapability[] optionCapabilityArray;
        if (!this.isEnabled()) {
            throw new PrinterRemoteException(2, "Symbology:" + this.getSymbology());
        }
        OptionCapability[] optionCapabilityArray2 = this.getBarcodeOptionCapabilities();
        if (null != optionCapabilityArray2) {
            int n = 0;
            while (n < optionCapabilityArray2.length) {
                long l = optionCapabilityArray2[n].getOption();
                if (this.checkBarcodeOption(l) && !optionCapabilityArray2[n].getEnabled()) {
                    throw new PrinterRemoteException(2, "Option:" + this.getSymbology() + "." + optionCapabilityArray2[n].getDisplayName());
                }
                ++n;
            }
        }
        if (null != (optionCapabilityArray = this.getOptionCapabilities())) {
            int n = 0;
            while (n < optionCapabilityArray.length) {
                long l = optionCapabilityArray[n].getOption();
                if (this.checkSymbologyOption(l) && !optionCapabilityArray[n].getEnabled()) {
                    throw new PrinterRemoteException(2, "Option:" + this.getSymbology() + "." + optionCapabilityArray[n].getDisplayName());
                }
                ++n;
            }
        }
    }

    protected HumanreadableOptions getHumanreadableOptions() {
        return this.humanreadableOptions;
    }

    protected void setHeight(double d) {
        this.height = d;
        this.updateDimension();
    }

    protected double getHeight() {
        return this.height;
    }

    protected double getHeightPixel() {
        return Units.pointToPixel(this.height);
    }

    protected void setWidth(double d) {
        this.width = d;
        this.updateDimension();
    }

    protected void setWidthPixel(double d) {
        this.setWidth(Units.pixelToPoint(d));
    }

    protected double getWidthPixel() {
        return Units.pointToPixel(this.width);
    }

    protected void updateDimension() {
        PointEx pointEx = new PointEx(this.width, this.height);
        this.setProperty(BARSIZE, pointEx.getDisplayString());
    }

    protected boolean checkSymbologyOption(long l) {
        if (l == this.symbologyOptions && l == 0L) {
            return true;
        }
        return (this.symbologyOptions & l) > 0L;
    }

    protected boolean checkBarcodeOption(long l) {
        return this.humanreadableOptions.checkOption(l);
    }

    public abstract String getSymbology();

    public boolean isUserDataValid() {
        return true;
    }

    public void createLayout() {
        this.fixedHumanreadable = this.humanreadableOptions.createLayout();
    }

    public AffineTransform getTransform() {
        AffineTransform affineTransform = super.getTransform();
        if (this.humanreadableOptions.isShow() && this.humanreadableOptions.isAbove()) {
            double d = Printout.getTextLayoutHeight(this.fixedHumanreadable);
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.translate(0.0, d);
            affineTransform.concatenate(affineTransform2);
        }
        return affineTransform;
    }

    public void render(Graphics2D graphics2D, AffineTransform affineTransform) {
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        AffineTransform affineTransform2 = graphics2D.getTransform();
        AffineTransform affineTransform3 = new AffineTransform(affineTransform);
        affineTransform3.concatenate(this.getTransform());
        graphics2D.transform(affineTransform3);
        int n = 0;
        while (n < this.layoutShapes.size()) {
            LayoutShape layoutShape = (LayoutShape)this.layoutShapes.get(n);
            layoutShape.render(graphics2D);
            ++n;
        }
        this.renderFixedHumanreadable(graphics2D);
        graphics2D.setTransform(affineTransform2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    public TwoD getSizePixel() {
        double d = 0.0;
        if (this.humanreadableOptions.isShow() && !this.humanreadableOptions.getForUPC()) {
            d = Printout.getTextLayoutHeight(this.fixedHumanreadable);
        }
        TwoD twoD = new TwoD(this.getWidthPixel(), this.getHeightPixel() + d);
        return twoD;
    }

    public TwoD getFixedHumanreadableDimension() {
        TwoD twoD = new TwoD(Printout.getTextLayoutWidth(this.fixedHumanreadable), Printout.getTextLayoutHeight(this.fixedHumanreadable));
        return twoD;
    }

    protected double createBarSpace(Vector vector, String string, double d, BarParameters barParameters) {
        int n = 0;
        while (n < string.length()) {
            int n2 = string.charAt(n) - 48;
            Color color = n % 2 == 1 ? Color.white : Color.black;
            vector.addElement(new LayoutShape(d, 0.0, barParameters.getBarWidthPixel(n2), barParameters.getHeightPixel(), color));
            d += barParameters.getBarWidthPixel(n2);
            ++n;
        }
        return d;
    }

    protected double createGap(Vector vector, double d, BarParameters barParameters) {
        if (barParameters.getInterCharGapPixel() > 0.0) {
            vector.addElement(new LayoutShape(d, 0.0, barParameters.getInterBarPixel(), barParameters.getHeightPixel(), Color.white));
            d += barParameters.getInterBarPixel();
        }
        return d;
    }

    protected void renderFixedHumanreadable(Graphics2D graphics2D) {
        if (this.humanreadableOptions.isShow() && !this.humanreadableOptions.getForUPC()) {
            float f = 0.0f;
            f = (float)(this.getWidthPixel() / 2.0 - Printout.getTextLayoutWidth(this.fixedHumanreadable) / 2.0);
            float f2 = 0.0f;
            if (!this.humanreadableOptions.isAbove()) {
                f2 = (float)((double)f2 + (this.getHeightPixel() + Printout.getTextLayoutHeight(this.fixedHumanreadable)));
            }
            this.fixedHumanreadable.draw(graphics2D, f, f2 -= this.fixedHumanreadable.getDescent());
        }
    }

    protected double createBarQuietZone(double d, BarParameters barParameters) {
        if (!PreferenceModel.getInstance().getBooleanProperty("quiet.zone.visible")) {
            return d;
        }
        this.createQuietZone(d, 0.0, barParameters.getQuietZonePixel(), barParameters.getHeightPixel());
        return d + barParameters.getQuietZonePixel();
    }

    protected void createQuietZone(double d, double d2, double d3, double d4) {
        if (d3 <= 0.0 || d4 <= 0.0) {
            return;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        this.layoutShapes.addElement(new LayoutShape(double_, QUIET_ZONE_COLOR));
    }

    class LayoutShape {
        private Shape moduleShape;
        private Color moduleColor;
        boolean toFill = true;
        boolean toDraw = true;

        public LayoutShape(double d, double d2, double d3, double d4, Color color) {
            this.moduleShape = new Rectangle2D.Double(d, d2, d3, d4);
            this.moduleColor = color;
        }

        public LayoutShape(Shape shape, Color color) {
            this.moduleShape = shape;
            this.moduleColor = color;
        }

        public void render(Graphics2D graphics2D) {
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(this.moduleColor);
            if (this.toDraw) {
                graphics2D.draw(this.moduleShape);
            }
            if (this.toFill) {
                graphics2D.fill(this.moduleShape);
            }
            graphics2D.setPaint(paint);
        }

        public void setToDraw(boolean bl) {
            this.toDraw = bl;
        }

        public void setToFill(boolean bl) {
            this.toFill = bl;
        }
    }

    static interface Attributes
    extends PrinterAttribute {
        public static final String UPC_E = "UPC_E";
        public static final String CODE93 = "CODE93";
        public static final String CODE93_HUMAN_READABLE_BELOW = "CODE93_HUMAN_READABLE_BELOW";
        public static final String CODE93_HUMAN_READABLE_ABOVE = "CODE93_HUMAN_READABLE_ABOVE";
        public static final String DATAMATRIX = "DATAMATRIX";
        public static final String STANDARD2OF5 = "STANDARD2OF5";
        public static final String STANDARD2OF5_HUMAN_READABLE_BELOW = "STANDARD2OF5_HUMAN_READABLE_BELOW";
        public static final String STANDARD2OF5_HUMAN_READABLE_ABOVE = "STANDARD2OF5_HUMAN_READABLE_ABOVE";
        public static final String STANDARD2OF5_CHECK_DIGIT_MOD10 = "STANDARD2OF5_CHECK_DIGIT_MOD10";
        public static final String INDUSTRIAL2OF5 = "INDUSTRIAL2OF5";
        public static final String INDUSTRIAL2OF5_HUMAN_READABLE_BELOW = "INDUSTRIAL2OF5_HUMAN_READABLE_BELOW";
        public static final String INDUSTRIAL2OF5_HUMAN_READABLE_ABOVE = "INDUSTRIAL2OF5_HUMAN_READABLE_ABOVE";
        public static final String INDUSTRIAL2OF5_CHECK_DIGIT_MOD10 = "INDUSTRIAL2OF5_CHECK_DIGIT_MOD10";
        public static final String MATRIX2OF5 = "MATRIX2OF5";
        public static final String MATRIX2OF5_CHECK_DIGIT_MOD10 = "MATRIX2OF5_CHECK_DIGIT_MOD10";
        public static final String MATRIX2OF5_HUMAN_READABLE_BELOW = "MATRIX2OF5_HUMAN_READABLE_BELOW";
        public static final String MATRIX2OF5_HUMAN_READABLE_ABOVE = "MATRIX2OF5_HUMAN_READABLE_ABOVE";
        public static final String MAXICODE = "MAXICODE";
        public static final String MICROPDF417 = "MICROPDF417";
    }

    static interface Requirements
    extends PrinterRequirement {
        public static final String CODE93 = "CODE93";
        public static final String CODE93_SCALABLE = "CODE93_SCALABLE";
        public static final String CODE93_HUMAN_READABLE_BELOW = "CODE93_HUMAN_READABLE_BELOW";
        public static final String CODE93_HUMAN_READABLE_ABOVE = "CODE93_HUMAN_READABLE_ABOVE";
        public static final String CODE93_HUMAN_READABLE_SHOW_CHECK_DIGIT = "CODE93_HUMAN_READABLE_SHOW_CHECK_DIGIT";
        public static final String CODE93_HUMAN_READABLE_SHOW_START_STOP = "CODE93_HUMAN_READABLE_SHOW_START_STOP";
        public static final String DATAMATRIX = "DATAMATRIX";
        public static final String DATAMATRIX_SCALABLE = "DATAMATRIX_SCALABLE";
        public static final String STANDARD2OF5 = "STANDARD2OF5";
        public static final String STANDARD2OF5_SCALABLE = "STANDARD2OF5_SCALABLE";
        public static final String STANDARD2OF5_HUMAN_READABLE_BELOW = "STANDARD2OF5_HUMAN_READABLE_BELOW";
        public static final String STANDARD2OF5_HUMAN_READABLE_ABOVE = "STANDARD2OF5_HUMAN_READABLE_ABOVE";
        public static final String STANDARD2OF5_CHECK_DIGIT_MOD10 = "STANDARD2OF5_CHECK_DIGIT_MOD10";
        public static final String STANDARD2OF5_HUMAN_READABLE_SHOW_CHECK_DIGIT = "STANDARD2OF5_HUMAN_READABLE_SHOW_CHECK_DIGIT";
        public static final String INDUSTRIAL2OF5 = "INDUSTRIAL2OF5";
        public static final String INDUSTRIAL2OF5_SCALABLE = "INDUSTRIAL2OF5_SCALABLE";
        public static final String INDUSTRIAL2OF5_HUMAN_READABLE_BELOW = "INDUSTRIAL2OF5_HUMAN_READABLE_BELOW";
        public static final String INDUSTRIAL2OF5_HUMAN_READABLE_ABOVE = "INDUSTRIAL2OF5_HUMAN_READABLE_ABOVE";
        public static final String INDUSTRIAL2OF5_CHECK_DIGIT_MOD10 = "INDUSTRIAL2OF5_CHECK_DIGIT_MOD10";
        public static final String INDUSTRIAL2OF5_HUMAN_READABLE_SHOW_CHECK_DIGIT = "INDUSTRIAL2OF5_HUMAN_READABLE_SHOW_CHECK_DIGIT";
        public static final String MATRIX2OF5 = "MATRIX2OF5";
        public static final String MATRIX2OF5_SCALABLE = "MATRIX2OF5_SCALABLE";
        public static final String MATRIX2OF5_CHECK_DIGIT_MOD10 = "MATRIX2OF5_CHECK_DIGIT_MOD10";
        public static final String MATRIX2OF5_HUMAN_READABLE_BELOW = "MATRIX2OF5_HUMAN_READABLE_BELOW";
        public static final String MATRIX2OF5_HUMAN_READABLE_ABOVE = "MATRIX2OF5_HUMAN_READABLE_ABOVE";
        public static final String MATRIX2OF5_HUMAN_READABLE_SHOW_CHECK_DIGIT = "MATRIX2OF5_HUMAN_READABLE_SHOW_CHECK_DIGIT";
        public static final String MAXICODE = "MAXICODE";
        public static final String MICROPDF417 = "MICROPDF417";
        public static final String MICROPDF417_SCALABLE = "MICROPDF417_SCALABLE";
        public static final String UPC_E = "UPC_E";
        public static final String UPC_E_SCALABLE = "Scalable";
        public static final String UPC_E_TWO_DIGIT_ADDON = "UPC_E_TWO_DIGIT_ADDON";
        public static final String UPC_E_FIVE_DIGIT_ADDON = "UPC_E_FIVE_DIGIT_ADDON";
        public static final String UPC_E_SHOW_HUMAN_READABLE = "UPC_E_SHOW_HUMAN_READABLE";
    }
}

