/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output.barcodeprintout;

import pios.emulator.printer.Units;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.rmi.PrinterRemoteException;

public class BarParameters {
    private final double minHeight = Units.inchToPoint(0.2);
    private final double minN = 1.8;
    private final double maxN = 3.4;
    private final double minX = Units.inchToPoint(0.0075);
    private final double minI = 1.0;
    private final double maxI = 5.3;
    private final double minQFactor = 10.0;
    private static final int Q_FACTOR = 10;
    private double narrowElementWidth;
    private double wideToNarrowRatio;
    private double interCharGap;
    private double interBarGap;
    private double height;
    private static final String INVALID = "Invalid Bar Parameter:";

    private BarParameters(double d, double d2, double d3, double d4, double d5) {
        this.height = d;
        this.narrowElementWidth = d2;
        this.wideToNarrowRatio = d3;
        this.interCharGap = d4;
        this.interBarGap = d5;
    }

    public static BarParameters createDualwidth(double d, double d2, double d3, double d4) {
        return new BarParameters(d, d2, d3, d4, 0.0);
    }

    public static BarParameters createUniwidth(double d, double d2) {
        return new BarParameters(d, d2, 1.0, 0.0, 0.0);
    }

    public static BarParameters create2of5(double d, double d2, double d3, double d4) {
        return new BarParameters(d, d2, d3, 0.0, d4);
    }

    public double getWideToNarrowRatio() {
        return this.wideToNarrowRatio;
    }

    public double getInterCharGapPixel() {
        return Units.pointToPixel(this.interCharGap);
    }

    public double getInterBarPixel() {
        return Units.pointToPixel(this.interBarGap);
    }

    public double getHeightPixel() {
        return Units.pointToPixel(this.height);
    }

    public double getHeight() {
        return this.height;
    }

    public double getBarWidthPixel(int n) {
        switch (n) {
            case 0: {
                return Units.pointToPixel(this.narrowElementWidth);
            }
            case 1: {
                return Units.pointToPixel(this.narrowElementWidth * this.wideToNarrowRatio);
            }
        }
        return Units.pointToPixel(this.narrowElementWidth * (double)n);
    }

    public double getNarrowElementWidth() {
        return this.narrowElementWidth;
    }

    public double getQuietZonePixel() {
        return 10.0 * this.getBarWidthPixel(0);
    }

    public final void validate() throws PrinterRemoteException {
        if (!PreferenceModel.getInstance().getBooleanProperty("validation.bar.parameter")) {
            return;
        }
        if (this.height < this.minHeight) {
            throw new PrinterRemoteException(3, "Invalid Bar Parameter:minimal height is " + this.minHeight + " points. height is " + this.height);
        }
        if (this.wideToNarrowRatio < 1.8 || this.wideToNarrowRatio > 3.4) {
            throw new PrinterRemoteException(3, "Invalid Bar Parameter:Wide to Narrow Ratio must be between 1.8 and 3.4 N is " + this.wideToNarrowRatio);
        }
        if (this.narrowElementWidth < this.minX) {
            throw new PrinterRemoteException(3, "Invalid Bar Parameter:minimal X is " + this.minX + " point, X is " + this.narrowElementWidth);
        }
        if (this.interCharGap < this.narrowElementWidth * 1.0 || this.interCharGap > this.narrowElementWidth * 5.3) {
            throw new PrinterRemoteException(3, "Invalid Bar Parameter:InterCharGap must be between 1.0X and 5.3X. It is " + this.interCharGap / this.narrowElementWidth);
        }
    }
}

