/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output;

import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.TwoD;
import pios.emulator.printer.output.Printout;
import pios.emulator.printer.rmi.FontParameters;

public final class TextPrintout
extends Printout {
    private static final String XFACTOR = PrinterPerf.getResourceString("TextPrintout_XFactor");
    private static final String YFACTOR = PrinterPerf.getResourceString("TextPrintout_YFactor");
    private static final String FONTNAME = PrinterPerf.getResourceString("TextPrintout_FontName");
    private static final String FONTSIZE = PrinterPerf.getResourceString("TextPrintout_FontSize");
    private static final String DATA = PrinterPerf.getResourceString("TextPrintout_Data");
    private static final String TEXT = PrinterPerf.getResourceString("TextPrintout_Text");
    boolean isEmptyString = false;
    private TextLayout textLayout;
    private String text;
    private FontParameters font;
    private AffineTransform mutiplier;
    private AffineTransform topLeftAt;
    private boolean createdLayout;

    public TextPrintout(String string, FontParameters fontParameters) {
        this.isEmptyString = string.length() == 0;
        this.text = string;
        this.font = fontParameters;
        this.setProperty(XFACTOR, Integer.toString(fontParameters.getFactorX()));
        this.setProperty(YFACTOR, Integer.toString(fontParameters.getFactorX()));
        this.setProperty(DATA, string);
        this.setProperty(FONTNAME, fontParameters.getFont().getFontName());
        this.setProperty(FONTSIZE, Double.toString(fontParameters.getSize()));
        this.createdLayout = false;
        this.mutiplier = new AffineTransform();
        this.mutiplier.scale(fontParameters.getFactorX(), fontParameters.getFactorY());
    }

    public String getPrintoutTypeName() {
        return TEXT;
    }

    public void createLayout() {
        this.textLayout = new TextLayout(this.isEmptyString ? "EMPTYSTRING" : this.text, this.font.getFont(), new FontRenderContext(null, false, false));
        this.topLeftAt = new AffineTransform();
        this.topLeftAt.translate(0.0, (float)this.font.getFactorY() * this.textLayout.getAscent());
        this.createdLayout = true;
    }

    public void render(Graphics2D graphics2D, AffineTransform affineTransform) {
        if (this.isEmptyString) {
            return;
        }
        AffineTransform affineTransform2 = graphics2D.getTransform();
        AffineTransform affineTransform3 = new AffineTransform(affineTransform);
        affineTransform3.concatenate(this.getTransform());
        affineTransform3.concatenate(this.topLeftAt);
        affineTransform3.concatenate(this.mutiplier);
        graphics2D.transform(affineTransform3);
        this.textLayout.draw(graphics2D, 0.0f, 0.0f);
        if (this.font.hasOption(8L)) {
            int n = (int)Math.ceil(Printout.getTextLayoutWidth(this.textLayout));
            graphics2D.drawLine(0, 0, n, 0);
        }
        graphics2D.setTransform(affineTransform2);
    }

    public TwoD getSizePixel() {
        if (!this.createdLayout) {
            this.createLayout();
        }
        double d = Printout.getTextLayoutHeight(this.textLayout);
        double d2 = this.isEmptyString ? 0.0 : Printout.getTextLayoutWidth(this.textLayout);
        TwoD twoD = new TwoD(d2 *= this.mutiplier.getScaleX(), d *= this.mutiplier.getScaleY());
        return twoD;
    }
}

