/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import pios.emulator.printer.PrinterEngine;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.FontModel;
import pios.emulator.printer.models.ImageBufferModel;
import pios.emulator.printer.models.MediaModel;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.models.PrinterBufferModel;
import pios.emulator.printer.models.ResolutionModel;
import pios.emulator.printer.models.StateModel;
import pios.emulator.printer.models.StatusModel;
import pios.emulator.printer.output.PrintCanvas;
import pios.emulator.printer.setups.ButtonEx;
import pios.emulator.printer.setups.CapabilityDialog;
import pios.emulator.printer.setups.SetupDialog;

public final class StateView
extends JPanel {
    private static final String PRINTBUFFER = PrinterPerf.getResourceString("StateView_PrintBuffer");
    private static final String IMAGEBUFFER = PrinterPerf.getResourceString("StateView_ImageBuffer");
    private static final String STATEBUFFER = PrinterPerf.getResourceString("StateView_StateBuffer");
    private static final String CAPABILITY = PrinterPerf.getResourceString("StateView_Capability");
    private static final String SETUP = PrinterPerf.getResourceString("StateView_Setup");
    private static final String ONOFFLINE = PrinterPerf.getResourceString("StateView_OnOffLine");
    private static final String RESET = PrinterPerf.getResourceString("StateView_Reset");
    private static final String LINEFEED = PrinterPerf.getResourceString("StateView_Linefeed");
    private static final String INVALID_SETUP = PrinterPerf.getResourceString("StateView_InvalidSetup");
    private static final String SETUP_REMINDER = PrinterPerf.getResourceString("StateView_SetupReminder");
    private static final char PRINTBUFFER_MNEMONIC = PrinterPerf.getResourceString("StateView_PrintBuffer.MNEMONIC").charAt(0);
    private static final char IMAGEBUFFER_MNEMONIC = PrinterPerf.getResourceString("StateView_ImageBuffer.MNEMONIC").charAt(0);
    private static final char STATEBUFFER_MNEMONIC = PrinterPerf.getResourceString("StateView_StateBuffer.MNEMONIC").charAt(0);
    private static final char RESET_MNEMONIC = PrinterPerf.getResourceString("StateView_Reset.MNEMONIC").charAt(0);
    private static final char CAPABILITY_MNEMONIC = PrinterPerf.getResourceString("StateView_Capability.MNEMONIC").charAt(0);
    private static final char SETUP_MNEMONIC = PrinterPerf.getResourceString("StateView_Setup.MNEMONIC").charAt(0);
    private static final char ONOFFLINE_MNEMONIC = PrinterPerf.getResourceString("StateView_OnOffLine.MNEMONIC").charAt(0);
    private static final char LINEFEED_MNEMONIC = PrinterPerf.getResourceString("StateView_Linefeed.MNEMONIC").charAt(0);
    private JFrame frame;
    private JTree bufferTree;
    private Vector offlineComponents = new Vector();
    private JButton resetButton = null;
    private JButton setupButton = null;
    private JButton capabilityButton = null;
    private JButton linefeedButton = null;
    private JButton onOfflineButton = null;
    private static final EmptyBorder labelBorder = new EmptyBorder(0, 5, 0, 0);
    private boolean isLayoutInitialized;
    private static StateView instance = null;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public JButton getResetButton() {
        if (null == this.resetButton) {
            this.resetButton = this.createResetButton();
        }
        return this.resetButton;
    }

    public JButton getSetupButton() {
        if (null == this.setupButton) {
            this.setupButton = this.createSetupButton();
        }
        return this.setupButton;
    }

    public JButton getCapabilityButton() {
        if (null == this.capabilityButton) {
            this.capabilityButton = this.createCapabilityButton();
        }
        return this.capabilityButton;
    }

    public JButton getLinefeedButton() {
        if (null == this.linefeedButton) {
            this.linefeedButton = this.createRollButton();
        }
        return this.linefeedButton;
    }

    public JButton getOnOfflineButton() {
        if (null == this.onOfflineButton) {
            this.onOfflineButton = this.createOnOffLineButton();
        }
        return this.onOfflineButton;
    }

    public static StateView getInstance() {
        if (null == instance) {
            instance = new StateView();
            instance.initLayout();
        }
        return instance;
    }

    private StateView() {
        Dimension dimension = new Dimension();
        dimension.width = PreferenceModel.getInstance().getIntProperty("view.state.width");
        this.setMinimumSize(dimension);
        this.isLayoutInitialized = false;
    }

    private void initLayout() {
        this.setLayout(new BoxLayout(this, 1));
        this.createBufferTree();
        this.createImageBufferList();
        this.createStateTable();
        this.isLayoutInitialized = true;
    }

    private JButton createCapabilityButton() {
        ImageIcon imageIcon = PrinterPerf.getImageIcon("printer.capability.gif");
        ButtonEx buttonEx = new ButtonEx(CAPABILITY, imageIcon);
        buttonEx.setActionCommand(buttonEx.getText());
        buttonEx.setMnemonic(CAPABILITY_MNEMONIC);
        ((AbstractButton)buttonEx).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CapabilityDialog capabilityDialog = new CapabilityDialog(StateView.this.getFrame());
                capabilityDialog.setVisible(true);
                StateView.this.validateSetups();
            }
        });
        this.offlineComponents.add(buttonEx);
        return buttonEx;
    }

    private JFrame getFrame() {
        if (null == this.frame) {
            Container container = this.getParent();
            while (!(class$javax$swing$JFrame == null ? StateView.class$("javax.swing.JFrame") : class$javax$swing$JFrame).isInstance(container)) {
                container = container.getParent();
            }
            this.frame = (JFrame)container;
        }
        return this.frame;
    }

    private JButton createSetupButton() {
        ImageIcon imageIcon = PrinterPerf.getImageIcon("printer.setup.gif");
        ButtonEx buttonEx = new ButtonEx(SETUP, imageIcon);
        buttonEx.setActionCommand(buttonEx.getText());
        buttonEx.setMnemonic(SETUP_MNEMONIC);
        ((AbstractButton)buttonEx).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetupDialog setupDialog = new SetupDialog(StateView.this.getFrame());
                setupDialog.setVisible(true);
                StateView.this.linefeedButton.setEnabled(MediaModel.getCurrentMedia().isContinuous());
            }
        });
        this.offlineComponents.add(buttonEx);
        return buttonEx;
    }

    private JButton createOnOffLineButton() {
        ImageIcon imageIcon = PrinterPerf.getImageIcon("printer.onoff.gif");
        ButtonEx buttonEx = new ButtonEx(ONOFFLINE, imageIcon);
        buttonEx.setActionCommand(buttonEx.getText());
        buttonEx.setMnemonic(ONOFFLINE_MNEMONIC);
        ((AbstractButton)buttonEx).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StatusModel.isOnLine()) {
                    StatusModel.offLine();
                } else {
                    StatusModel.onLine();
                }
                StateView.this.resetOfflineButtons();
            }
        });
        return buttonEx;
    }

    private JButton createResetButton() {
        ImageIcon imageIcon = PrinterPerf.getImageIcon("printer.reset.gif");
        ButtonEx buttonEx = new ButtonEx(RESET, imageIcon);
        buttonEx.setActionCommand(buttonEx.getText());
        buttonEx.setMnemonic(RESET_MNEMONIC);
        ((AbstractButton)buttonEx).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrinterEngine.reset();
                StateView.this.resetOfflineButtons();
            }
        });
        return buttonEx;
    }

    private JButton createRollButton() {
        ImageIcon imageIcon = PrinterPerf.getImageIcon("printer.linefeed.gif");
        ButtonEx buttonEx = new ButtonEx(LINEFEED, imageIcon);
        buttonEx.setActionCommand(buttonEx.getText());
        buttonEx.setMnemonic(LINEFEED_MNEMONIC);
        buttonEx.setEnabled(MediaModel.getCurrentMedia().isContinuous());
        ((AbstractButton)buttonEx).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintCanvas.getInstance().advance(PreferenceModel.getInstance().getLinefeed());
            }
        });
        return buttonEx;
    }

    private void createImageBufferList() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JList jList = new JList(ImageBufferModel.getInstance());
        JScrollPane jScrollPane = new JScrollPane(jList, 22, 30);
        JLabel jLabel = new JLabel(IMAGEBUFFER, 2);
        jLabel.setDisplayedMnemonic(IMAGEBUFFER_MNEMONIC);
        jLabel.setLabelFor(jList);
        jLabel.setBorder(labelBorder);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.add(jPanel);
    }

    private void createBufferTree() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.bufferTree = new JTree(PrinterBufferModel.getInstance());
        this.bufferTree.setRootVisible(false);
        JScrollPane jScrollPane = new JScrollPane(this.bufferTree);
        JLabel jLabel = new JLabel(PRINTBUFFER, 2);
        jLabel.setLabelFor(this.bufferTree);
        jLabel.setDisplayedMnemonic(PRINTBUFFER_MNEMONIC);
        jLabel.setBorder(labelBorder);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.add(jPanel);
    }

    private void createStateTable() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTable jTable = new JTable(StateModel.getInstance());
        int n = 0;
        while (n < StateModel.getInstance().getColumnCount()) {
            jTable.getColumnModel().getColumn(n).setPreferredWidth(StateModel.getInstance().getColWidth(n));
            ++n;
        }
        JScrollPane jScrollPane = new JScrollPane(jTable);
        JLabel jLabel = new JLabel(STATEBUFFER, 2);
        jLabel.setLabelFor(jTable);
        jLabel.setDisplayedMnemonic(STATEBUFFER_MNEMONIC);
        jLabel.setBorder(labelBorder);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.add(jPanel);
    }

    public void resetOfflineButtons() {
        Enumeration enumeration = this.offlineComponents.elements();
        while (enumeration.hasMoreElements()) {
            ((JButton)enumeration.nextElement()).setEnabled(!StatusModel.isOnLine());
        }
    }

    public void validateSetups() {
        if (!(MediaModel.getCurrentMedia().isSupported() && ResolutionModel.getCurrentResolution().getEnabled() && FontModel.getFontFamily(FontModel.getDefaultFontFamilyName()).isSupported())) {
            PrinterPerf.getLog().appendMessage("New requirements made current setup invalid");
            if (PreferenceModel.getInstance().getBooleanProperty("always.validate.setup") && 0 == JOptionPane.showConfirmDialog(this.getFrame(), INVALID_SETUP, SETUP_REMINDER, 0)) {
                SetupDialog setupDialog = new SetupDialog(this.getFrame());
                setupDialog.setVisible(true);
                this.linefeedButton.setEnabled(MediaModel.getCurrentMedia().isContinuous());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

