/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import pios.emulator.printer.Units;
import pios.emulator.printer.models.MediaModel;
import pios.emulator.printer.models.PreferenceModel;

public class Rule
extends JComponent {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int SIZE = 35;
    public int orientation;
    private int unitSystem;
    private int increment;
    private int units;
    private static Color backgroudColor = PreferenceModel.getInstance().getColorProperty("color.ruler");

    public Rule(int n) {
        this.orientation = n;
        this.unitSystem = 0;
        this.setIncrementAndUnits();
    }

    public void rotateUnit() {
        ++this.unitSystem;
        if (this.unitSystem >= 3) {
            this.unitSystem = 0;
        }
        this.setIncrementAndUnits();
        this.repaint();
    }

    private double getZoom() {
        return PreferenceModel.getInstance().getOutputZoom();
    }

    private void setIncrementAndUnits() {
        switch (this.unitSystem) {
            case 2: {
                this.units = (int)Units.getScreenDPI();
                this.increment = this.units / 2;
                break;
            }
            case 1: {
                this.increment = this.units = (int)(Units.getScreenDPI() / 2.54);
                break;
            }
            default: {
                this.increment = this.units = (int)(Units.getScreenDPI() / 0.72);
            }
        }
        this.units = (int)((double)this.units * this.getZoom());
        this.increment = (int)((double)this.increment * this.getZoom());
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setPreferredHeight(int n) {
        this.setPreferredSize(new Dimension(35, n));
        this.setSize(this.getPreferredSize());
    }

    public void setPreferredWidth(int n) {
        this.setPreferredSize(new Dimension(n, 35));
        this.setSize(this.getPreferredSize());
    }

    private boolean isNeutrol() {
        return 0 == this.unitSystem;
    }

    protected void paintComponent(Graphics graphics) {
        int n;
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(backgroudColor);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.orientation == 0) {
            graphics.setColor(Color.black);
            n = (int)Math.ceil(Units.inchToPixel(MediaModel.getCurrentPrintHeadWidth()));
            graphics.fillRect(rectangle.x, rectangle.y + rectangle.height - 4, n, 4);
        }
        graphics.setFont(new Font("SansSerif", 0, 10));
        graphics.setColor(Color.black);
        n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = null;
        if (this.orientation == 0) {
            n2 = rectangle.x / this.increment * this.increment;
            n = ((rectangle.x + rectangle.width) / this.increment + 1) * this.increment;
        } else {
            n2 = rectangle.y / this.increment * this.increment;
            n = ((rectangle.y + rectangle.height) / this.increment + 1) * this.increment;
        }
        if (n2 == 0) {
            string = Integer.toString(0) + " " + Units.getUnitString(this.unitSystem);
            n3 = 10;
            if (this.orientation == 0) {
                graphics.drawLine(0, 34, 0, 35 - n3 - 1);
                graphics.drawString(string, 2, 21);
            } else {
                graphics.drawLine(34, 0, 35 - n3 - 1, 0);
                graphics.drawString(string, 1, 10);
            }
            string = null;
            n2 = this.increment;
        }
        int n4 = n2;
        while (n4 < n) {
            if (n4 % this.units == 0) {
                n3 = 10;
                string = Integer.toString(n4 * (this.isNeutrol() ? 100 : 1) / this.units);
            } else {
                n3 = 7;
                string = null;
            }
            if (n3 != 0) {
                if (this.orientation == 0) {
                    graphics.drawLine(n4, 34, n4, 35 - n3 - 1);
                    if (string != null) {
                        graphics.drawString(string, n4 - 3, 21);
                    }
                } else {
                    graphics.drawLine(34, n4, 35 - n3 - 1, n4);
                    if (string != null) {
                        int n5 = (5 - Math.min(5, string.length())) * 3;
                        graphics.drawString(string, n5, n4 - 1);
                    }
                }
            }
            n4 += this.increment;
        }
    }
}

