/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import pios.emulator.printer.DimensionEx;
import pios.emulator.printer.PointEx;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.TwoD;
import pios.emulator.printer.Units;
import pios.emulator.printer.output.Printout;
import pios.emulator.ui.PResourceBundle;

public final class RectPrintout
extends Printout {
    private static final String TOPLEFT;
    private static final String SIZE;
    private static final String RECTANGLE;
    private static final String LINETHICKNESS;
    private Rectangle2D rectShape;
    private PointEx topLeft;
    private DimensionEx size;
    private double lineWidth;
    private BasicStroke lineStroke;

    public RectPrintout(PointEx pointEx, DimensionEx dimensionEx) {
        this.topLeft = pointEx;
        this.size = dimensionEx;
        this.lineWidth = 1.0;
        this.setProperty(TOPLEFT, pointEx);
        this.setProperty(SIZE, dimensionEx);
    }

    public String getPrintoutTypeName() {
        return RECTANGLE;
    }

    public void setLineWidth(double d) {
        this.lineWidth = d;
        this.setProperty(LINETHICKNESS, Double.toString(d));
    }

    public TwoD getSizePixel() {
        Rectangle rectangle = this.rectShape.getBounds();
        TwoD twoD = new TwoD(rectangle);
        return twoD;
    }

    public double getMaxYPixel() {
        Rectangle rectangle = this.rectShape.getBounds();
        double d = rectangle.getMaxY();
        return d + Units.pointToPixel(this.lineWidth) / 2.0;
    }

    public double getMinYPixel() {
        Rectangle rectangle = this.rectShape.getBounds();
        double d = rectangle.getMinY();
        return d - Units.pointToPixel(this.lineWidth) / 2.0;
    }

    public void createLayout() {
        this.rectShape = new Rectangle2D.Double(this.topLeft.getPixelX(), this.topLeft.getPixelY(), this.size.getPixelWidth(), this.size.getPixelHeight());
        this.lineStroke = new BasicStroke((float)Units.pointToPixel(this.lineWidth));
    }

    public void render(Graphics2D graphics2D, AffineTransform affineTransform) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(this.lineStroke);
        AffineTransform affineTransform2 = graphics2D.getTransform();
        AffineTransform affineTransform3 = new AffineTransform(affineTransform);
        affineTransform3.concatenate(this.getTransform());
        graphics2D.transform(affineTransform3);
        graphics2D.draw(this.rectShape);
        graphics2D.setTransform(affineTransform2);
        graphics2D.setStroke(stroke);
    }

    static {
        PResourceBundle pResourceBundle = PrinterPerf.getResourceBundle();
        TOPLEFT = pResourceBundle.getString("RectPrintout_TopLeft");
        SIZE = pResourceBundle.getString("RectPrintout_Size");
        RECTANGLE = pResourceBundle.getString("RectPrintout_Rectangle");
        LINETHICKNESS = pResourceBundle.getString("RectPrintout_LineThickness");
    }
}

