/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.util.Properties;
import pios.emulator.printer.DimensionEx;
import pios.emulator.printer.PointEx;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.TwoD;
import pios.emulator.printer.Units;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.output.PrintCanvas;
import pios.emulator.printer.rmi.LineAlignment;

public abstract class Printout
implements LineAlignment {
    private static final String DEFAULT_STR = PrinterPerf.getResourceString("Printout_Default");
    private static final String LEFT_STR = PrinterPerf.getResourceString("Printout_Left");
    private static final String CENTER_STR = PrinterPerf.getResourceString("Printout_Center");
    private static final String RIGHT_STR = PrinterPerf.getResourceString("Printout_Right");
    private static final String ALIGNMENT = PrinterPerf.getResourceString("Printout_Alignment");
    private static final String ROTATE = PrinterPerf.getResourceString("Printout_Rotate");
    private static final String BASEPOINT = PrinterPerf.getResourceString("Printout_Basepoint");
    private static int count = 0;
    private PointEx basePoint = new PointEx(0.0, 0.0);
    private int rotation = 0;
    private int lineAlignment;
    private double lineSpace = 0.0;
    private static final String[] ALIGNMENTSTRINGS = new String[]{DEFAULT_STR, LEFT_STR, CENTER_STR, RIGHT_STR};
    private Properties properties = new Properties();
    private int index = count++;

    public Printout() {
        this.lineSpace = PrintCanvas.getInstance().getLineSpace();
    }

    public Properties getParameters() {
        return this.properties;
    }

    public int getIndex() {
        return this.index;
    }

    public void setLineAlignment(int n) {
        if (n == 0) {
            n = 1;
        }
        this.lineAlignment = n;
        this.setProperty(ALIGNMENT, ALIGNMENTSTRINGS[n]);
    }

    public float getLineAlignment() {
        return this.lineAlignment;
    }

    public double getLineSpace() {
        return this.lineSpace;
    }

    protected void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    protected void setProperty(String string, Point point) {
        PointEx pointEx = new PointEx(point);
        this.properties.setProperty(string, pointEx.getDisplayString());
    }

    protected void setProperty(String string, PointEx pointEx) {
        this.properties.setProperty(string, pointEx.getDisplayString());
    }

    protected void setProperty(String string, DimensionEx dimensionEx) {
        this.properties.setProperty(string, dimensionEx.getDisplayString());
    }

    public void setRotation(int n) {
        this.rotation = n;
        this.setProperty(ROTATE, Integer.toString(n));
    }

    public AffineTransform getTransform() {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(Math.toRadians(this.rotation));
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(this.basePoint.getPixelX(), this.basePoint.getPixelY());
        affineTransform2.concatenate(affineTransform);
        return affineTransform2;
    }

    public void setBasePoint(PointEx pointEx) {
        this.basePoint = pointEx;
        this.setProperty(BASEPOINT, pointEx);
    }

    public void setBasePoint(double d, double d2) {
        this.basePoint.setLocation(Units.pixelToPoint(d), Units.pixelToPoint(d2));
        this.setProperty(BASEPOINT, this.basePoint);
    }

    public PointEx getBasePoint() {
        return this.basePoint;
    }

    public boolean isVisible(Rectangle rectangle, int n) {
        double d = PreferenceModel.getInstance().getOutputZoom();
        boolean bl = true;
        double d2 = ((double)n + this.getMinYPixel()) * d;
        double d3 = ((double)n + this.getMaxYPixel()) * d;
        if (d3 < (double)rectangle.y || d2 > (double)(rectangle.y + rectangle.height)) {
            bl = false;
        }
        return bl;
    }

    public double getMaxYPixel() {
        double d = this.basePoint.getPixelY();
        switch (this.rotation) {
            case 0: {
                d = this.basePoint.getPixelY() + this.getSizePixel().height;
                break;
            }
            case 90: {
                d = this.basePoint.getPixelY() + this.getSizePixel().width;
                break;
            }
            case 180: 
            case 270: {
                d = this.basePoint.getPixelY();
            }
        }
        return d;
    }

    public double getMinYPixel() {
        double d = this.basePoint.getPixelY();
        switch (this.rotation) {
            case 0: {
                d = this.basePoint.getPixelY();
                break;
            }
            case 90: {
                d = this.basePoint.getPixelY();
                break;
            }
            case 180: {
                d = this.basePoint.getPixelY() - this.getSizePixel().height;
                break;
            }
            case 270: {
                d = this.basePoint.getPixelY() - this.getSizePixel().width;
            }
        }
        return d;
    }

    public TwoD getSizePoint() {
        TwoD twoD = this.getSizePixel();
        TwoD twoD2 = new TwoD(Units.pixelToPoint(twoD.width), Units.pixelToPoint(twoD.height));
        return twoD2;
    }

    public static double getTextLayoutHeight(TextLayout textLayout) {
        double d = textLayout.getAscent() + textLayout.getDescent();
        return d;
    }

    public static double getTextLayoutWidth(TextLayout textLayout) {
        return textLayout.getAdvance();
    }

    public abstract String getPrintoutTypeName();

    public abstract TwoD getSizePixel();

    public abstract void createLayout();

    public abstract void render(Graphics2D var1, AffineTransform var2);
}

