/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import pios.emulator.printer.PointEx;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.Units;
import pios.emulator.printer.models.EmulatedMedia;
import pios.emulator.printer.models.MediaModel;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.models.PrintBuffer;
import pios.emulator.printer.models.PrinterBufferModel;
import pios.emulator.printer.models.StateModel;
import pios.emulator.printer.models.StatusModel;
import pios.emulator.printer.output.myMouseListener;
import pios.emulator.printer.output.myMouseMotionListener;

public class PrintCanvas
extends JPanel
implements Scrollable {
    private static final String PRINTERHEAD = PrinterPerf.getResourceString("PrintCanvas_PrintHead");
    private static final String LINESPACE = PrinterPerf.getResourceString("PrintCanvas_LineSpace");
    private static PrintCanvas instance = null;
    private Point anchor = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
    private Point motion = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
    private PointEx distance = new PointEx(0.0, 0.0);
    private Dimension paperSize;
    private double lineSpace;
    private PointEx printerHeadPosition = new PointEx(0.0, 0.0);
    private Rectangle printerHead = new Rectangle();
    private ImageIcon printerHeadIcon = PrinterPerf.getImageIcon("printer.linefeed.gif");
    private final int headIconOffsetY = this.printerHeadIcon.getIconHeight() / 2;
    private double endOfPaper = 0.0;
    private static final int LINE_INCREMENT = 10;
    private static final int BLOCK_INCREMENT = 30;

    public static PrintCanvas getInstance() {
        if (null == instance) {
            instance = new PrintCanvas();
        }
        return instance;
    }

    public void resetSize() {
        EmulatedMedia emulatedMedia = MediaModel.getCurrentMedia();
        double d = emulatedMedia.getWidth().getPixel();
        double d2 = emulatedMedia.getHeight().getPixel() * (double)MediaModel.getPageCount();
        this.endOfPaper = Units.inchToPoint(emulatedMedia.getHeight().get() * (double)MediaModel.getPageCount());
        this.paperSize = new Dimension();
        double d3 = PreferenceModel.getInstance().getOutputZoom();
        this.paperSize.setSize((int)Math.ceil(d * d3 + 1.0), (int)Math.ceil(d2 * d3 + 1.0));
        this.setPreferredSize(this.paperSize);
        this.setSize(this.paperSize);
    }

    private PrintCanvas() {
        this.resetSize();
        this.setBackground(PreferenceModel.getInstance().getColorProperty("color.canvas"));
        this.lineSpace = 0.0;
        this.setPrinterHeadPosition(0.0, 0.0);
        this.addMouseListener(new myMouseListener(this, this.anchor, this.motion, this.distance));
        this.addMouseMotionListener(new myMouseMotionListener(this, this.anchor, this.motion, this.distance));
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.render(graphics2D);
    }

    public PointEx getPrinterHeadPosition() {
        return this.printerHeadPosition;
    }

    public void resetHeadPosition() {
        this.setPrinterHeadPosition(0.0, 0.0);
    }

    public void realignPrinterHead() {
        if (MediaModel.getCurrentMedia().isContinuous()) {
            return;
        }
        double d = this.printerHeadPosition.getPixelY();
        double d2 = MediaModel.getCurrentMedia().getHeight().getPixel();
        int n = (int)Math.ceil(d / d2);
        double d3 = Units.pixelToPoint((double)n * d2);
        this.setPrinterHeadPosition(0.0, d3);
    }

    public void setPrinterHeadPosition(double d, double d2) {
        this.printerHeadPosition.setLocation(d, d2);
        if (d2 > this.endOfPaper) {
            StatusModel.outOfPaper();
        } else {
            this.scrollToShowPrinterHead();
        }
        this.updateState();
    }

    public void scrollToShowPrinterHead() {
        if (PreferenceModel.getInstance().getBooleanProperty("printhead.visible")) {
            this.printerHead.setBounds((int)Math.ceil(this.printerHeadPosition.getPixelX()), (int)Math.ceil(this.printerHeadPosition.getPixelY() - (double)(this.headIconOffsetY * 4)), this.headIconOffsetY, this.headIconOffsetY * 8);
            this.scrollRectToVisible(this.printerHead);
        }
    }

    public void advance(double d) {
        double d2 = this.printerHeadPosition.getX();
        double d3 = this.printerHeadPosition.getY();
        this.setPrinterHeadPosition(d2, d3 += d);
        this.repaint();
    }

    private void updateState() {
        StateModel.getInstance().set(PRINTERHEAD, this.printerHeadPosition.getDisplayString());
        StateModel.getInstance().set(LINESPACE, Double.toString(this.lineSpace));
    }

    public void setLineSpace(double d) {
        this.lineSpace = d;
        this.updateState();
    }

    public double getLineSpace() {
        return this.lineSpace;
    }

    public Dimension getPaperSize() {
        return this.paperSize;
    }

    public void render(Graphics2D graphics2D) {
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        double d = PreferenceModel.getInstance().getOutputZoom();
        affineTransform2.scale(d, d);
        graphics2D.transform(affineTransform2);
        this.renderBuffers(graphics2D);
        this.renderPrinterHead(graphics2D);
        this.renderMedia(graphics2D);
        graphics2D.setTransform(affineTransform);
    }

    private void renderBuffers(Graphics2D graphics2D) {
        Enumeration enumeration = PrinterBufferModel.getInstance().getPrintBuffers();
        while (enumeration.hasMoreElements()) {
            PrintBuffer printBuffer = (PrintBuffer)enumeration.nextElement();
            printBuffer.render(graphics2D);
        }
    }

    private void renderMedia(Graphics2D graphics2D) {
        EmulatedMedia emulatedMedia = MediaModel.getCurrentMedia();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(0.0, emulatedMedia.getHeight().getPixel());
        while (graphics2D.getTransform().getTranslateY() <= (double)this.paperSize.height) {
            emulatedMedia.render(graphics2D);
            graphics2D.transform(affineTransform);
        }
    }

    private void renderPrinterHead(Graphics2D graphics2D) {
        int n = (int)Math.ceil(this.printerHeadPosition.getPixelX());
        int n2 = (int)Math.ceil(this.printerHeadPosition.getPixelY());
        graphics2D.drawImage(this.printerHeadIcon.getImage(), n, n2 - this.headIconOffsetY, this);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 30;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }
}

