/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.output.Corner;
import pios.emulator.printer.output.PrintCanvas;
import pios.emulator.printer.output.Rule;
import pios.emulator.printer.setups.ButtonEx;
import pios.emulator.ui.PResourceBundle;

public class OutputView
extends JPanel
implements ActionListener {
    private static final String UNIT;
    private static final char UNIT_MNEMONIC;
    private static OutputView instance;
    private Rule columnView;
    private Rule rowView;
    private JButton unitButton;
    private JPanel buttonCorner;
    private PrintCanvas printCanvas;
    private JScrollPane scroller;

    public static OutputView getInstance() {
        if (null == instance) {
            instance = new OutputView();
        }
        return instance;
    }

    private OutputView() {
        super(new BorderLayout());
        Dimension dimension = new Dimension();
        dimension.width = PreferenceModel.getInstance().getIntProperty("view.output.width");
        this.setMinimumSize(dimension);
        this.printCanvas = PrintCanvas.getInstance();
        this.scroller = new JScrollPane(this.printCanvas);
        this.columnView = new Rule(0);
        this.rowView = new Rule(1);
        this.resetSize();
        this.scroller.setColumnHeaderView(this.columnView);
        this.scroller.setRowHeaderView(this.rowView);
        this.buttonCorner = new JPanel();
        this.unitButton = new ButtonEx(UNIT);
        this.unitButton.setMnemonic(UNIT_MNEMONIC);
        this.unitButton.setMargin(new Insets(1, 1, 1, 1));
        this.unitButton.addActionListener(this);
        this.buttonCorner.add(this.unitButton);
        this.scroller.setCorner("UPPER_LEFT_CORNER", this.buttonCorner);
        this.scroller.setCorner("LOWER_LEFT_CORNER", new Corner());
        this.scroller.setCorner("UPPER_RIGHT_CORNER", new Corner());
        this.add((Component)this.scroller, "Center");
    }

    public void resetSize() {
        this.columnView.setPreferredWidth(this.printCanvas.getPaperSize().width);
        this.rowView.setPreferredHeight(this.printCanvas.getPaperSize().height);
        this.scroller.updateUI();
    }

    public JButton getUnitButton() {
        return this.unitButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.rowView.rotateUnit();
        this.columnView.rotateUnit();
    }

    static {
        PResourceBundle pResourceBundle = PrinterPerf.getResourceBundle();
        UNIT = pResourceBundle.getString("OutputView_Unit");
        UNIT_MNEMONIC = pResourceBundle.getString("OutputView_Unit.MNEMONIC").charAt(0);
        instance = null;
    }
}

