/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output;

import pios.emulator.printer.Inch;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.ui.PResourceBundle;

public class Margin {
    private static final String TIP;
    private Inch top;
    private Inch left;
    private Inch bottom;
    private Inch right;

    public Margin() {
        this.top = new Inch(0.0);
        this.left = new Inch(0.0);
        this.right = new Inch(0.0);
        this.bottom = new Inch(0.0);
    }

    public Margin(Inch inch, Inch inch2, Inch inch3, Inch inch4) {
        this.top = inch;
        this.left = inch2;
        this.bottom = inch3;
        this.right = inch4;
    }

    public double getTop() {
        return this.top.getPixel();
    }

    public double getLeft() {
        return this.left.getPixel();
    }

    public double getBottom() {
        return this.bottom.getPixel();
    }

    public double getRight() {
        return this.right.getPixel();
    }

    public double getTotalH() {
        return this.left.getPixel() + this.right.getPixel();
    }

    public double getTotalV() {
        return this.top.getPixel() + this.bottom.getPixel();
    }

    public String toString() {
        String string = "";
        if (0.0 != this.top.get() || 0.0 != this.left.get() || 0.0 != this.right.get() || 0.0 != this.bottom.get()) {
            string = this.top.get() + "," + this.left.get() + "," + this.bottom.get() + "," + this.right.get();
        }
        return string;
    }

    public static String getTip() {
        return TIP;
    }

    static {
        PResourceBundle pResourceBundle = PrinterPerf.getResourceBundle();
        TIP = pResourceBundle.getString("Margin_Tip");
    }
}

