/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import pios.emulator.printer.PointEx;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.TwoD;
import pios.emulator.printer.Units;
import pios.emulator.printer.output.Printout;
import pios.emulator.ui.PResourceBundle;

public final class LinePrintout
extends Printout {
    private static final String POINT1;
    private static final String POINT2;
    private static final String LINE;
    private static final String THICKNESS;
    private Line2D lineShape;
    private PointEx P0;
    private PointEx P1;
    private double lineWidth = 1.0;
    private BasicStroke lineStroke;

    public LinePrintout(PointEx pointEx, PointEx pointEx2) {
        this.P0 = pointEx;
        this.P1 = pointEx2;
        this.setProperty(POINT1, pointEx);
        this.setProperty(POINT2, pointEx2);
    }

    public String getPrintoutTypeName() {
        return LINE;
    }

    public void setLineWidth(double d) {
        this.lineWidth = d;
        this.setProperty(THICKNESS, Double.toString(d));
    }

    public TwoD getSizePixel() {
        Rectangle rectangle = this.lineShape.getBounds();
        TwoD twoD = new TwoD(rectangle);
        return twoD;
    }

    public double getMaxYPixel() {
        Rectangle rectangle = this.lineShape.getBounds();
        double d = rectangle.getMaxY();
        return d + Units.pointToPixel(this.lineWidth) / 2.0;
    }

    public double getMinYPixel() {
        Rectangle rectangle = this.lineShape.getBounds();
        double d = rectangle.getMinY();
        return d - Units.pointToPixel(this.lineWidth) / 2.0;
    }

    public void createLayout() {
        this.lineShape = new Line2D.Double(this.P0.getPixelX(), this.P0.getPixelY(), this.P1.getPixelX(), this.P1.getPixelY());
        this.lineStroke = new BasicStroke((float)Units.pointToPixel(this.lineWidth));
    }

    public void render(Graphics2D graphics2D, AffineTransform affineTransform) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(this.lineStroke);
        AffineTransform affineTransform2 = graphics2D.getTransform();
        AffineTransform affineTransform3 = new AffineTransform(affineTransform);
        affineTransform3.concatenate(this.getTransform());
        graphics2D.transform(affineTransform3);
        graphics2D.draw(this.lineShape);
        graphics2D.setTransform(affineTransform2);
        graphics2D.setStroke(stroke);
    }

    static {
        PResourceBundle pResourceBundle = PrinterPerf.getResourceBundle();
        POINT1 = pResourceBundle.getString("LinePrintout_Point1");
        POINT2 = pResourceBundle.getString("LinePrintout_Point2");
        LINE = pResourceBundle.getString("LinePrintout_Line");
        THICKNESS = pResourceBundle.getString("LinePrintout_Thickness");
    }
}

