/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.output;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.TwoD;
import pios.emulator.printer.models.EmulatedImage;
import pios.emulator.printer.output.Printout;
import pios.emulator.ui.PResourceBundle;

public final class ImagePrintout
extends Printout {
    private static final String DIMENSION;
    private static final String IMAGENAME;
    private static final String IMAGE;
    private Image imageRef;
    private final EmulatedImage image;
    private ImageObserver displayPanel;

    public ImagePrintout(EmulatedImage emulatedImage) {
        this.image = emulatedImage;
        this.displayPanel = null;
        this.setProperty(DIMENSION, emulatedImage.getDimension());
        this.setProperty(IMAGENAME, emulatedImage.getName());
    }

    public String getPrintoutTypeName() {
        return IMAGE;
    }

    public void setObserver(ImageObserver imageObserver) {
        this.displayPanel = imageObserver;
    }

    public TwoD getSizePixel() {
        TwoD twoD = new TwoD(this.image.getDimension().getPixelWidth(), this.image.getDimension().getPixelHeight());
        return twoD;
    }

    public void createLayout() {
        this.imageRef = this.image.getImage();
    }

    public void render(Graphics2D graphics2D, AffineTransform affineTransform) {
        AffineTransform affineTransform2 = graphics2D.getTransform();
        AffineTransform affineTransform3 = new AffineTransform(affineTransform);
        affineTransform3.concatenate(this.getTransform());
        graphics2D.transform(affineTransform3);
        graphics2D.drawImage(this.imageRef, 0, 0, this.displayPanel);
        graphics2D.setTransform(affineTransform2);
    }

    static {
        PResourceBundle pResourceBundle = PrinterPerf.getResourceBundle();
        DIMENSION = pResourceBundle.getString("ImagePrintout_Dimension");
        IMAGENAME = pResourceBundle.getString("ImagePrintout_ImageName");
        IMAGE = pResourceBundle.getString("ImagePrintout_Image");
    }
}

