/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.models;

import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.StateModel;
import pios.emulator.ui.PResourceBundle;

public final class StatusModel {
    private static final String STATUS;
    private static final String CONNECTION;
    private static final String STR_ONLINE;
    private static final String STR_OFFLINE;
    private static final String STR_UNKNOWN;
    private static final String STR_DATAERROR;
    private static final String STR_OUTOFPAPER;
    private static final String STR_OPENED;
    private static final String STR_CLOSED;
    private static final int OFFLINE = 0;
    private static final int OUTOFPAPER = 1;
    private static final int DATAERROR = 2;
    private static final int UNKNOWN = 3;
    private static final int ONLINE = 4;
    private static final int OPENED = 5;
    private static final int CLOSED = 6;
    private static final String[] statusStrings;
    private static int localStatus;
    private static int serverStatus;

    public static void reset() {
        StatusModel.setLocalStatus(4);
        StatusModel.setServerStatus(6);
        StatusModel.updateState();
    }

    public static boolean isOnLine() {
        return 4 == localStatus;
    }

    public static boolean isConnectionClosed() {
        return 6 == serverStatus;
    }

    public static boolean isConnectionOpened() {
        return !StatusModel.isConnectionClosed();
    }

    public static void open() {
        StatusModel.setServerStatus(5);
    }

    public static void close() {
        StatusModel.setServerStatus(6);
    }

    public static void offLine() {
        StatusModel.setLocalStatus(0);
    }

    public static void outOfPaper() {
        StatusModel.setLocalStatus(1);
    }

    public static void onLine() {
        if (0 == localStatus) {
            StatusModel.setLocalStatus(4);
        }
    }

    public static void clearError() {
        if (localStatus < 4 && 0 != localStatus) {
            StatusModel.setLocalStatus(4);
        }
    }

    public static int getStatus() {
        return localStatus;
    }

    private static void setLocalStatus(int n) {
        localStatus = n;
        StatusModel.updateState();
    }

    private static void setServerStatus(int n) {
        serverStatus = n;
        StatusModel.updateState();
    }

    private static void updateState() {
        StateModel.getInstance().set(STATUS, statusStrings[localStatus]);
        StateModel.getInstance().set(CONNECTION, statusStrings[serverStatus]);
    }

    static {
        PResourceBundle pResourceBundle = PrinterPerf.getResourceBundle();
        STATUS = pResourceBundle.getString("StatusModel_Status");
        CONNECTION = pResourceBundle.getString("StatusModel_Connection");
        STR_ONLINE = pResourceBundle.getString("StatusModel_Online");
        STR_OFFLINE = pResourceBundle.getString("StatusModel_Offline");
        STR_UNKNOWN = pResourceBundle.getString("StatusModel_Unknown");
        STR_DATAERROR = pResourceBundle.getString("StatusModel_DataError");
        STR_OUTOFPAPER = pResourceBundle.getString("StatusModel_OutOfPaper");
        STR_OPENED = pResourceBundle.getString("StatusModel_Opened");
        STR_CLOSED = pResourceBundle.getString("StatusModel_Closed");
        statusStrings = new String[]{STR_OFFLINE, STR_OUTOFPAPER, STR_DATAERROR, STR_UNKNOWN, STR_ONLINE, STR_OPENED, STR_CLOSED};
        StatusModel.reset();
    }
}

