/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.models;

import java.util.Properties;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.ui.PResourceBundle;

public final class StateModel
extends AbstractTableModel {
    private static final String PROPERTY;
    private static final String VALUE;
    private static final String UNEXPECTED;
    private final int COL_NAME = 0;
    private final int COL_VALUE = 1;
    private final String[] Headers = new String[]{PROPERTY, VALUE};
    private final int[] columnWidths = new int[]{100, 100};
    private Properties states = new Properties();
    private Vector indexes = new Vector();
    private static StateModel instance;

    private StateModel() {
    }

    public static StateModel getInstance() {
        if (null == instance) {
            instance = new StateModel();
        }
        return instance;
    }

    public void set(String string, String string2) {
        if (this.states.containsKey(string)) {
            this.states.setProperty(string, string2);
        } else {
            this.states.put(string, string2);
            this.indexes.add(string);
        }
        this.fireTableDataChanged();
    }

    public int getColWidth(int n) {
        return this.columnWidths[n];
    }

    public int getRowCount() {
        return this.states.size();
    }

    public int getColumnCount() {
        return this.Headers.length;
    }

    public String getColumnName(int n) {
        return this.Headers[n];
    }

    public Object getValueAt(int n, int n2) {
        String string = (String)this.indexes.get(n);
        switch (n2) {
            case 0: {
                return string;
            }
            case 1: {
                return this.states.getProperty(string);
            }
        }
        return UNEXPECTED;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    static {
        PResourceBundle pResourceBundle = PrinterPerf.getResourceBundle();
        PROPERTY = pResourceBundle.getString("StateModel_Property");
        VALUE = pResourceBundle.getString("StateModel_Value");
        UNEXPECTED = pResourceBundle.getString("StateModel_Unexpected");
        instance = null;
    }
}

