/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.models;

import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import pios.emulator.printer.PrinterEngine;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.models.PrinterAttributesModel;
import pios.emulator.printer.models.PrinterRequirementModel;
import pios.emulator.printer.models.StateModel;

public class ResolutionModel {
    private static final String RESOLUTION = PrinterPerf.getResourceString("ResolutionModel_Resolution");
    private static String title;
    private static Vector resolutionList;
    private static DeviceCapability currentResolution;
    private static final String PROPERTY_FILENAME = "SupportedResolution";
    private static final String KEY_SUPPORTED = "SupportedResolution";
    private static final String KEY_CURRENT = "CurrentResolution";
    private static final String DELIMETER = ",";
    private static final String DPI = "DPI";

    private static Properties createDefaults() {
        Properties properties = new Properties();
        properties.put("SupportedResolution", "200,300,400,600");
        properties.put("200", "1");
        properties.put("300", "1");
        properties.put("400", "1");
        properties.put("600", "1");
        properties.put(KEY_CURRENT, "300");
        PrinterEngine.storeProperties(false, "SupportedResolution", properties);
        return properties;
    }

    private static String getDPIDisplayString(String string) {
        String string2 = PrinterPerf.getResourceString("ResolutionModel_DPI_" + string);
        if (null == string2 || 0 == string2.length()) {
            string2 = string + " " + DPI;
        }
        return string2;
    }

    public static void store() {
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = resolutionList.elements();
        while (enumeration.hasMoreElements()) {
            DeviceCapability deviceCapability = (DeviceCapability)enumeration.nextElement();
            properties.put(deviceCapability.getIdentification(), deviceCapability.getPropertyValue());
            stringBuffer.append(deviceCapability.getIdentification());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(DELIMETER);
        }
        properties.put("SupportedResolution", stringBuffer.toString());
        properties.put(KEY_CURRENT, Integer.toString(ResolutionModel.getCurrentResolutionValue()));
        PrinterEngine.storeProperties(true, "SupportedResolution", properties);
        ResolutionModel.resetAttribute();
    }

    private static void loadResolutionList() {
        Properties properties = PrinterEngine.loadProperties("SupportedResolution");
        if (null == properties) {
            properties = ResolutionModel.createDefaults();
        }
        String string = properties.getProperty(KEY_CURRENT);
        String string2 = properties.getProperty("SupportedResolution");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, DELIMETER);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            DeviceCapability deviceCapability = new DeviceCapability(string3, ResolutionModel.getDPIDisplayString(string3));
            deviceCapability.setEnabled(properties.getProperty(string3));
            resolutionList.add(n, deviceCapability);
            if (string.equalsIgnoreCase(string3)) {
                currentResolution = deviceCapability;
            }
            ++n;
        }
        ResolutionModel.updateState();
    }

    public static int getCurrentResolutionValue() {
        return Integer.parseInt(currentResolution.getIdentification());
    }

    public static DeviceCapability getCurrentResolution() {
        return currentResolution;
    }

    public static void setCurrentResolution(DeviceCapability deviceCapability) {
        currentResolution = deviceCapability;
        ResolutionModel.updateState();
    }

    public static String getTitle() {
        return title;
    }

    public static void updateState() {
        StateModel.getInstance().set(title, currentResolution.getDisplayName());
    }

    public static Vector getList() {
        return (Vector)resolutionList.clone();
    }

    public static Vector getActiveList() {
        Vector<DeviceCapability> vector = new Vector<DeviceCapability>();
        Enumeration enumeration = resolutionList.elements();
        while (enumeration.hasMoreElements()) {
            DeviceCapability deviceCapability = (DeviceCapability)enumeration.nextElement();
            if (!deviceCapability.getEnabled()) continue;
            vector.add(deviceCapability);
        }
        return vector;
    }

    private static boolean isDPIRequirementValid(PrinterRequirementModel printerRequirementModel) {
        if (!printerRequirementModel.isRequirementSelected("PRINTER_DPI")) {
            return false;
        }
        int n = 0;
        while (n < resolutionList.size()) {
            DeviceCapability deviceCapability = (DeviceCapability)resolutionList.get(n);
            String string = "DPI_" + deviceCapability.getIdentification();
            if (printerRequirementModel.isRequirementSelected(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static void setAllByRequirement(PrinterRequirementModel printerRequirementModel) {
        int n = 0;
        while (n < resolutionList.size()) {
            DeviceCapability deviceCapability = (DeviceCapability)resolutionList.get(n);
            String string = "DPI_" + deviceCapability.getIdentification();
            deviceCapability.setEnabled(printerRequirementModel.isRequirementSelected(string));
            ++n;
        }
    }

    private static void autoSelectResolution(PrinterRequirementModel printerRequirementModel) {
        if (!PreferenceModel.getInstance().getBooleanProperty("auto.select.resolution")) {
            return;
        }
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        while (n2 < resolutionList.size()) {
            DeviceCapability deviceCapability = (DeviceCapability)resolutionList.get(n2);
            int n3 = Integer.parseInt(deviceCapability.getIdentification());
            String string = "DPI_" + n3;
            if (printerRequirementModel.isRequirementSelected(string) && n > n3) {
                currentResolution = deviceCapability;
                n = n3;
            }
            ++n2;
        }
    }

    public static void resetByRequirement() {
        PrinterRequirementModel printerRequirementModel = PrinterRequirementModel.getInstance();
        if (!ResolutionModel.isDPIRequirementValid(printerRequirementModel)) {
            return;
        }
        ResolutionModel.setAllByRequirement(printerRequirementModel);
        if (!currentResolution.getEnabled()) {
            ResolutionModel.autoSelectResolution(printerRequirementModel);
        }
        ResolutionModel.updateState();
    }

    public static void resetAttribute() {
        String string = "DPI_";
        string = string + Integer.toString(ResolutionModel.getCurrentResolutionValue());
        PrinterAttributesModel.getInstance().setAttribute(string, true);
    }

    static {
        resolutionList = new Vector();
        currentResolution = null;
        title = RESOLUTION;
        ResolutionModel.loadResolutionList();
    }
}

