/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.models;

import java.util.Enumeration;
import java.util.Properties;
import pios.emulator.printer.models.BarcodeCapabilityModel;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.models.FontModel;
import pios.emulator.printer.models.GeneralCapabilityModel;
import pios.emulator.printer.models.MediaModel;
import pios.emulator.printer.models.PrinterRequirement;
import pios.emulator.printer.models.ResolutionModel;
import pios.emulator.printer.output.StateView;

public class PrinterRequirementModel
implements PrinterRequirement {
    private Properties requirements = null;
    private static PrinterRequirementModel instance = null;

    public boolean isRequirementSelected(String string) {
        String string2 = (String)this.requirements.get(string);
        if (null == string2) {
            return false;
        }
        return string2.equalsIgnoreCase("1") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("enabled") || string2.equalsIgnoreCase("true");
    }

    public void applyRequirements(Properties properties) {
        this.requirements = properties;
        this.validateRequirements();
        GeneralCapabilityModel.getInstance().resetByRequirement();
        BarcodeCapabilityModel.getInstance().resetByRequirement();
        ResolutionModel.resetByRequirement();
        FontModel.resetByRequirement();
        MediaModel.resetByRequirement();
        GeneralCapabilityModel.getInstance().store();
        BarcodeCapabilityModel.getInstance().store();
        ResolutionModel.store();
        FontModel.store();
        MediaModel.store();
        StateView.getInstance().validateSetups();
    }

    public Enumeration getRequirementKeys() {
        return this.requirements.keys();
    }

    public static PrinterRequirementModel getInstance() {
        if (instance == null) {
            instance = new PrinterRequirementModel();
        }
        return instance;
    }

    private void validateRequirements() {
        if (this.isRequirementSelected("IMAGE_PRINT") && !this.isRequirementSelected("IMAGE_PCX") && !this.isRequirementSelected("IMAGE_BMP")) {
            this.requirements.setProperty("IMAGE_PCX", String.valueOf(DeviceCapability.formatPCX.getEnabled()));
            this.requirements.setProperty("IMAGE_BMP", String.valueOf(DeviceCapability.formatBMP.getEnabled()));
        }
        if (!this.isRequirementSelected("FONT_BITMAPPED") && !this.isRequirementSelected("FONT_SCALABLE")) {
            this.requirements.setProperty("FONT_BITMAPPED", String.valueOf(FontModel.bitmappedFont.getEnabled()));
            this.requirements.setProperty("FONT_SCALABLE", String.valueOf(FontModel.scalableFont.getEnabled()));
        }
    }
}

