/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.models;

import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.StateModel;

public final class PrinterModeModel {
    private static final String MODE = PrinterPerf.getResourceString("PrinterModeModel_Mode");
    private static final String MODE_LINE = PrinterPerf.getResourceString("PrinterModeModel_Line");
    private static final String MODE_XY = PrinterPerf.getResourceString("PrinterModeModel_Graphic");
    private static final String title = MODE;
    private static String currentModeName = MODE_XY;

    public static void reset() {
        currentModeName = MODE_XY;
        PrinterModeModel.updateState();
    }

    public static String getCurrentModeName() {
        return currentModeName;
    }

    public static boolean isLineMode() {
        return MODE_LINE == currentModeName;
    }

    public static boolean isXYMode() {
        return MODE_XY == currentModeName;
    }

    public static void setLineMode() {
        currentModeName = MODE_LINE;
        PrinterModeModel.updateState();
    }

    public static void setXYMode() {
        currentModeName = MODE_XY;
        PrinterModeModel.updateState();
    }

    public static String getTitle() {
        return title;
    }

    private static void updateState() {
        StateModel.getInstance().set(title, currentModeName);
    }
}

