/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.models;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import pios.emulator.printer.PointEx;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.PrintBuffer;
import pios.emulator.printer.output.PrintCanvas;
import pios.emulator.printer.output.Printout;

public final class PrinterBufferModel
extends DefaultTreeModel {
    private static final String PRINTERBUFFER = PrinterPerf.getResourceString("PrinterBufferModel_PrinterBuffer");
    private static final String ACTIVEBUFFER = PrinterPerf.getResourceString("PrinterBufferModel_ActiveBuffer");
    private static final String COPIES = PrinterPerf.getResourceString("PrinterBufferModel_Copies");
    private static final String ORIGIN = PrinterPerf.getResourceString("PrinterBufferModel_Origin");
    private static final String HISTORY = PrinterPerf.getResourceString("PrinterBufferModel_History");
    private static PrinterBufferModel instance;
    private Vector bufferList = new Vector();
    private PrintBuffer activeBuffer;
    private static DefaultMutableTreeNode top;
    private static DefaultMutableTreeNode activeBufferNode;

    private PrinterBufferModel() {
        super(top);
        this.createPrintBuffer();
    }

    private void createPrintBuffer() {
        this.activeBuffer = new PrintBuffer();
        this.bufferList.add(this.activeBuffer);
        activeBufferNode = new DefaultMutableTreeNode(ACTIVEBUFFER);
        this.insertNodeInto(activeBufferNode, top, top.getChildCount());
    }

    public static PrinterBufferModel getInstance() {
        if (null == instance) {
            instance = new PrinterBufferModel();
        }
        return instance;
    }

    public void doPrint(int n) {
        PrintCanvas.getInstance().realignPrinterHead();
        if (this.activeBuffer.doPrint(n)) {
            this.updateActiveBufferTree();
            this.createPrintBuffer();
        }
    }

    public void reset() {
        this.bufferList.clear();
        top.removeAllChildren();
        this.createPrintBuffer();
        this.nodeStructureChanged(top);
    }

    public Enumeration getPrintBuffers() {
        return this.bufferList.elements();
    }

    public void clearActiveBuffer() {
        this.activeBuffer.reset();
        activeBufferNode.removeAllChildren();
        this.nodeStructureChanged(activeBufferNode);
    }

    public void addPrintout(Printout printout) {
        this.activeBuffer.addPrintout(printout);
        this.addPrintoutToTree(printout);
    }

    public void addPrintout(Printout printout, PointEx pointEx) {
        printout.setBasePoint(pointEx);
        this.activeBuffer.addPrintout(printout);
        this.addPrintoutToTree(printout);
    }

    public void addPrintout(Printout printout, int n) {
        printout.setLineAlignment(n);
        this.activeBuffer.addPrintout(printout);
        this.addPrintoutToTree(printout);
    }

    private void addPrintoutToTree(Printout printout) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(printout.getIndex() + ":" + printout.getPrintoutTypeName());
        this.insertNodeInto(defaultMutableTreeNode, activeBufferNode, activeBufferNode.getChildCount());
        Properties properties = printout.getParameters();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = properties.getProperty(string);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string + "=" + string2);
            this.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        }
        this.nodeStructureChanged(activeBufferNode);
    }

    private void updateActiveBufferTree() {
        String string = Integer.toString(this.activeBuffer.getCopies());
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(COPIES + "(" + string + ")");
        this.insertNodeInto(defaultMutableTreeNode, activeBufferNode, 0);
        String string2 = this.activeBuffer.getOrigin().getDisplayString();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(ORIGIN + string2);
        this.insertNodeInto(defaultMutableTreeNode2, activeBufferNode, 0);
        activeBufferNode.setUserObject(HISTORY + this.activeBuffer.getIndex());
    }

    static {
        top = new DefaultMutableTreeNode(PRINTERBUFFER);
    }
}

