/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.models;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Enumeration;
import java.util.Vector;
import pios.emulator.printer.PointEx;
import pios.emulator.printer.TwoD;
import pios.emulator.printer.Units;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.models.MediaModel;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.models.PrinterModeModel;
import pios.emulator.printer.output.PrintCanvas;
import pios.emulator.printer.output.Printout;

public final class PrintBuffer {
    private static int count = 0;
    private int index;
    private PointEx origin;
    private boolean createdOutputLayout = false;
    private int copies = 0;
    private double oneCopyHeightPixel;
    private Vector printoutList = new Vector();

    public PrintBuffer() {
        this.index = count++;
    }

    public int getIndex() {
        return this.index;
    }

    public void addPrintout(Printout printout) {
        this.printoutList.addElement(printout);
        printout.createLayout();
    }

    public void reset() {
        this.printoutList.removeAllElements();
    }

    public boolean doPrint(int n) {
        if (this.copies > 0 || this.printoutList.isEmpty()) {
            return false;
        }
        this.copies = n;
        this.origin = new PointEx(PrintCanvas.getInstance().getPrinterHeadPosition());
        this.createOutputLayout();
        PrintCanvas.getInstance().repaint();
        return true;
    }

    private void createOutputLayout() {
        this.oneCopyHeightPixel = 0.0;
        if (PrinterModeModel.isLineMode()) {
            double d = PrintCanvas.getInstance().getPaperSize().width;
            if (!DeviceCapability.pageMetrics.getEnabled()) {
                d = Units.inchToPixel(MediaModel.getCurrentPrintHeadWidth());
            }
            this.oneCopyHeightPixel = this.createLineLayout(d);
        } else {
            this.oneCopyHeightPixel = this.createGraphicLayout();
        }
        if (!MediaModel.getCurrentMedia().isContinuous()) {
            this.oneCopyHeightPixel = MediaModel.getCurrentMedia().getHeight().getPixel();
        }
        PrintCanvas.getInstance().advance(Units.pixelToPoint(this.oneCopyHeightPixel * (double)this.copies));
        this.createdOutputLayout = true;
    }

    private double createGraphicLayout() {
        Enumeration enumeration = this.printoutList.elements();
        double d = 0.0;
        while (enumeration.hasMoreElements()) {
            Printout printout = (Printout)enumeration.nextElement();
            printout.createLayout();
            double d2 = printout.getMaxYPixel();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    private double createLineLayout(double d) {
        Enumeration enumeration = this.printoutList.elements();
        double d2 = 0.0;
        while (enumeration.hasMoreElements()) {
            Printout printout = (Printout)enumeration.nextElement();
            double d3 = 0.0;
            double d4 = d2;
            printout.createLayout();
            TwoD twoD = printout.getSizePixel();
            if (2.0f == printout.getLineAlignment()) {
                d3 = d / 2.0 - twoD.width / 2.0;
            } else if (3.0f == printout.getLineAlignment()) {
                d3 = d - twoD.width;
            }
            printout.setBasePoint(d3, d4);
            d2 += twoD.height;
            d2 += Units.pointToPixel(printout.getLineSpace());
        }
        return d2;
    }

    public void render(Graphics2D graphics2D) {
        if (!this.createdOutputLayout) {
            return;
        }
        int n = 0;
        while (n < this.copies) {
            int n2 = (int)Math.ceil(this.origin.getPixelX());
            int n3 = (int)Math.ceil(this.origin.getPixelY() + this.oneCopyHeightPixel * (double)n);
            Color color = graphics2D.getColor();
            graphics2D.setColor(PreferenceModel.getInstance().getColorProperty("color.page.origin"));
            graphics2D.drawLine(n2, n3, n2, n3 + (int)Units.getScreenDPI());
            graphics2D.drawLine(n2, n3, n2 + (int)Units.getScreenDPI(), n3);
            graphics2D.setColor(color);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n2, n3);
            int n4 = 0;
            while (n4 < this.printoutList.size()) {
                Printout printout = (Printout)this.printoutList.elementAt(n4);
                if (printout.isVisible(PrintCanvas.getInstance().getVisibleRect(), n3)) {
                    printout.render(graphics2D, affineTransform);
                }
                ++n4;
            }
            ++n;
        }
    }

    public PointEx getOrigin() {
        return this.origin;
    }

    public int getCopies() {
        return this.copies;
    }
}

