/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.models;

import java.awt.Color;
import java.util.Properties;
import pios.emulator.printer.PrinterEngine;

public final class PreferenceModel {
    public static final String STATE_W = "view.state.width";
    public static final String OUTPUT_W = "view.output.width";
    public static final String ZOOM = "view.output.zoom";
    public static final String CANVAS_LF = "canvas.linefeed";
    public static final String CONTINUOUS_LENGTH_MIN = "continuous.paper.length.min";
    public static final String CONTINUOUS_LENGTH_MAX = "continuous.paper.length.max";
    public static final String CONTINUOUS_LENGTH_DEFAULT = "continuous.paper.length.default";
    public static final String PAPER_COUNT_MIN = "papercount.min";
    public static final String PAPER_COUNT_DEFAULT = "pagecount.default";
    public static final String PAPER_COUNT_MAX = "pagecount.max";
    public static final String COLOR_QUIET_ZONE = "color.quietzone";
    public static final String COLOR_RULER = "color.ruler";
    public static final String COLOR_CANVAS = "color.canvas";
    public static final String COLOR_PAGEBREAK = "color.pagebreak";
    public static final String COLOR_PAGE_ORIGIN = "color.page.origin";
    public static final String RESET_ON_CAPABILITY_CHANGE = "reset.on.capability.change";
    public static final String RESET_ON_SETUP_CHANGE = "reset.on.setup.change";
    public static final String AUTO_SELECT_FONT = "auto.select.font";
    public static final String AUTO_SELECT_DPI = "auto.select.resolution";
    public static final String AUTO_SELECT_MEDIA = "auto.select.media";
    public static final String ALWAYS_VALIDATE_SETUP = "always.validate.setup";
    public static final String VALIDATION_BAR_PARAMETER = "validation.bar.parameter";
    public static final String VALIDATION_BARCODE_EX = "validation.barcode.external";
    public static final String PRINTHEAD_VISIBLE = "printhead.visible";
    public static final String QUIET_ZONE_VISIBLE = "quiet.zone.visible";
    private Properties preferences = new Properties();
    private static PreferenceModel instance = null;

    public static PreferenceModel getInstance() {
        if (null == instance) {
            instance = new PreferenceModel();
        }
        return instance;
    }

    private PreferenceModel() {
        this.InitializePreferences();
    }

    protected String getPropertyFilename() {
        return "Preferences";
    }

    protected void InitializePreferences() {
        Properties properties = PrinterEngine.loadProperties(this.getPropertyFilename());
        if (null == properties) {
            properties = this.createDefaults();
        }
        this.preferences = properties;
    }

    private Properties createDefaults() {
        Properties properties = new Properties();
        properties.setProperty(CANVAS_LF, Integer.toString(10));
        properties.setProperty(ZOOM, Integer.toString(100));
        properties.setProperty(OUTPUT_W, Integer.toString(440));
        properties.setProperty(STATE_W, Integer.toString(150));
        properties.setProperty(CONTINUOUS_LENGTH_MAX, Integer.toString(640));
        properties.setProperty(CONTINUOUS_LENGTH_MIN, Integer.toString(64));
        properties.setProperty(CONTINUOUS_LENGTH_DEFAULT, Integer.toString(320));
        properties.setProperty(PAPER_COUNT_MIN, Integer.toString(1));
        properties.setProperty(PAPER_COUNT_MAX, Integer.toString(1000));
        properties.setProperty(PAPER_COUNT_DEFAULT, Integer.toString(100));
        properties.setProperty(COLOR_PAGEBREAK, Integer.toString(Color.red.getRGB()));
        properties.setProperty(COLOR_PAGE_ORIGIN, Integer.toString(Color.blue.getRGB()));
        properties.setProperty(COLOR_QUIET_ZONE, Integer.toString(Color.green.getRGB()));
        properties.setProperty(COLOR_RULER, Integer.toString(new Color(230, 163, 4).getRGB()));
        properties.setProperty(COLOR_CANVAS, Integer.toString(Color.white.getRGB()));
        properties.setProperty(RESET_ON_CAPABILITY_CHANGE, String.valueOf(true));
        properties.setProperty(RESET_ON_SETUP_CHANGE, String.valueOf(true));
        properties.setProperty(AUTO_SELECT_FONT, String.valueOf(true));
        properties.setProperty(AUTO_SELECT_MEDIA, String.valueOf(true));
        properties.setProperty(AUTO_SELECT_DPI, String.valueOf(true));
        properties.setProperty(ALWAYS_VALIDATE_SETUP, String.valueOf(true));
        properties.setProperty(VALIDATION_BAR_PARAMETER, String.valueOf(false));
        properties.setProperty(VALIDATION_BARCODE_EX, String.valueOf(true));
        properties.setProperty(PRINTHEAD_VISIBLE, String.valueOf(true));
        properties.setProperty(QUIET_ZONE_VISIBLE, String.valueOf(false));
        PrinterEngine.storeProperties(false, this.getPropertyFilename(), properties);
        return properties;
    }

    public String getStringProperty(String string) {
        return this.preferences.getProperty(string);
    }

    public boolean getBooleanProperty(String string) {
        return Boolean.valueOf(this.preferences.getProperty(string));
    }

    public int getIntProperty(String string) {
        return Integer.parseInt(this.preferences.getProperty(string));
    }

    public Color getColorProperty(String string) {
        int n = this.getIntProperty(string);
        return new Color(n);
    }

    public final int getLinefeed() {
        return this.getIntProperty(CANVAS_LF);
    }

    public final double getOutputZoom() {
        return (double)this.getIntProperty(ZOOM) / 100.0;
    }
}

